/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.drawable.Drawable;
import com.airbnb.lottie.AnimatableFloatValue;
import com.airbnb.lottie.AnimatableLayer;
import com.airbnb.lottie.AnimatableTransform;
import com.airbnb.lottie.BaseKeyframeAnimation;
import com.airbnb.lottie.KeyframeAnimation;
import com.airbnb.lottie.PolystarShape;
import com.airbnb.lottie.ShapeFill;
import com.airbnb.lottie.ShapeLayer;
import com.airbnb.lottie.ShapeStroke;
import com.airbnb.lottie.ShapeTrimPath;
import com.airbnb.lottie.StaticKeyframeAnimation;
import java.util.ArrayList;

class PolystarLayer
extends AnimatableLayer {
    PolystarLayer(PolystarShape polystarShape, ShapeFill fill, ShapeStroke stroke, ShapeTrimPath trim, AnimatableTransform transform, Drawable.Callback callback) {
        super(callback);
        this.setTransform(transform.createAnimation());
        if (fill != null) {
            PolystarShapeLayer fillLayer = new PolystarShapeLayer(this.getCallback());
            fillLayer.setColor((KeyframeAnimation<Integer>)fill.getColor().createAnimation());
            fillLayer.setTransformOpacity((KeyframeAnimation<Integer>)transform.getOpacity().createAnimation());
            fillLayer.setShapeOpacity((KeyframeAnimation<Integer>)fill.getOpacity().createAnimation());
            fillLayer.setShape(polystarShape);
            if (trim != null) {
                fillLayer.setTrimPath((KeyframeAnimation<Float>)trim.getStart().createAnimation(), (KeyframeAnimation<Float>)trim.getEnd().createAnimation(), (KeyframeAnimation<Float>)trim.getOffset().createAnimation());
            }
            this.addLayer(fillLayer);
        }
        if (stroke != null) {
            PolystarShapeLayer strokeLayer = new PolystarShapeLayer(this.getCallback());
            strokeLayer.setIsStroke();
            strokeLayer.setColor((KeyframeAnimation<Integer>)stroke.getColor().createAnimation());
            strokeLayer.setTransformOpacity((KeyframeAnimation<Integer>)transform.getOpacity().createAnimation());
            strokeLayer.setShapeOpacity((KeyframeAnimation<Integer>)stroke.getOpacity().createAnimation());
            strokeLayer.setLineWidth((KeyframeAnimation<Float>)stroke.getWidth().createAnimation());
            if (!stroke.getLineDashPattern().isEmpty()) {
                ArrayList dashPatternAnimations = new ArrayList(stroke.getLineDashPattern().size());
                for (AnimatableFloatValue dashPattern : stroke.getLineDashPattern()) {
                    dashPatternAnimations.add(dashPattern.createAnimation());
                }
                strokeLayer.setDashPattern(dashPatternAnimations, stroke.getDashOffset().createAnimation());
            }
            strokeLayer.setLineCapType(stroke.getCapType());
            strokeLayer.setShape(polystarShape);
            if (trim != null) {
                strokeLayer.setTrimPath((KeyframeAnimation<Float>)trim.getStart().createAnimation(), (KeyframeAnimation<Float>)trim.getEnd().createAnimation(), (KeyframeAnimation<Float>)trim.getOffset().createAnimation());
            }
            this.addLayer(strokeLayer);
        }
    }

    private static final class PolystarShapeLayer
    extends ShapeLayer {
        private static final float POLYSTAR_MAGIC_NUMBER = 0.47829f;
        private static final float POLYGON_MAGIC_NUMBER = 0.25f;
        private final BaseKeyframeAnimation.AnimationListener<PointF> pointChangedListener = new BaseKeyframeAnimation.AnimationListener<PointF>(){

            @Override
            public void onValueChanged(PointF value) {
                PolystarShapeLayer.this.onPolystarChanged();
            }
        };
        private final BaseKeyframeAnimation.AnimationListener<Float> floatChangedListener = new BaseKeyframeAnimation.AnimationListener<Float>(){

            @Override
            public void onValueChanged(Float value) {
                PolystarShapeLayer.this.onPolystarChanged();
            }
        };
        private final Path path = new Path();
        private PolystarShape.Type type;
        private BaseKeyframeAnimation<?, Float> pointsAnimation;
        private BaseKeyframeAnimation<?, PointF> positionAnimation;
        private BaseKeyframeAnimation<?, Float> rotationAnimation;
        private BaseKeyframeAnimation<?, Float> outerRadiusAnimation;
        private BaseKeyframeAnimation<?, Float> outerRoundednessAnimation;
        private BaseKeyframeAnimation<?, Float> innerRadiusAnimation;
        private BaseKeyframeAnimation<?, Float> innerRoundednessAnimation;

        PolystarShapeLayer(Drawable.Callback callback) {
            super(callback);
            this.setPath(new StaticKeyframeAnimation<Path>(this.path));
        }

        void setShape(PolystarShape polystarShape) {
            this.type = polystarShape.getType();
            if (this.pointsAnimation != null) {
                this.removeAnimation(this.pointsAnimation);
            }
            if (this.positionAnimation != null) {
                this.removeAnimation(this.positionAnimation);
            }
            if (this.rotationAnimation != null) {
                this.removeAnimation(this.rotationAnimation);
            }
            if (this.outerRadiusAnimation != null) {
                this.removeAnimation(this.outerRadiusAnimation);
            }
            if (this.outerRoundednessAnimation != null) {
                this.removeAnimation(this.outerRoundednessAnimation);
            }
            if (this.innerRadiusAnimation != null) {
                this.removeAnimation(this.innerRadiusAnimation);
            }
            if (this.innerRoundednessAnimation != null) {
                this.removeAnimation(this.innerRoundednessAnimation);
            }
            this.pointsAnimation = polystarShape.getPoints().createAnimation();
            this.positionAnimation = polystarShape.getPosition().createAnimation();
            this.rotationAnimation = polystarShape.getRotation().createAnimation();
            this.outerRadiusAnimation = polystarShape.getOuterRadius().createAnimation();
            this.outerRoundednessAnimation = polystarShape.getOuterRoundedness().createAnimation();
            if (polystarShape.getInnerRadius() != null) {
                this.innerRadiusAnimation = polystarShape.getInnerRadius().createAnimation();
            }
            if (polystarShape.getInnerRoundedness() != null) {
                this.innerRoundednessAnimation = polystarShape.getInnerRoundedness().createAnimation();
            }
            this.pointsAnimation.addUpdateListener(this.floatChangedListener);
            this.positionAnimation.addUpdateListener(this.pointChangedListener);
            this.rotationAnimation.addUpdateListener(this.floatChangedListener);
            this.outerRadiusAnimation.addUpdateListener(this.floatChangedListener);
            this.outerRoundednessAnimation.addUpdateListener(this.floatChangedListener);
            if (this.innerRadiusAnimation != null) {
                this.innerRadiusAnimation.addUpdateListener(this.floatChangedListener);
            }
            if (this.innerRoundednessAnimation != null) {
                this.innerRoundednessAnimation.addUpdateListener(this.floatChangedListener);
            }
            this.addAnimation(this.pointsAnimation);
            this.addAnimation(this.positionAnimation);
            this.addAnimation(this.rotationAnimation);
            this.addAnimation(this.outerRadiusAnimation);
            this.addAnimation(this.outerRoundednessAnimation);
            if (this.innerRadiusAnimation != null) {
                this.addAnimation(this.innerRadiusAnimation);
            }
            if (this.innerRoundednessAnimation != null) {
                this.addAnimation(this.innerRoundednessAnimation);
            }
            this.onPolystarChanged();
        }

        private void onPolystarChanged() {
            switch (this.type) {
                case Star: {
                    this.createStarPath();
                    break;
                }
                case Polygon: {
                    this.createPolygonPath();
                }
            }
            this.onPathChanged();
        }

        private void createStarPath() {
            float y;
            float x;
            float points = this.pointsAnimation.getValue().floatValue();
            double currentAngle = this.rotationAnimation == null ? 0.0 : (double)this.rotationAnimation.getValue().floatValue();
            currentAngle -= 90.0;
            currentAngle = Math.toRadians(currentAngle);
            float anglePerPoint = (float)(Math.PI * 2 / (double)points);
            float halfAnglePerPoint = anglePerPoint / 2.0f;
            float partialPointAmount = points - (float)((int)points);
            if (partialPointAmount != 0.0f) {
                currentAngle += (double)(halfAnglePerPoint * (1.0f - partialPointAmount));
            }
            float outerRadius = this.outerRadiusAnimation.getValue().floatValue();
            float innerRadius = this.innerRadiusAnimation.getValue().floatValue();
            float innerRoundedness = 0.0f;
            if (this.innerRoundednessAnimation != null) {
                innerRoundedness = this.innerRoundednessAnimation.getValue().floatValue() / 100.0f;
            }
            float outerRoundedness = 0.0f;
            if (this.outerRoundednessAnimation != null) {
                outerRoundedness = this.outerRoundednessAnimation.getValue().floatValue() / 100.0f;
            }
            this.path.reset();
            float partialPointRadius = 0.0f;
            if (partialPointAmount != 0.0f) {
                partialPointRadius = innerRadius + partialPointAmount * (outerRadius - innerRadius);
                x = (float)((double)partialPointRadius * Math.cos(currentAngle));
                y = (float)((double)partialPointRadius * Math.sin(currentAngle));
                this.path.moveTo(x, y);
                currentAngle += (double)(anglePerPoint * partialPointAmount / 2.0f);
            } else {
                x = (float)((double)outerRadius * Math.cos(currentAngle));
                y = (float)((double)outerRadius * Math.sin(currentAngle));
                this.path.moveTo(x, y);
                currentAngle += (double)halfAnglePerPoint;
            }
            boolean longSegment = false;
            double numPoints = Math.ceil(points) * 2.0;
            int i = 0;
            while ((double)i < numPoints) {
                float radius = longSegment ? outerRadius : innerRadius;
                float dTheta = halfAnglePerPoint;
                if (partialPointRadius != 0.0f && (double)i == numPoints - 2.0) {
                    dTheta = anglePerPoint * partialPointAmount / 2.0f;
                }
                if (partialPointRadius != 0.0f && (double)i == numPoints - 1.0) {
                    radius = partialPointRadius;
                }
                float previousX = x;
                float previousY = y;
                x = (float)((double)radius * Math.cos(currentAngle));
                y = (float)((double)radius * Math.sin(currentAngle));
                if (innerRoundedness == 0.0f && outerRoundedness == 0.0f) {
                    this.path.lineTo(x, y);
                } else {
                    float cp1Theta = (float)(Math.atan2(previousY, previousX) - 1.5707963267948966);
                    float cp1Dx = (float)Math.cos(cp1Theta);
                    float cp1Dy = (float)Math.sin(cp1Theta);
                    float cp2Theta = (float)(Math.atan2(y, x) - 1.5707963267948966);
                    float cp2Dx = (float)Math.cos(cp2Theta);
                    float cp2Dy = (float)Math.sin(cp2Theta);
                    float cp1Roundedness = longSegment ? innerRoundedness : outerRoundedness;
                    float cp2Roundedness = longSegment ? outerRoundedness : innerRoundedness;
                    float cp1Radius = longSegment ? innerRadius : outerRadius;
                    float cp2Radius = longSegment ? outerRadius : innerRadius;
                    float cp1x = cp1Radius * cp1Roundedness * 0.47829f * cp1Dx;
                    float cp1y = cp1Radius * cp1Roundedness * 0.47829f * cp1Dy;
                    float cp2x = cp2Radius * cp2Roundedness * 0.47829f * cp2Dx;
                    float cp2y = cp2Radius * cp2Roundedness * 0.47829f * cp2Dy;
                    if (partialPointAmount != 0.0f) {
                        if (i == 0) {
                            cp1x *= partialPointAmount;
                            cp1y *= partialPointAmount;
                        } else if ((double)i == numPoints - 1.0) {
                            cp2x *= partialPointAmount;
                            cp2y *= partialPointAmount;
                        }
                    }
                    this.path.cubicTo(previousX - cp1x, previousY - cp1y, x + cp2x, y + cp2y, x, y);
                }
                currentAngle += (double)dTheta;
                longSegment = !longSegment;
                ++i;
            }
            PointF position = this.positionAnimation.getValue();
            this.path.offset(position.x, position.y);
            this.path.close();
        }

        private void createPolygonPath() {
            int points = (int)Math.floor(this.pointsAnimation.getValue().floatValue());
            double currentAngle = this.rotationAnimation == null ? 0.0 : (double)this.rotationAnimation.getValue().floatValue();
            currentAngle -= 90.0;
            currentAngle = Math.toRadians(currentAngle);
            float anglePerPoint = (float)(Math.PI * 2 / (double)points);
            this.path.reset();
            float roundedness = this.outerRoundednessAnimation.getValue().floatValue() / 100.0f;
            float radius = this.outerRadiusAnimation.getValue().floatValue();
            float x = (float)((double)radius * Math.cos(currentAngle));
            float y = (float)((double)radius * Math.sin(currentAngle));
            this.path.moveTo(x, y);
            currentAngle += (double)anglePerPoint;
            double numPoints = Math.ceil(points);
            int i = 0;
            while ((double)i < numPoints) {
                float previousX = x;
                float previousY = y;
                x = (float)((double)radius * Math.cos(currentAngle));
                y = (float)((double)radius * Math.sin(currentAngle));
                if (roundedness != 0.0f) {
                    float cp1Theta = (float)(Math.atan2(previousY, previousX) - 1.5707963267948966);
                    float cp1Dx = (float)Math.cos(cp1Theta);
                    float cp1Dy = (float)Math.sin(cp1Theta);
                    float cp2Theta = (float)(Math.atan2(y, x) - 1.5707963267948966);
                    float cp2Dx = (float)Math.cos(cp2Theta);
                    float cp2Dy = (float)Math.sin(cp2Theta);
                    float cp1x = radius * roundedness * 0.25f * cp1Dx;
                    float cp1y = radius * roundedness * 0.25f * cp1Dy;
                    float cp2x = radius * roundedness * 0.25f * cp2Dx;
                    float cp2y = radius * roundedness * 0.25f * cp2Dy;
                    this.path.cubicTo(previousX - cp1x, previousY - cp1y, x + cp2x, y + cp2y, x, y);
                } else {
                    this.path.lineTo(x, y);
                }
                currentAngle += (double)anglePerPoint;
                ++i;
            }
            PointF position = this.positionAnimation.getValue();
            this.path.offset(position.x, position.y);
            this.path.close();
        }
    }
}

