/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.LongSparseArray;
import android.view.View;
import android.view.animation.LinearInterpolator;
import com.airbnb.lottie.AnimatableLayer;
import com.airbnb.lottie.ImageAssetBitmapManager;
import com.airbnb.lottie.ImageAssetDelegate;
import com.airbnb.lottie.Layer;
import com.airbnb.lottie.LayerView;
import com.airbnb.lottie.LottieComposition;
import java.util.ArrayList;

public class LottieDrawable
extends AnimatableLayer
implements Drawable.Callback {
    private LottieComposition composition;
    private final ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
    private float speed = 1.0f;
    private float scale = 1.0f;
    @Nullable
    private ImageAssetBitmapManager imageAssetBitmapManager;
    @Nullable
    private String imageAssetsFolder;
    @Nullable
    private ImageAssetDelegate imageAssetDelegate;
    private boolean playAnimationWhenLayerAdded;
    private boolean reverseAnimationWhenLayerAdded;
    private boolean systemAnimationsAreDisabled;

    public LottieDrawable() {
        super(null);
        this.animator.setRepeatCount(0);
        this.animator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        this.animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                if (LottieDrawable.this.systemAnimationsAreDisabled) {
                    LottieDrawable.this.animator.cancel();
                    LottieDrawable.this.setProgress(1.0f);
                } else {
                    LottieDrawable.this.setProgress(((Float)animation.getAnimatedValue()).floatValue());
                }
            }
        });
    }

    public boolean hasMasks() {
        for (AnimatableLayer layer : this.layers) {
            if (!(layer instanceof LayerView) || !((LayerView)layer).hasMasks()) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatte() {
        for (AnimatableLayer layer : this.layers) {
            if (!(layer instanceof LayerView) || !((LayerView)layer).hasMatte()) continue;
            return true;
        }
        return false;
    }

    public void setImagesAssetsFolder(@Nullable String imageAssetsFolder) {
        this.imageAssetsFolder = imageAssetsFolder;
    }

    public void recycleBitmaps() {
        if (this.imageAssetBitmapManager != null) {
            this.imageAssetBitmapManager.recycleBitmaps();
        }
    }

    public boolean setComposition(LottieComposition composition) {
        if (this.getCallback() == null) {
            throw new IllegalStateException("You or your view must set a Drawable.Callback before setting the composition. This gets done automatically when added to an ImageView. Either call ImageView.setImageDrawable() before setComposition() or call setCallback(yourView.getCallback()) first.");
        }
        if (this.composition == composition) {
            return false;
        }
        this.clearComposition();
        this.composition = composition;
        this.setSpeed(this.speed);
        this.setScale(1.0f);
        this.updateBounds();
        this.buildLayersForComposition(composition);
        this.setProgress(this.getProgress());
        return true;
    }

    private void clearComposition() {
        this.recycleBitmaps();
        this.clearLayers();
        this.imageAssetBitmapManager = null;
    }

    private void buildLayersForComposition(LottieComposition composition) {
        int i;
        if (composition == null) {
            throw new IllegalStateException("Composition is null");
        }
        LongSparseArray layerMap = new LongSparseArray(composition.getLayers().size());
        ArrayList<LayerView> layers = new ArrayList<LayerView>(composition.getLayers().size());
        LayerView mattedLayer = null;
        for (i = composition.getLayers().size() - 1; i >= 0; --i) {
            Layer layer = composition.getLayers().get(i);
            LayerView layerView = new LayerView(layer, composition, this);
            layerMap.put(layerView.getId(), (Object)layerView);
            if (mattedLayer != null) {
                mattedLayer.setMatteLayer(layerView);
                mattedLayer = null;
                continue;
            }
            layers.add(layerView);
            if (layer.getMatteType() == Layer.MatteType.Add) {
                mattedLayer = layerView;
                continue;
            }
            if (layer.getMatteType() != Layer.MatteType.Invert) continue;
            mattedLayer = layerView;
        }
        for (i = 0; i < layers.size(); ++i) {
            LayerView layerView = (LayerView)((Object)layers.get(i));
            this.addLayer(layerView);
        }
        for (i = 0; i < layerMap.size(); ++i) {
            long key = layerMap.keyAt(i);
            LayerView layerView = (LayerView)((Object)layerMap.get(key));
            LayerView parentLayer = (LayerView)((Object)layerMap.get(layerView.getLayerModel().getParentId()));
            if (parentLayer == null) continue;
            layerView.setParentLayer(parentLayer);
        }
    }

    public void invalidateSelf() {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.invalidateDrawable((Drawable)this);
        }
    }

    @Override
    public void draw(@NonNull Canvas canvas) {
        if (this.composition == null) {
            return;
        }
        int saveCount = canvas.save();
        canvas.clipRect(0, 0, this.getIntrinsicWidth(), this.getIntrinsicHeight());
        super.draw(canvas);
        canvas.restoreToCount(saveCount);
    }

    void systemAnimationsAreDisabled() {
        this.systemAnimationsAreDisabled = true;
    }

    void loop(boolean loop) {
        this.animator.setRepeatCount(loop ? -1 : 0);
    }

    boolean isLooping() {
        return this.animator.getRepeatCount() == -1;
    }

    boolean isAnimating() {
        return this.animator.isRunning();
    }

    public void playAnimation() {
        this.playAnimation(false);
    }

    public void resumeAnimation() {
        this.playAnimation(true);
    }

    private void playAnimation(boolean setStartTime) {
        if (this.layers.isEmpty()) {
            this.playAnimationWhenLayerAdded = true;
            this.reverseAnimationWhenLayerAdded = false;
            return;
        }
        if (setStartTime) {
            this.animator.setCurrentPlayTime((long)(this.getProgress() * (float)this.animator.getDuration()));
        }
        this.animator.start();
    }

    public void resumeReverseAnimation() {
        this.reverseAnimation(true);
    }

    public void reverseAnimation() {
        this.reverseAnimation(false);
    }

    private void reverseAnimation(boolean setStartTime) {
        if (this.layers.isEmpty()) {
            this.playAnimationWhenLayerAdded = false;
            this.reverseAnimationWhenLayerAdded = true;
            return;
        }
        if (setStartTime) {
            this.animator.setCurrentPlayTime((long)(this.getProgress() * (float)this.animator.getDuration()));
        }
        this.animator.reverse();
    }

    public void setSpeed(float speed) {
        this.speed = speed;
        if (speed < 0.0f) {
            this.animator.setFloatValues(new float[]{1.0f, 0.0f});
        } else {
            this.animator.setFloatValues(new float[]{0.0f, 1.0f});
        }
        if (this.composition != null) {
            this.animator.setDuration((long)((float)this.composition.getDuration() / Math.abs(speed)));
        }
    }

    public void setScale(float scale) {
        this.scale = scale;
        this.updateBounds();
    }

    public void setImageAssetDelegate(ImageAssetDelegate assetDelegate) {
        this.imageAssetDelegate = assetDelegate;
        if (this.imageAssetBitmapManager != null) {
            this.imageAssetBitmapManager.setAssetDelegate(assetDelegate);
        }
    }

    public float getScale() {
        return this.scale;
    }

    private void updateBounds() {
        if (this.composition == null) {
            return;
        }
        this.setBounds(0, 0, (int)((float)this.composition.getBounds().width() * this.scale), (int)((float)this.composition.getBounds().height() * this.scale));
    }

    void cancelAnimation() {
        this.playAnimationWhenLayerAdded = false;
        this.reverseAnimationWhenLayerAdded = false;
        this.animator.cancel();
    }

    @Override
    void addLayer(AnimatableLayer layer) {
        super.addLayer(layer);
        if (this.playAnimationWhenLayerAdded) {
            this.playAnimationWhenLayerAdded = false;
            this.playAnimation();
        }
        if (this.reverseAnimationWhenLayerAdded) {
            this.reverseAnimationWhenLayerAdded = false;
            this.reverseAnimation();
        }
    }

    void addAnimatorUpdateListener(ValueAnimator.AnimatorUpdateListener updateListener) {
        this.animator.addUpdateListener(updateListener);
    }

    void removeAnimatorUpdateListener(ValueAnimator.AnimatorUpdateListener updateListener) {
        this.animator.removeUpdateListener(updateListener);
    }

    void addAnimatorListener(Animator.AnimatorListener listener) {
        this.animator.addListener(listener);
    }

    void removeAnimatorListener(Animator.AnimatorListener listener) {
        this.animator.removeListener(listener);
    }

    public int getIntrinsicWidth() {
        return this.composition == null ? -1 : (int)((float)this.composition.getBounds().width() * this.scale);
    }

    public int getIntrinsicHeight() {
        return this.composition == null ? -1 : (int)((float)this.composition.getBounds().height() * this.scale);
    }

    Bitmap getImageAsset(String id) {
        return this.getImageAssetBitmapManager().bitmapForId(id);
    }

    private ImageAssetBitmapManager getImageAssetBitmapManager() {
        if (this.imageAssetBitmapManager != null && !this.imageAssetBitmapManager.hasSameContext(this.getContext())) {
            this.imageAssetBitmapManager.recycleBitmaps();
            this.imageAssetBitmapManager = null;
        }
        if (this.imageAssetBitmapManager == null) {
            this.imageAssetBitmapManager = new ImageAssetBitmapManager(this.getCallback(), this.imageAssetsFolder, this.imageAssetDelegate, this.composition.getImages());
        }
        return this.imageAssetBitmapManager;
    }

    @Nullable
    private Context getContext() {
        Drawable.Callback callback = this.getCallback();
        if (callback == null) {
            return null;
        }
        if (callback instanceof View) {
            return ((View)callback).getContext();
        }
        return null;
    }

    public void invalidateDrawable(Drawable who) {
        Drawable.Callback callback = this.getCallback();
        if (callback == null) {
            return;
        }
        callback.invalidateDrawable((Drawable)this);
    }

    public void scheduleDrawable(Drawable who, Runnable what, long when) {
        Drawable.Callback callback = this.getCallback();
        if (callback == null) {
            return;
        }
        callback.scheduleDrawable((Drawable)this, what, when);
    }

    public void unscheduleDrawable(Drawable who, Runnable what) {
        Drawable.Callback callback = this.getCallback();
        if (callback == null) {
            return;
        }
        callback.unscheduleDrawable((Drawable)this, what);
    }
}

