/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.provider.Settings;
import android.support.annotation.FloatRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.support.v7.widget.AppCompatImageView;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import com.airbnb.lottie.Cancellable;
import com.airbnb.lottie.ImageAssetDelegate;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.LottieDrawable;
import com.airbnb.lottie.OnCompositionLoadedListener;
import com.airbnb.lottie.R;
import com.airbnb.lottie.Utils;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class LottieAnimationView
extends AppCompatImageView {
    private static final String TAG = LottieAnimationView.class.getSimpleName();
    private static final Map<String, LottieComposition> strongRefCache = new HashMap<String, LottieComposition>();
    private static final Map<String, WeakReference<LottieComposition>> weakRefCache = new HashMap<String, WeakReference<LottieComposition>>();
    private final OnCompositionLoadedListener loadedListener = new OnCompositionLoadedListener(){

        @Override
        public void onCompositionLoaded(LottieComposition composition) {
            LottieAnimationView.this.setComposition(composition);
            LottieAnimationView.this.compositionLoader = null;
        }
    };
    private final LottieDrawable lottieDrawable = new LottieDrawable();
    private CacheStrategy defaultCacheStrategy;
    private String animationName;
    @Nullable
    private Cancellable compositionLoader;
    @Nullable
    private LottieComposition composition;

    public LottieAnimationView(Context context) {
        super(context);
        this.init(null);
    }

    public LottieAnimationView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public LottieAnimationView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    private void init(@Nullable AttributeSet attrs) {
        float systemAnimationScale;
        TypedArray ta = this.getContext().obtainStyledAttributes(attrs, R.styleable.LottieAnimationView);
        String fileName = ta.getString(R.styleable.LottieAnimationView_lottie_fileName);
        if (!this.isInEditMode() && fileName != null) {
            this.setAnimation(fileName);
        }
        if (ta.getBoolean(R.styleable.LottieAnimationView_lottie_autoPlay, false)) {
            this.lottieDrawable.playAnimation();
        }
        this.lottieDrawable.loop(ta.getBoolean(R.styleable.LottieAnimationView_lottie_loop, false));
        this.setImageAssetsFolder(ta.getString(R.styleable.LottieAnimationView_lottie_imageAssetsFolder));
        this.setProgress(ta.getFloat(R.styleable.LottieAnimationView_lottie_progress, 0.0f));
        int cacheStrategy = ta.getInt(R.styleable.LottieAnimationView_lottie_cacheStrategy, CacheStrategy.None.ordinal());
        this.defaultCacheStrategy = CacheStrategy.values()[cacheStrategy];
        ta.recycle();
        this.setLayerType(1, null);
        if (Build.VERSION.SDK_INT >= 17 && (systemAnimationScale = Settings.Global.getFloat((ContentResolver)this.getContext().getContentResolver(), (String)"animator_duration_scale", (float)1.0f)) == 0.0f) {
            this.lottieDrawable.systemAnimationsAreDisabled();
        }
    }

    public void setImageResource(int resId) {
        super.setImageResource(resId);
        this.recycleBitmaps();
    }

    public void setImageDrawable(Drawable drawable) {
        if (drawable != this.lottieDrawable) {
            this.recycleBitmaps();
        }
        super.setImageDrawable(drawable);
    }

    public void invalidateDrawable(Drawable dr) {
        if (this.getDrawable() == this.lottieDrawable) {
            super.invalidateDrawable((Drawable)this.lottieDrawable);
        }
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.animationName = this.animationName;
        ss.progress = this.lottieDrawable.getProgress();
        ss.isAnimating = this.lottieDrawable.isAnimating();
        ss.isLooping = this.lottieDrawable.isLooping();
        return ss;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.animationName = ss.animationName;
        if (!TextUtils.isEmpty((CharSequence)this.animationName)) {
            this.setAnimation(this.animationName);
        }
        this.setProgress(ss.progress);
        this.loop(ss.isLooping);
        if (ss.isAnimating) {
            this.playAnimation();
        }
    }

    protected void onDetachedFromWindow() {
        this.recycleBitmaps();
        super.onDetachedFromWindow();
    }

    @VisibleForTesting
    void recycleBitmaps() {
        this.lottieDrawable.recycleBitmaps();
    }

    public void setAnimation(String animationName) {
        this.setAnimation(animationName, this.defaultCacheStrategy);
    }

    public void setAnimation(final String animationName, final CacheStrategy cacheStrategy) {
        this.animationName = animationName;
        if (weakRefCache.containsKey(animationName)) {
            WeakReference<LottieComposition> compRef = weakRefCache.get(animationName);
            if (compRef.get() != null) {
                this.setComposition((LottieComposition)compRef.get());
                return;
            }
        } else if (strongRefCache.containsKey(animationName)) {
            this.setComposition(strongRefCache.get(animationName));
            return;
        }
        this.animationName = animationName;
        this.lottieDrawable.cancelAnimation();
        this.cancelLoaderTask();
        this.compositionLoader = LottieComposition.Factory.fromAssetFileName(this.getContext(), animationName, new OnCompositionLoadedListener(){

            @Override
            public void onCompositionLoaded(LottieComposition composition) {
                if (cacheStrategy == CacheStrategy.Strong) {
                    strongRefCache.put(animationName, composition);
                } else if (cacheStrategy == CacheStrategy.Weak) {
                    weakRefCache.put(animationName, new WeakReference<LottieComposition>(composition));
                }
                LottieAnimationView.this.setComposition(composition);
            }
        });
    }

    public void setAnimation(JSONObject json) {
        this.cancelLoaderTask();
        this.compositionLoader = LottieComposition.Factory.fromJson(this.getResources(), json, this.loadedListener);
    }

    private void cancelLoaderTask() {
        if (this.compositionLoader != null) {
            this.compositionLoader.cancel();
            this.compositionLoader = null;
        }
    }

    public void setComposition(@NonNull LottieComposition composition) {
        this.lottieDrawable.setCallback((Drawable.Callback)this);
        boolean isNewComposition = this.lottieDrawable.setComposition(composition);
        if (!isNewComposition) {
            return;
        }
        int screenWidth = Utils.getScreenWidth(this.getContext());
        int screenHeight = Utils.getScreenHeight(this.getContext());
        int compWidth = composition.getBounds().width();
        int compHeight = composition.getBounds().height();
        if (compWidth > screenWidth || compHeight > screenHeight) {
            float xScale = (float)screenWidth / (float)compWidth;
            float yScale = (float)screenHeight / (float)compHeight;
            this.setScale(Math.min(xScale, yScale));
            Log.w((String)"LOTTIE", (String)String.format("Composition larger than the screen %dx%d vs %dx%d. Scaling down.", compWidth, compHeight, screenWidth, screenHeight));
        }
        this.setImageDrawable(null);
        this.setImageDrawable(this.lottieDrawable);
        this.composition = composition;
        this.requestLayout();
    }

    public boolean hasMasks() {
        return this.lottieDrawable.hasMasks();
    }

    public boolean hasMatte() {
        return this.lottieDrawable.hasMatte();
    }

    public void setImageAssetsFolder(String imageAssetsFolder) {
        this.lottieDrawable.setImagesAssetsFolder(imageAssetsFolder);
    }

    public void addAnimatorUpdateListener(ValueAnimator.AnimatorUpdateListener updateListener) {
        this.lottieDrawable.addAnimatorUpdateListener(updateListener);
    }

    public void removeUpdateListener(ValueAnimator.AnimatorUpdateListener updateListener) {
        this.lottieDrawable.removeAnimatorUpdateListener(updateListener);
    }

    public void addAnimatorListener(Animator.AnimatorListener listener) {
        this.lottieDrawable.addAnimatorListener(listener);
    }

    public void removeAnimatorListener(Animator.AnimatorListener listener) {
        this.lottieDrawable.removeAnimatorListener(listener);
    }

    public void loop(boolean loop) {
        this.lottieDrawable.loop(loop);
    }

    public boolean isAnimating() {
        return this.lottieDrawable.isAnimating();
    }

    public void playAnimation() {
        this.lottieDrawable.playAnimation();
    }

    public void resumeAnimation() {
        this.lottieDrawable.resumeAnimation();
    }

    public void reverseAnimation() {
        this.lottieDrawable.reverseAnimation();
    }

    public void resumeReverseAnimation() {
        this.lottieDrawable.resumeReverseAnimation();
    }

    public void setSpeed(float speed) {
        this.lottieDrawable.setSpeed(speed);
    }

    public void setImageAssetDelegate(ImageAssetDelegate assetDelegate) {
        this.lottieDrawable.setImageAssetDelegate(assetDelegate);
    }

    void setScale(float scale) {
        this.lottieDrawable.setScale(scale);
        this.setImageDrawable(null);
        this.setImageDrawable(this.lottieDrawable);
    }

    public void cancelAnimation() {
        this.lottieDrawable.cancelAnimation();
    }

    public void pauseAnimation() {
        float progress = this.getProgress();
        this.lottieDrawable.cancelAnimation();
        this.setProgress(progress);
    }

    public void setProgress(@FloatRange(from=0.0, to=1.0) float progress) {
        this.lottieDrawable.setProgress(progress);
    }

    @FloatRange(from=0.0, to=1.0)
    public float getProgress() {
        return this.lottieDrawable.getProgress();
    }

    public long getDuration() {
        return this.composition != null ? this.composition.getDuration() : 0L;
    }

    private static class SavedState
    extends View.BaseSavedState {
        String animationName;
        float progress;
        boolean isAnimating;
        boolean isLooping;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.animationName = in.readString();
            this.progress = in.readFloat();
            this.isAnimating = in.readInt() == 1;
            this.isLooping = in.readInt() == 1;
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeString(this.animationName);
            out.writeFloat(this.progress);
            out.writeInt(this.isAnimating ? 1 : 0);
            out.writeInt(this.isLooping ? 1 : 0);
        }
    }

    public static enum CacheStrategy {
        None,
        Weak,
        Strong;

    }
}

