/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.drawable.Drawable;
import com.airbnb.lottie.AnimatableFloatValue;
import com.airbnb.lottie.AnimatableLayer;
import com.airbnb.lottie.AnimatableTransform;
import com.airbnb.lottie.BaseKeyframeAnimation;
import com.airbnb.lottie.CircleShape;
import com.airbnb.lottie.KeyframeAnimation;
import com.airbnb.lottie.ShapeFill;
import com.airbnb.lottie.ShapeLayer;
import com.airbnb.lottie.ShapeStroke;
import com.airbnb.lottie.ShapeTrimPath;
import com.airbnb.lottie.StaticKeyframeAnimation;
import java.util.ArrayList;

class EllipseLayer
extends AnimatableLayer {
    EllipseLayer(CircleShape circleShape, ShapeFill fill, ShapeStroke stroke, ShapeTrimPath trim, AnimatableTransform transform, Drawable.Callback callback) {
        super(callback);
        this.setTransform(transform.createAnimation());
        if (fill != null) {
            EllipseShapeLayer fillLayer = new EllipseShapeLayer(this.getCallback());
            fillLayer.setColor((KeyframeAnimation<Integer>)fill.getColor().createAnimation());
            fillLayer.setTransformOpacity((KeyframeAnimation<Integer>)transform.getOpacity().createAnimation());
            fillLayer.setShapeOpacity((KeyframeAnimation<Integer>)fill.getOpacity().createAnimation());
            fillLayer.updateCircle(circleShape.getPosition().createAnimation(), circleShape.getSize().createAnimation());
            if (trim != null) {
                fillLayer.setTrimPath((KeyframeAnimation<Float>)trim.getStart().createAnimation(), (KeyframeAnimation<Float>)trim.getEnd().createAnimation(), (KeyframeAnimation<Float>)trim.getOffset().createAnimation());
            }
            this.addLayer(fillLayer);
        }
        if (stroke != null) {
            EllipseShapeLayer strokeLayer = new EllipseShapeLayer(this.getCallback());
            strokeLayer.setIsStroke();
            strokeLayer.setColor((KeyframeAnimation<Integer>)stroke.getColor().createAnimation());
            strokeLayer.setTransformOpacity((KeyframeAnimation<Integer>)stroke.getOpacity().createAnimation());
            strokeLayer.setShapeOpacity((KeyframeAnimation<Integer>)stroke.getOpacity().createAnimation());
            strokeLayer.setLineWidth((KeyframeAnimation<Float>)stroke.getWidth().createAnimation());
            if (!stroke.getLineDashPattern().isEmpty()) {
                ArrayList dashPatternAnimations = new ArrayList(stroke.getLineDashPattern().size());
                for (AnimatableFloatValue dashPattern : stroke.getLineDashPattern()) {
                    dashPatternAnimations.add(dashPattern.createAnimation());
                }
                strokeLayer.setDashPattern(dashPatternAnimations, stroke.getDashOffset().createAnimation());
            }
            strokeLayer.setLineCapType(stroke.getCapType());
            strokeLayer.updateCircle(circleShape.getPosition().createAnimation(), circleShape.getSize().createAnimation());
            if (trim != null) {
                strokeLayer.setTrimPath((KeyframeAnimation<Float>)trim.getStart().createAnimation(), (KeyframeAnimation<Float>)trim.getEnd().createAnimation(), (KeyframeAnimation<Float>)trim.getOffset().createAnimation());
            }
            this.addLayer(strokeLayer);
        }
    }

    private static final class EllipseShapeLayer
    extends ShapeLayer {
        private static final float ELLIPSE_CONTROL_POINT_PERCENTAGE = 0.55228f;
        private final BaseKeyframeAnimation.AnimationListener<PointF> circleSizeChangedListener = new BaseKeyframeAnimation.AnimationListener<PointF>(){

            @Override
            public void onValueChanged(PointF value) {
                EllipseShapeLayer.this.onCircleSizeChanged();
            }
        };
        private final BaseKeyframeAnimation.AnimationListener<PointF> circlePositionChangedListener = new BaseKeyframeAnimation.AnimationListener<PointF>(){

            @Override
            public void onValueChanged(PointF value) {
                EllipseShapeLayer.this.invalidateSelf();
            }
        };
        private final Path path = new Path();
        private BaseKeyframeAnimation<?, PointF> circleSize;
        private BaseKeyframeAnimation<?, PointF> circlePosition;

        EllipseShapeLayer(Drawable.Callback callback) {
            super(callback);
            this.setPath(new StaticKeyframeAnimation<Path>(this.path));
        }

        void updateCircle(BaseKeyframeAnimation<?, PointF> circlePosition, BaseKeyframeAnimation<?, PointF> circleSize) {
            if (this.circleSize != null) {
                this.removeAnimation(this.circleSize);
                this.circleSize.removeUpdateListener(this.circleSizeChangedListener);
            }
            if (this.circlePosition != null) {
                this.removeAnimation(this.circlePosition);
                this.circlePosition.removeUpdateListener(this.circlePositionChangedListener);
            }
            this.circleSize = circleSize;
            this.circlePosition = circlePosition;
            this.addAnimation(circleSize);
            circleSize.addUpdateListener(this.circleSizeChangedListener);
            this.addAnimation(circlePosition);
            circlePosition.addUpdateListener(this.circlePositionChangedListener);
            this.onCircleSizeChanged();
        }

        private void onCircleSizeChanged() {
            float halfWidth = this.circleSize.getValue().x / 2.0f;
            float halfHeight = this.circleSize.getValue().y / 2.0f;
            this.setBounds(0, 0, (int)halfWidth * 2, (int)halfHeight * 2);
            float cpW = halfWidth * 0.55228f;
            float cpH = halfHeight * 0.55228f;
            this.path.reset();
            this.path.moveTo(0.0f, -halfHeight);
            this.path.cubicTo(0.0f + cpW, -halfHeight, halfWidth, 0.0f - cpH, halfWidth, 0.0f);
            this.path.cubicTo(halfWidth, 0.0f + cpH, 0.0f + cpW, halfHeight, 0.0f, halfHeight);
            this.path.cubicTo(0.0f - cpW, halfHeight, -halfWidth, 0.0f + cpH, -halfWidth, 0.0f);
            this.path.cubicTo(-halfWidth, 0.0f - cpH, 0.0f - cpW, -halfHeight, 0.0f, -halfHeight);
            this.path.offset(this.circlePosition.getValue().x, this.circlePosition.getValue().y);
            this.path.close();
            this.onPathChanged();
        }
    }
}

