/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.graphics.Path;
import com.airbnb.lottie.AnimatableValueParser;
import com.airbnb.lottie.BaseAnimatableValue;
import com.airbnb.lottie.BaseKeyframeAnimation;
import com.airbnb.lottie.Keyframe;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.MiscUtils;
import com.airbnb.lottie.ShapeData;
import com.airbnb.lottie.ShapeKeyframeAnimation;
import com.airbnb.lottie.StaticKeyframeAnimation;
import java.util.List;
import org.json.JSONObject;

class AnimatableShapeValue
extends BaseAnimatableValue<ShapeData, Path> {
    private final Path convertTypePath = new Path();

    private AnimatableShapeValue(List<Keyframe<ShapeData>> keyframes, LottieComposition composition, ShapeData initialValue) {
        super(keyframes, composition, initialValue);
    }

    @Override
    public BaseKeyframeAnimation<?, Path> createAnimation() {
        if (!this.hasAnimation()) {
            return new StaticKeyframeAnimation<Path>(this.convertType((ShapeData)this.initialValue));
        }
        return new ShapeKeyframeAnimation(this.keyframes);
    }

    @Override
    Path convertType(ShapeData shapeData) {
        this.convertTypePath.reset();
        MiscUtils.getPathFromData(shapeData, this.convertTypePath);
        return this.convertTypePath;
    }

    static final class Factory {
        private Factory() {
        }

        static AnimatableShapeValue newInstance(JSONObject json, LottieComposition composition) {
            AnimatableValueParser.Result<ShapeData> result = AnimatableValueParser.newInstance(json, composition.getDpScale(), composition, ShapeData.Factory.INSTANCE).parseJson();
            return new AnimatableShapeValue(result.keyframes, composition, (ShapeData)result.initialValue);
        }
    }
}

