/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import com.airbnb.lottie.AnimatableValueParser;
import com.airbnb.lottie.BaseAnimatableValue;
import com.airbnb.lottie.Keyframe;
import com.airbnb.lottie.KeyframeAnimation;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.ScaleKeyframeAnimation;
import com.airbnb.lottie.ScaleXY;
import com.airbnb.lottie.StaticKeyframeAnimation;
import java.util.List;
import org.json.JSONObject;

class AnimatableScaleValue
extends BaseAnimatableValue<ScaleXY, ScaleXY> {
    private AnimatableScaleValue(LottieComposition composition) {
        super(composition, new ScaleXY());
    }

    private AnimatableScaleValue(List<Keyframe<ScaleXY>> keyframes, LottieComposition composition, ScaleXY initialValue) {
        super(keyframes, composition, initialValue);
    }

    public KeyframeAnimation<ScaleXY> createAnimation() {
        if (!this.hasAnimation()) {
            return new StaticKeyframeAnimation<Object>(this.initialValue);
        }
        return new ScaleKeyframeAnimation(this.keyframes);
    }

    static final class Factory {
        private Factory() {
        }

        static AnimatableScaleValue newInstance(JSONObject json, LottieComposition composition, boolean isDp) {
            float scale = isDp ? composition.getDpScale() : 1.0f;
            AnimatableValueParser.Result<ScaleXY> result = AnimatableValueParser.newInstance(json, scale, composition, ScaleXY.Factory.INSTANCE).parseJson();
            return new AnimatableScaleValue(result.keyframes, composition, (ScaleXY)result.initialValue);
        }

        static AnimatableScaleValue newInstance(LottieComposition composition) {
            return new AnimatableScaleValue(composition);
        }
    }
}

