/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.FloatRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.airbnb.lottie.BaseKeyframeAnimation;
import com.airbnb.lottie.LottieDrawable;
import com.airbnb.lottie.ScaleXY;
import com.airbnb.lottie.TransformKeyframeAnimation;
import java.util.ArrayList;
import java.util.List;

class AnimatableLayer
extends Drawable {
    private final BaseKeyframeAnimation.AnimationListener<Integer> integerChangedListener = new BaseKeyframeAnimation.AnimationListener<Integer>(){

        @Override
        public void onValueChanged(Integer value) {
            AnimatableLayer.this.invalidateSelf();
        }
    };
    private final BaseKeyframeAnimation.AnimationListener<Float> floatChangedListener = new BaseKeyframeAnimation.AnimationListener<Float>(){

        @Override
        public void onValueChanged(Float value) {
            AnimatableLayer.this.invalidateSelf();
        }
    };
    private final BaseKeyframeAnimation.AnimationListener<ScaleXY> scaleChangedListener = new BaseKeyframeAnimation.AnimationListener<ScaleXY>(){

        @Override
        public void onValueChanged(ScaleXY value) {
            AnimatableLayer.this.invalidateSelf();
        }
    };
    private final BaseKeyframeAnimation.AnimationListener<PointF> pointChangedListener = new BaseKeyframeAnimation.AnimationListener<PointF>(){

        @Override
        public void onValueChanged(PointF value) {
            AnimatableLayer.this.invalidateSelf();
        }
    };
    final BaseKeyframeAnimation.AnimationListener<Path> pathChangedListener = new BaseKeyframeAnimation.AnimationListener<Path>(){

        @Override
        public void onValueChanged(Path value) {
            AnimatableLayer.this.invalidateSelf();
        }
    };
    final List<AnimatableLayer> layers = new ArrayList<AnimatableLayer>();
    @Nullable
    private AnimatableLayer parentLayer;
    private final Paint solidBackgroundPaint = new Paint();
    @ColorInt
    private int backgroundColor;
    private final List<BaseKeyframeAnimation<?, ?>> animations = new ArrayList();
    @FloatRange(from=0.0, to=1.0)
    private float progress = 0.0f;
    private TransformKeyframeAnimation transform;

    AnimatableLayer(Drawable.Callback callback) {
        this.setCallback(callback);
        this.solidBackgroundPaint.setAlpha(0);
        this.solidBackgroundPaint.setStyle(Paint.Style.FILL);
    }

    void setBackgroundColor(@ColorInt int color) {
        this.backgroundColor = color;
        this.solidBackgroundPaint.setColor(color);
        this.invalidateSelf();
    }

    void addAnimation(BaseKeyframeAnimation<?, ?> newAnimation) {
        this.animations.add(newAnimation);
    }

    void removeAnimation(BaseKeyframeAnimation<?, ?> animation) {
        this.animations.remove(animation);
    }

    public void draw(@NonNull Canvas canvas) {
        int saveCount = canvas.save();
        this.applyTransformForLayer(canvas, this);
        int backgroundAlpha = Color.alpha((int)this.backgroundColor);
        if (backgroundAlpha != 0) {
            int alpha = backgroundAlpha;
            if (this.transform != null) {
                alpha = alpha * this.transform.getOpacity().getValue() / 255;
            }
            this.solidBackgroundPaint.setAlpha(alpha);
            if (alpha > 0) {
                float scale = this.getLottieDrawable().getScale();
                canvas.drawRect(0.0f, 0.0f, (float)this.getBounds().width() * scale, (float)this.getBounds().height() * scale, this.solidBackgroundPaint);
            }
        }
        for (int i = 0; i < this.layers.size(); ++i) {
            this.layers.get(i).draw(canvas);
        }
        canvas.restoreToCount(saveCount);
    }

    int saveCanvas(@Nullable Canvas canvas) {
        if (canvas == null) {
            return 0;
        }
        return canvas.save();
    }

    void applyTransformForLayer(@Nullable Canvas canvas, AnimatableLayer layer) {
        ScaleXY scaleTransform;
        float rotation;
        if (canvas == null || this.transform == null) {
            return;
        }
        float scale = this.getLottieDrawable().getScale();
        PointF position = layer.transform.getPosition().getValue();
        if (position.x != 0.0f || position.y != 0.0f) {
            canvas.translate(position.x * scale, position.y * scale);
        }
        if ((rotation = layer.transform.getRotation().getValue().floatValue()) != 0.0f) {
            canvas.rotate(rotation);
        }
        if ((scaleTransform = layer.transform.getScale().getValue()).getScaleX() != 1.0f || scaleTransform.getScaleY() != 1.0f) {
            canvas.scale(scaleTransform.getScaleX(), scaleTransform.getScaleY());
        }
        PointF anchorPoint = layer.transform.getAnchorPoint().getValue();
        if (anchorPoint.x != 0.0f || anchorPoint.y != 0.0f) {
            canvas.translate(-anchorPoint.x * scale, -anchorPoint.y * scale);
        }
    }

    public void setAlpha(int alpha) {
        throw new IllegalArgumentException("This shouldn't be used.");
    }

    public int getAlpha() {
        return this.getAlphaInternal();
    }

    int getAlphaInternal() {
        float alpha = this.transform == null ? 1.0f : (float)this.transform.getOpacity().getValue().intValue() / 255.0f;
        float parentAlpha = this.parentLayer == null ? 1.0f : (float)this.parentLayer.getAlpha() / 255.0f;
        return (int)(alpha * parentAlpha * 255.0f);
    }

    public void setColorFilter(ColorFilter colorFilter) {
    }

    void setTransform(TransformKeyframeAnimation transform) {
        this.transform = transform;
        BaseKeyframeAnimation<?, PointF> anchorPoint = transform.getAnchorPoint();
        BaseKeyframeAnimation<?, PointF> position = transform.getPosition();
        BaseKeyframeAnimation<?, ScaleXY> scale = transform.getScale();
        BaseKeyframeAnimation<?, Float> rotation = transform.getRotation();
        BaseKeyframeAnimation<?, Integer> opacity = transform.getOpacity();
        anchorPoint.addUpdateListener(this.pointChangedListener);
        position.addUpdateListener(this.pointChangedListener);
        scale.addUpdateListener(this.scaleChangedListener);
        rotation.addUpdateListener(this.floatChangedListener);
        opacity.addUpdateListener(this.integerChangedListener);
        this.addAnimation(anchorPoint);
        this.addAnimation(position);
        this.addAnimation(scale);
        this.addAnimation(rotation);
        this.addAnimation(opacity);
        this.invalidateSelf();
    }

    public int getOpacity() {
        return -3;
    }

    void addLayer(AnimatableLayer layer) {
        layer.parentLayer = this;
        this.layers.add(layer);
        layer.setProgress(this.progress);
        this.invalidateSelf();
    }

    void clearLayers() {
        this.layers.clear();
        this.invalidateSelf();
    }

    public void setProgress(@FloatRange(from=0.0, to=1.0) float progress) {
        int i;
        this.progress = progress;
        for (i = 0; i < this.animations.size(); ++i) {
            this.animations.get(i).setProgress(progress);
        }
        for (i = 0; i < this.layers.size(); ++i) {
            this.layers.get(i).setProgress(progress);
        }
    }

    float getProgress() {
        return this.progress;
    }

    LottieDrawable getLottieDrawable() {
        if (!(this.getCallback() instanceof LottieDrawable)) {
            return null;
        }
        return (LottieDrawable)this.getCallback();
    }
}

