/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import com.airbnb.lottie.AnimatableValue;
import com.airbnb.lottie.AnimatableValueParser;
import com.airbnb.lottie.BaseAnimatableValue;
import com.airbnb.lottie.IntegerKeyframeAnimation;
import com.airbnb.lottie.JsonUtils;
import com.airbnb.lottie.Keyframe;
import com.airbnb.lottie.KeyframeAnimation;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.StaticKeyframeAnimation;
import java.util.List;
import org.json.JSONObject;

class AnimatableIntegerValue
extends BaseAnimatableValue<Integer, Integer> {
    private AnimatableIntegerValue(LottieComposition composition, Integer initialValue) {
        super(composition, initialValue);
    }

    private AnimatableIntegerValue(List<Keyframe<Integer>> keyframes, LottieComposition composition, Integer initialValue) {
        super(keyframes, composition, initialValue);
    }

    public KeyframeAnimation<Integer> createAnimation() {
        if (!this.hasAnimation()) {
            return new StaticKeyframeAnimation<Object>(this.initialValue);
        }
        return new IntegerKeyframeAnimation(this.keyframes);
    }

    @Override
    public Integer getInitialValue() {
        return (Integer)this.initialValue;
    }

    private static class ValueFactory
    implements AnimatableValue.Factory<Integer> {
        private static final ValueFactory INSTANCE = new ValueFactory();

        private ValueFactory() {
        }

        @Override
        public Integer valueFromObject(Object object, float scale) {
            return Math.round(JsonUtils.valueFromObject(object) * scale);
        }
    }

    static final class Factory {
        private Factory() {
        }

        static AnimatableIntegerValue newInstance(LottieComposition composition, Integer initialValue) {
            return new AnimatableIntegerValue(composition, initialValue);
        }

        static AnimatableIntegerValue newInstance(JSONObject json, LottieComposition composition, boolean isDp, boolean remap100To255) {
            float scale = isDp ? composition.getDpScale() : 1.0f;
            AnimatableValueParser.Result<Integer> result = AnimatableValueParser.newInstance(json, scale, composition, ValueFactory.INSTANCE).parseJson();
            Integer initialValue = (Integer)result.initialValue;
            if (remap100To255 && result.initialValue != null) {
                initialValue = (Integer)result.initialValue * 255 / 100;
                int size = result.keyframes.size();
                for (int i = 0; i < size; ++i) {
                    Keyframe keyframe = result.keyframes.get(i);
                    keyframe.startValue = (Integer)keyframe.startValue * 255 / 100;
                    keyframe.endValue = (Integer)keyframe.endValue * 255 / 100;
                }
            }
            return new AnimatableIntegerValue(result.keyframes, composition, initialValue);
        }
    }
}

