/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import com.airbnb.lottie.AnimatableValue;
import com.airbnb.lottie.AnimatableValueParser;
import com.airbnb.lottie.BaseAnimatableValue;
import com.airbnb.lottie.FloatKeyframeAnimation;
import com.airbnb.lottie.JsonUtils;
import com.airbnb.lottie.Keyframe;
import com.airbnb.lottie.KeyframeAnimation;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.StaticKeyframeAnimation;
import java.util.List;
import org.json.JSONObject;

class AnimatableFloatValue
extends BaseAnimatableValue<Float, Float> {
    private AnimatableFloatValue(LottieComposition composition, Float initialValue) {
        super(composition, initialValue);
    }

    private AnimatableFloatValue(List<Keyframe<Float>> keyframes, LottieComposition composition, Float initialValue) {
        super(keyframes, composition, initialValue);
    }

    public KeyframeAnimation<Float> createAnimation() {
        if (!this.hasAnimation()) {
            return new StaticKeyframeAnimation<Object>(this.initialValue);
        }
        return new FloatKeyframeAnimation(this.keyframes);
    }

    @Override
    public Float getInitialValue() {
        return (Float)this.initialValue;
    }

    static final class Factory {
        private Factory() {
        }

        static AnimatableFloatValue newInstance(LottieComposition composition, Float initialValue) {
            return new AnimatableFloatValue(composition, initialValue);
        }

        static AnimatableFloatValue newInstance(JSONObject json, LottieComposition composition) {
            return Factory.newInstance(json, composition, true);
        }

        static AnimatableFloatValue newInstance(JSONObject json, LottieComposition composition, boolean isDp) {
            float scale = isDp ? composition.getDpScale() : 1.0f;
            AnimatableValueParser.Result<Float> result = AnimatableValueParser.newInstance(json, scale, composition, ValueFactory.INSTANCE).parseJson();
            return new AnimatableFloatValue(result.keyframes, composition, (Float)result.initialValue);
        }
    }

    private static class ValueFactory
    implements AnimatableValue.Factory<Float> {
        static final ValueFactory INSTANCE = new ValueFactory();

        private ValueFactory() {
        }

        @Override
        public Float valueFromObject(Object object, float scale) {
            return Float.valueOf(JsonUtils.valueFromObject(object) * scale);
        }
    }
}

