/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.support.annotation.Nullable;
import com.airbnb.lottie.AnimatableColorValue;
import com.airbnb.lottie.AnimatableIntegerValue;
import com.airbnb.lottie.LottieComposition;
import org.json.JSONObject;

class ShapeFill {
    private final boolean fillEnabled;
    @Nullable
    private final AnimatableColorValue color;
    @Nullable
    private final AnimatableIntegerValue opacity;

    private ShapeFill(boolean fillEnabled, @Nullable AnimatableColorValue color, @Nullable AnimatableIntegerValue opacity) {
        this.fillEnabled = fillEnabled;
        this.color = color;
        this.opacity = opacity;
    }

    @Nullable
    public AnimatableColorValue getColor() {
        return this.color;
    }

    @Nullable
    public AnimatableIntegerValue getOpacity() {
        return this.opacity;
    }

    public String toString() {
        return "ShapeFill{color=" + Integer.toHexString((Integer)this.color.getInitialValue()) + ", fillEnabled=" + this.fillEnabled + ", opacity=" + this.opacity.getInitialValue() + '}';
    }

    static class Factory {
        private Factory() {
        }

        static ShapeFill newInstance(JSONObject json, LottieComposition composition) {
            JSONObject jsonOpacity;
            AnimatableColorValue color = null;
            AnimatableIntegerValue opacity = null;
            JSONObject jsonColor = json.optJSONObject("c");
            if (jsonColor != null) {
                color = AnimatableColorValue.Factory.newInstance(jsonColor, composition);
            }
            if ((jsonOpacity = json.optJSONObject("o")) != null) {
                opacity = AnimatableIntegerValue.Factory.newInstance(jsonOpacity, composition, false, true);
            }
            boolean fillEnabled = json.optBoolean("fillEnabled");
            return new ShapeFill(fillEnabled, color, opacity);
        }
    }
}

