/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import com.airbnb.lottie.Keyframe;
import com.airbnb.lottie.KeyframeAnimation;
import com.airbnb.lottie.MiscUtils;
import java.util.List;

class NumberKeyframeAnimation<T extends Number>
extends KeyframeAnimation<T> {
    private final Class<T> klass;

    NumberKeyframeAnimation(List<Keyframe<T>> keyframes, Class<T> klass) {
        super(keyframes);
        this.klass = klass;
    }

    @Override
    T getValue(Keyframe<T> keyframe, float keyframeProgress) {
        Number startValue = (Number)keyframe.startValue;
        Number endValue = (Number)keyframe.endValue;
        if (this.klass.isAssignableFrom(Integer.class)) {
            return (T)((Number)this.klass.cast(MiscUtils.lerp(startValue.intValue(), endValue.intValue(), keyframeProgress)));
        }
        return (T)((Number)this.klass.cast(Float.valueOf(MiscUtils.lerp(startValue.floatValue(), endValue.floatValue(), keyframeProgress))));
    }
}

