/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import com.airbnb.lottie.AnimatableValue;
import com.airbnb.lottie.Keyframe;
import com.airbnb.lottie.LottieComposition;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

abstract class BaseAnimatableValue<V, O>
implements AnimatableValue<V, O> {
    final List<Keyframe<V>> keyframes;
    final LottieComposition composition;
    final V initialValue;

    BaseAnimatableValue(LottieComposition composition, V initialValue) {
        this(Collections.emptyList(), composition, initialValue);
    }

    BaseAnimatableValue(List<Keyframe<V>> keyframes, LottieComposition composition, V initialValue) {
        this.keyframes = keyframes;
        this.composition = composition;
        this.initialValue = initialValue;
    }

    O convertType(V value) {
        return (O)value;
    }

    @Override
    public boolean hasAnimation() {
        return !this.keyframes.isEmpty();
    }

    public O getInitialValue() {
        return this.convertType(this.initialValue);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("parseInitialValue=").append(this.initialValue);
        if (!this.keyframes.isEmpty()) {
            sb.append(", values=").append(Arrays.toString(this.keyframes.toArray()));
        }
        return sb.toString();
    }
}

