/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.graphics.Rect;
import com.airbnb.lottie.AnimatableFloatValue;
import com.airbnb.lottie.AnimatableIntegerValue;
import com.airbnb.lottie.AnimatablePathValue;
import com.airbnb.lottie.AnimatableScaleValue;
import com.airbnb.lottie.IAnimatablePathValue;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.Transform;
import org.json.JSONException;
import org.json.JSONObject;

class ShapeTransform
implements Transform {
    private static final String TAG = ShapeTransform.class.getSimpleName();
    private Rect compBounds;
    private IAnimatablePathValue position;
    private AnimatablePathValue anchor;
    private AnimatableScaleValue scale;
    private AnimatableFloatValue rotation;
    private AnimatableIntegerValue opacity;

    ShapeTransform(LottieComposition composition) {
        this.compBounds = composition.getBounds();
        this.position = new AnimatablePathValue(composition);
        this.anchor = new AnimatablePathValue(composition);
        this.scale = new AnimatableScaleValue(composition);
        this.rotation = new AnimatableFloatValue(composition, Float.valueOf(0.0f));
        this.opacity = new AnimatableIntegerValue(composition, 255);
    }

    ShapeTransform(JSONObject json, int frameRate, LottieComposition composition) {
        JSONObject jsonOpacity;
        JSONObject jsonRotation;
        JSONObject jsonScale;
        JSONObject jsonAnchor;
        JSONObject jsonPosition;
        this.compBounds = composition.getBounds();
        try {
            jsonPosition = json.getJSONObject("p");
        }
        catch (JSONException e) {
            throw new IllegalStateException("Transform has no position.");
        }
        this.position = AnimatablePathValue.createAnimatablePathOrSplitDimensionPath(jsonPosition, composition);
        try {
            jsonAnchor = json.getJSONObject("a");
        }
        catch (JSONException e) {
            throw new IllegalStateException("Transform has no anchor.");
        }
        this.anchor = new AnimatablePathValue(jsonAnchor, composition);
        try {
            jsonScale = json.getJSONObject("s");
        }
        catch (JSONException e) {
            throw new IllegalStateException("Transform has no scale.");
        }
        this.scale = new AnimatableScaleValue(jsonScale, frameRate, composition, false);
        try {
            jsonRotation = json.getJSONObject("r");
        }
        catch (JSONException e) {
            throw new IllegalStateException("Transform has no rotation.");
        }
        this.rotation = new AnimatableFloatValue(jsonRotation, frameRate, composition, false);
        try {
            jsonOpacity = json.getJSONObject("o");
        }
        catch (JSONException e) {
            throw new IllegalStateException("Transform has no opacity.");
        }
        this.opacity = new AnimatableIntegerValue(jsonOpacity, frameRate, composition, false, true);
    }

    @Override
    public Rect getBounds() {
        return this.compBounds;
    }

    @Override
    public IAnimatablePathValue getPosition() {
        return this.position;
    }

    @Override
    public AnimatablePathValue getAnchor() {
        return this.anchor;
    }

    @Override
    public AnimatableScaleValue getScale() {
        return this.scale;
    }

    @Override
    public AnimatableFloatValue getRotation() {
        return this.rotation;
    }

    @Override
    public AnimatableIntegerValue getOpacity() {
        return this.opacity;
    }

    public String toString() {
        return "ShapeTransform{anchor=" + this.anchor.toString() + ", compBounds=" + this.compBounds + ", position=" + this.position.toString() + ", scale=" + this.scale.toString() + ", rotation=" + this.rotation.getInitialValue() + ", opacity=" + this.opacity.getInitialValue() + '}';
    }
}

