/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import com.airbnb.lottie.AnimatableShapeValue;
import com.airbnb.lottie.LottieComposition;
import org.json.JSONException;
import org.json.JSONObject;

class ShapePath {
    private static final String TAG = ShapePath.class.getSimpleName();
    private final String name;
    private final int index;
    private AnimatableShapeValue shapePath;

    ShapePath(JSONObject json, int frameRate, LottieComposition composition) {
        try {
            this.index = json.getInt("ind");
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("ShapePath has no index.", e);
        }
        try {
            this.name = json.getString("nm");
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Layer has no name.", e);
        }
        boolean closed = false;
        try {
            closed = json.getBoolean("closed");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            JSONObject shape = json.getJSONObject("ks");
            this.shapePath = new AnimatableShapeValue(shape, frameRate, composition, closed);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    AnimatableShapeValue getShapePath() {
        return this.shapePath;
    }

    public String toString() {
        return "ShapePath{name=" + this.name + ", index=" + this.index + ", hasAnimation=" + this.shapePath.hasAnimation() + '}';
    }
}

