/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.annotation.SuppressLint;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.DashPathEffect;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.PathMeasure;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.airbnb.lottie.AnimatableLayer;
import com.airbnb.lottie.KeyframeAnimation;
import com.airbnb.lottie.ScaleXY;
import com.airbnb.lottie.ShapeStroke;
import java.util.List;

class ShapeLayer
extends AnimatableLayer {
    private final KeyframeAnimation.AnimationListener<Path> pathChangedListener = new KeyframeAnimation.AnimationListener<Path>(){

        @Override
        public void onValueChanged(Path value) {
            ShapeLayer.this.onPathChanged();
        }
    };
    private final KeyframeAnimation.AnimationListener<Integer> alphaChangedListener = new KeyframeAnimation.AnimationListener<Integer>(){

        @Override
        public void onValueChanged(Integer value) {
            ShapeLayer.this.invalidateSelf();
        }
    };
    private final KeyframeAnimation.AnimationListener<Integer> colorChangedListener = new KeyframeAnimation.AnimationListener<Integer>(){

        @Override
        public void onValueChanged(Integer value) {
            ShapeLayer.this.onColorChanged();
        }
    };
    private final KeyframeAnimation.AnimationListener<Float> lineWidthChangedListener = new KeyframeAnimation.AnimationListener<Float>(){

        @Override
        public void onValueChanged(Float value) {
            ShapeLayer.this.onLineWidthChanged();
        }
    };
    private final KeyframeAnimation.AnimationListener<Float> dashPatternChangedListener = new KeyframeAnimation.AnimationListener<Float>(){

        @Override
        public void onValueChanged(Float value) {
            ShapeLayer.this.onDashPatternChanged();
        }
    };
    private final KeyframeAnimation.AnimationListener<Float> strokeChangedListener = new KeyframeAnimation.AnimationListener<Float>(){

        @Override
        public void onValueChanged(Float value) {
            ShapeLayer.this.onPathPropertiesChanged();
        }
    };
    private final KeyframeAnimation.AnimationListener<ScaleXY> scaleChangedListener = new KeyframeAnimation.AnimationListener<ScaleXY>(){

        @Override
        public void onValueChanged(ScaleXY value) {
            ShapeLayer.this.onPathPropertiesChanged();
        }
    };
    private final Paint paint = new Paint();
    private final Path tempPath = new Path();
    private final Path currentPath = new Path();
    private final Path extraTrimPath = new Path();
    private final PathMeasure pathMeasure = new PathMeasure();
    private float currentPathScaleX;
    private float currentPathScaleY;
    private float currentPathStrokeStart;
    private float currentPathStrokeEnd = 100.0f;
    private float currentPathStrokeOffset = 0.0f;
    @Nullable
    private KeyframeAnimation<ScaleXY> scale;
    private final RectF tempRect = new RectF();
    private final Matrix scaleMatrix = new Matrix();
    private KeyframeAnimation<Path> path;
    private KeyframeAnimation<Integer> color;
    private KeyframeAnimation<Float> lineWidth;
    @Nullable
    private KeyframeAnimation<Float> strokeStart;
    @Nullable
    private KeyframeAnimation<Float> strokeEnd;
    @Nullable
    private KeyframeAnimation<Float> strokeOffset;
    private KeyframeAnimation<Integer> shapeAlpha;
    private KeyframeAnimation<Integer> transformAlpha;
    private List<KeyframeAnimation<Float>> lineDashPattern;
    private KeyframeAnimation<Float> lineDashPatternOffset;

    ShapeLayer(Drawable.Callback callback) {
        super(callback);
        this.paint.setStyle(Paint.Style.FILL);
        this.paint.setAntiAlias(true);
    }

    void setIsStroke() {
        this.paint.setStyle(Paint.Style.STROKE);
        this.invalidateSelf();
    }

    public void setColor(KeyframeAnimation<Integer> color) {
        if (this.color != null) {
            this.removeAnimation(this.color);
            this.color.removeUpdateListener(this.colorChangedListener);
        }
        this.color = color;
        this.addAnimation(color);
        color.addUpdateListener(this.colorChangedListener);
        this.onColorChanged();
    }

    private void onColorChanged() {
        this.paint.setColor(this.color.getValue().intValue());
        this.invalidateSelf();
    }

    public void setPath(KeyframeAnimation<Path> path) {
        if (this.path != null) {
            this.removeAnimation(this.path);
            this.path.removeUpdateListener(this.pathChangedListener);
        }
        this.path = path;
        this.addAnimation(path);
        path.addUpdateListener(this.pathChangedListener);
        this.onPathChanged();
    }

    void onPathChanged() {
        this.currentPath.reset();
        this.currentPath.set(this.path.getValue());
        this.currentPathStrokeStart = Float.NaN;
        this.currentPathStrokeEnd = Float.NaN;
        this.currentPathScaleX = Float.NaN;
        this.currentPathScaleY = Float.NaN;
        this.onPathPropertiesChanged();
        this.invalidateSelf();
    }

    private void onPathPropertiesChanged() {
        boolean needsScaleY;
        boolean needsStrokeStart = this.strokeStart != null && this.strokeStart.getValue().floatValue() != this.currentPathStrokeStart;
        boolean needsStrokeEnd = this.strokeEnd != null && this.strokeEnd.getValue().floatValue() != this.currentPathStrokeEnd;
        boolean needsStrokeOffset = this.strokeOffset != null && this.strokeOffset.getValue().floatValue() != this.currentPathStrokeOffset;
        boolean needsScaleX = this.scale != null && this.scale.getValue().getScaleX() != this.currentPathScaleX;
        boolean bl = needsScaleY = this.scale != null && this.scale.getValue().getScaleY() != this.currentPathScaleY;
        if (!(needsStrokeStart || needsStrokeEnd || needsScaleX || needsScaleY || needsStrokeOffset)) {
            return;
        }
        this.currentPath.set(this.path.getValue());
        if (needsScaleX || needsScaleY) {
            this.currentPath.computeBounds(this.tempRect, false);
            this.currentPathScaleX = this.scale.getValue().getScaleX();
            this.currentPathScaleY = this.scale.getValue().getScaleY();
            this.scaleMatrix.setScale(this.currentPathScaleX, this.currentPathScaleY, this.tempRect.centerX(), this.tempRect.centerY());
            this.currentPath.transform(this.scaleMatrix, this.currentPath);
        }
        if (needsStrokeStart || needsStrokeEnd || needsStrokeOffset) {
            this.tempPath.set(this.currentPath);
            this.pathMeasure.setPath(this.tempPath, false);
            this.currentPathStrokeStart = this.strokeStart.getValue().floatValue();
            this.currentPathStrokeEnd = this.strokeEnd.getValue().floatValue();
            float length = this.pathMeasure.getLength();
            float start = length * this.currentPathStrokeStart / 100.0f;
            float end = length * this.currentPathStrokeEnd / 100.0f;
            float newStart = Math.min(start, end);
            float newEnd = Math.max(start, end);
            this.currentPath.reset();
            this.currentPathStrokeOffset = this.strokeOffset.getValue().floatValue() / 360.0f * length;
            newStart += this.currentPathStrokeOffset;
            newEnd += this.currentPathStrokeOffset;
            if (newStart > length && newEnd > length) {
                newStart %= length;
                newEnd %= length;
            }
            if (newStart > newEnd) {
                newStart -= length;
            }
            this.pathMeasure.getSegment(newStart, newEnd, this.currentPath, true);
            this.extraTrimPath.reset();
            if (newEnd > length) {
                this.pathMeasure.getSegment(0.0f, newEnd % length, this.extraTrimPath, true);
            } else if (newStart < 0.0f) {
                this.pathMeasure.getSegment(length + newStart, length, this.extraTrimPath, true);
            }
        }
        this.currentPath.computeBounds(this.tempRect, false);
        this.setBounds((int)this.tempRect.left, (int)this.tempRect.top, (int)this.tempRect.right, (int)this.tempRect.bottom);
        this.invalidateSelf();
    }

    @Override
    @SuppressLint(value={"NewApi"})
    public void draw(@NonNull Canvas canvas) {
        if (this.paint.getStyle() == Paint.Style.STROKE && this.paint.getStrokeWidth() == 0.0f) {
            return;
        }
        this.paint.setAlpha(this.getAlpha());
        canvas.drawPath(this.currentPath, this.paint);
        if (!this.extraTrimPath.isEmpty()) {
            canvas.drawPath(this.extraTrimPath, this.paint);
        }
    }

    @Override
    public int getAlpha() {
        Integer shapeAlpha = this.shapeAlpha == null ? 255 : this.shapeAlpha.getValue();
        Integer transformAlpha = this.transformAlpha == null ? 255 : this.transformAlpha.getValue();
        int layerAlpha = super.getAlpha();
        return (int)((float)shapeAlpha.intValue() / 255.0f * (float)transformAlpha.intValue() / 255.0f * (float)layerAlpha / 255.0f * 255.0f);
    }

    void setShapeAlpha(KeyframeAnimation<Integer> shapeAlpha) {
        if (this.shapeAlpha != null) {
            this.removeAnimation(this.shapeAlpha);
            this.shapeAlpha.removeUpdateListener(this.alphaChangedListener);
        }
        this.shapeAlpha = shapeAlpha;
        this.addAnimation(shapeAlpha);
        shapeAlpha.addUpdateListener(this.alphaChangedListener);
        this.invalidateSelf();
    }

    void setTransformAlpha(KeyframeAnimation<Integer> transformAlpha) {
        if (this.transformAlpha != null) {
            this.removeAnimation(this.transformAlpha);
            this.transformAlpha.removeUpdateListener(this.alphaChangedListener);
        }
        this.transformAlpha = transformAlpha;
        this.addAnimation(transformAlpha);
        transformAlpha.addUpdateListener(this.alphaChangedListener);
        this.invalidateSelf();
    }

    @Override
    public void setAlpha(@IntRange(from=0L, to=255L) int alpha) {
        this.paint.setAlpha(alpha);
        this.invalidateSelf();
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
    }

    @Override
    public int getOpacity() {
        return -3;
    }

    void setLineWidth(KeyframeAnimation<Float> lineWidth) {
        if (this.lineWidth != null) {
            this.removeAnimation(this.lineWidth);
            this.lineWidth.removeUpdateListener(this.lineWidthChangedListener);
        }
        this.lineWidth = lineWidth;
        this.addAnimation(lineWidth);
        lineWidth.addUpdateListener(this.lineWidthChangedListener);
        this.onLineWidthChanged();
    }

    private void onLineWidthChanged() {
        this.paint.setStrokeWidth(this.lineWidth.getValue().floatValue());
        this.invalidateSelf();
    }

    void setDashPattern(List<KeyframeAnimation<Float>> lineDashPattern, KeyframeAnimation<Float> offset) {
        if (this.lineDashPattern != null) {
            this.removeAnimation(this.lineDashPattern.get(0));
            this.lineDashPattern.get(0).removeUpdateListener(this.dashPatternChangedListener);
            this.removeAnimation(this.lineDashPattern.get(1));
            this.lineDashPattern.get(1).removeUpdateListener(this.dashPatternChangedListener);
        }
        if (this.lineDashPatternOffset != null) {
            this.removeAnimation(this.lineDashPatternOffset);
            this.lineDashPatternOffset.removeUpdateListener(this.dashPatternChangedListener);
        }
        if (lineDashPattern.isEmpty()) {
            return;
        }
        this.lineDashPattern = lineDashPattern;
        this.lineDashPatternOffset = offset;
        this.addAnimation(lineDashPattern.get(0));
        lineDashPattern.get(0).addUpdateListener(this.dashPatternChangedListener);
        if (!lineDashPattern.get(1).equals(lineDashPattern.get(1))) {
            this.addAnimation(lineDashPattern.get(1));
            lineDashPattern.get(1).addUpdateListener(this.dashPatternChangedListener);
        }
        this.addAnimation(offset);
        offset.addUpdateListener(this.dashPatternChangedListener);
        this.onDashPatternChanged();
    }

    private void onDashPatternChanged() {
        float[] values = new float[this.lineDashPattern.size()];
        for (int i = 0; i < this.lineDashPattern.size(); ++i) {
            values[i] = this.lineDashPattern.get(i).getValue().floatValue();
            if (values[i] != 0.0f) continue;
            values[i] = 0.01f;
        }
        this.paint.setPathEffect((PathEffect)new DashPathEffect(values, this.lineDashPatternOffset.getValue().floatValue()));
        this.invalidateSelf();
    }

    void setLineCapType(ShapeStroke.LineCapType lineCapType) {
        switch (lineCapType) {
            case Round: {
                this.paint.setStrokeCap(Paint.Cap.ROUND);
                break;
            }
            default: {
                this.paint.setStrokeCap(Paint.Cap.BUTT);
            }
        }
        this.invalidateSelf();
    }

    void setLineJoinType(ShapeStroke.LineJoinType lineJoinType) {
        switch (lineJoinType) {
            case Bevel: {
                this.paint.setStrokeJoin(Paint.Join.BEVEL);
                break;
            }
            case Miter: {
                this.paint.setStrokeJoin(Paint.Join.MITER);
                break;
            }
            case Round: {
                this.paint.setStrokeJoin(Paint.Join.ROUND);
            }
        }
    }

    void setTrimPath(KeyframeAnimation<Float> strokeStart, KeyframeAnimation<Float> strokeEnd, KeyframeAnimation<Float> strokeOffset) {
        if (this.strokeStart != null) {
            this.removeAnimation(this.strokeStart);
            this.strokeStart.removeUpdateListener(this.strokeChangedListener);
        }
        if (this.strokeEnd != null) {
            this.removeAnimation(this.strokeEnd);
            this.strokeEnd.removeUpdateListener(this.strokeChangedListener);
        }
        if (this.strokeOffset != null) {
            this.removeAnimation(this.strokeOffset);
            this.strokeOffset.removeUpdateListener(this.strokeChangedListener);
        }
        this.strokeStart = strokeStart;
        this.strokeEnd = strokeEnd;
        this.strokeOffset = strokeOffset;
        this.addAnimation(strokeStart);
        strokeStart.addUpdateListener(this.strokeChangedListener);
        this.addAnimation(strokeEnd);
        strokeEnd.addUpdateListener(this.strokeChangedListener);
        this.addAnimation(strokeOffset);
        strokeOffset.addUpdateListener(this.strokeChangedListener);
        this.onPathPropertiesChanged();
    }

    void setScale(KeyframeAnimation<ScaleXY> scale) {
        if (this.scale != null) {
            this.removeAnimation(this.scale);
            this.scale.removeUpdateListener(this.scaleChangedListener);
        }
        this.scale = scale;
        this.addAnimation(scale);
        scale.addUpdateListener(this.scaleChangedListener);
        this.onPathPropertiesChanged();
    }
}

