/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.provider.Settings;
import android.support.annotation.FloatRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.support.v7.widget.AppCompatImageView;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.LottieDrawable;
import com.airbnb.lottie.R;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class LottieAnimationView
extends AppCompatImageView {
    private static final String TAG = LottieAnimationView.class.getSimpleName();
    private static final Map<String, LottieComposition> strongRefCache = new HashMap<String, LottieComposition>();
    private static final Map<String, WeakReference<LottieComposition>> weakRefCache = new HashMap<String, WeakReference<LottieComposition>>();
    private final LottieComposition.OnCompositionLoadedListener loadedListener = new LottieComposition.OnCompositionLoadedListener(){

        @Override
        public void onCompositionLoaded(LottieComposition composition) {
            LottieAnimationView.this.setComposition(composition);
            LottieAnimationView.this.compositionLoader = null;
        }
    };
    private final LottieDrawable lottieDrawable = new LottieDrawable();
    @FloatRange(from=0.0, to=1.0)
    private float progress;
    private String animationName;
    private boolean isAnimationLoading;
    private boolean setProgressWhenCompositionSet;
    private boolean playAnimationWhenCompositionSet;
    private boolean reverseAnimationWhenCompositionSet;
    @Nullable
    private LottieComposition.Cancellable compositionLoader;
    @Nullable
    private LottieComposition composition;

    public LottieAnimationView(Context context) {
        super(context);
        this.init(null);
    }

    public LottieAnimationView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public LottieAnimationView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    private void init(@Nullable AttributeSet attrs) {
        float systemAnimationScale;
        TypedArray ta = this.getContext().obtainStyledAttributes(attrs, R.styleable.LottieAnimationView);
        String fileName = ta.getString(R.styleable.LottieAnimationView_lottie_fileName);
        if (!this.isInEditMode() && fileName != null) {
            this.setAnimation(fileName);
        }
        if (ta.getBoolean(R.styleable.LottieAnimationView_lottie_autoPlay, false)) {
            this.lottieDrawable.playAnimation();
        }
        this.lottieDrawable.loop(ta.getBoolean(R.styleable.LottieAnimationView_lottie_loop, false));
        ta.recycle();
        this.setLayerType(1, null);
        if (Build.VERSION.SDK_INT >= 17 && (systemAnimationScale = Settings.Global.getFloat((ContentResolver)this.getContext().getContentResolver(), (String)"animator_duration_scale", (float)1.0f)) == 0.0f) {
            this.lottieDrawable.systemAnimationsAreDisabled();
        }
    }

    public void invalidateDrawable(Drawable dr) {
        super.invalidateDrawable((Drawable)this.lottieDrawable);
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.animationName = this.animationName;
        ss.progress = this.lottieDrawable.getProgress();
        ss.isAnimating = this.lottieDrawable.isAnimating();
        ss.isLooping = this.lottieDrawable.isLooping();
        return ss;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.animationName = ss.animationName;
        if (!TextUtils.isEmpty((CharSequence)this.animationName)) {
            this.setAnimation(this.animationName);
        }
        this.setProgress(ss.progress);
        this.loop(ss.isLooping);
        if (ss.isAnimating) {
            this.playAnimation();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    @SuppressLint(value={"MissingSuperCall"})
    protected boolean verifyDrawable(@NonNull Drawable drawable) {
        return true;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
    }

    protected void onDetachedFromWindow() {
        this.recycleBitmaps();
        super.onDetachedFromWindow();
    }

    @VisibleForTesting
    void recycleBitmaps() {
        this.lottieDrawable.recycleBitmaps();
    }

    public void setAnimation(String animationName) {
        this.setAnimation(animationName, CacheStrategy.None);
    }

    public void setAnimation(final String animationName, final CacheStrategy cacheStrategy) {
        this.animationName = animationName;
        if (weakRefCache != null && weakRefCache.containsKey(animationName)) {
            WeakReference<LottieComposition> compRef = weakRefCache.get(animationName);
            if (compRef.get() != null) {
                this.setComposition((LottieComposition)compRef.get());
                return;
            }
        } else if (strongRefCache != null && strongRefCache.containsKey(animationName)) {
            this.setComposition(strongRefCache.get(animationName));
            return;
        }
        this.isAnimationLoading = true;
        this.setProgressWhenCompositionSet = false;
        this.playAnimationWhenCompositionSet = false;
        this.reverseAnimationWhenCompositionSet = false;
        this.animationName = animationName;
        this.cancelLoaderTask();
        this.compositionLoader = LottieComposition.fromAssetFileName(this.getContext(), animationName, new LottieComposition.OnCompositionLoadedListener(){

            @Override
            public void onCompositionLoaded(LottieComposition composition) {
                if (cacheStrategy == CacheStrategy.Strong) {
                    strongRefCache.put(animationName, composition);
                } else if (cacheStrategy == CacheStrategy.Weak) {
                    weakRefCache.put(animationName, new WeakReference<LottieComposition>(composition));
                }
                LottieAnimationView.this.setComposition(composition);
            }
        });
    }

    public void setAnimation(JSONObject json) {
        this.isAnimationLoading = true;
        this.setProgressWhenCompositionSet = false;
        this.playAnimationWhenCompositionSet = false;
        this.reverseAnimationWhenCompositionSet = false;
        this.cancelLoaderTask();
        this.compositionLoader = LottieComposition.fromJson(this.getResources(), json, this.loadedListener);
    }

    private void cancelLoaderTask() {
        if (this.compositionLoader != null) {
            this.compositionLoader.cancel();
            this.compositionLoader = null;
        }
    }

    public void setComposition(@NonNull LottieComposition composition) {
        this.lottieDrawable.setCallback((Drawable.Callback)this);
        this.lottieDrawable.setComposition(composition);
        this.setImageDrawable(null);
        this.setImageDrawable(this.lottieDrawable);
        this.isAnimationLoading = false;
        if (this.setProgressWhenCompositionSet) {
            this.setProgressWhenCompositionSet = false;
            this.setProgress(this.progress);
        } else {
            this.setProgress(0.0f);
        }
        this.composition = composition;
        if (this.playAnimationWhenCompositionSet) {
            this.playAnimationWhenCompositionSet = false;
            this.playAnimation();
        }
        if (this.reverseAnimationWhenCompositionSet) {
            this.reverseAnimationWhenCompositionSet = false;
            this.reverseAnimation();
        }
        this.requestLayout();
    }

    public void addAnimatorUpdateListener(ValueAnimator.AnimatorUpdateListener updateListener) {
        this.lottieDrawable.addAnimatorUpdateListener(updateListener);
    }

    public void removeUpdateListener(ValueAnimator.AnimatorUpdateListener updateListener) {
        this.lottieDrawable.removeAnimatorUpdateListener(updateListener);
    }

    public void addAnimatorListener(Animator.AnimatorListener listener) {
        this.lottieDrawable.addAnimatorListener(listener);
    }

    public void removeAnimatorListener(Animator.AnimatorListener listener) {
        this.lottieDrawable.removeAnimatorListener(listener);
    }

    public void loop(boolean loop) {
        this.lottieDrawable.loop(loop);
    }

    public boolean isAnimating() {
        return this.lottieDrawable.isAnimating();
    }

    public void playAnimation() {
        if (this.isAnimationLoading) {
            this.playAnimationWhenCompositionSet = true;
            this.reverseAnimationWhenCompositionSet = false;
            return;
        }
        this.lottieDrawable.playAnimation();
    }

    public void reverseAnimation() {
        if (this.isAnimationLoading) {
            this.playAnimationWhenCompositionSet = false;
            this.reverseAnimationWhenCompositionSet = true;
            return;
        }
        this.lottieDrawable.reverseAnimation();
    }

    public void cancelAnimation() {
        this.setProgressWhenCompositionSet = false;
        this.playAnimationWhenCompositionSet = false;
        this.reverseAnimationWhenCompositionSet = false;
        this.lottieDrawable.cancelAnimation();
    }

    public void pauseAnimation() {
        this.setProgressWhenCompositionSet = false;
        this.playAnimationWhenCompositionSet = false;
        this.reverseAnimationWhenCompositionSet = false;
        float progress = this.getProgress();
        this.lottieDrawable.cancelAnimation();
        this.setProgress(progress);
    }

    public void setProgress(@FloatRange(from=0.0, to=1.0) float progress) {
        this.progress = progress;
        if (this.isAnimationLoading) {
            this.setProgressWhenCompositionSet = true;
            return;
        }
        this.lottieDrawable.setProgress(progress);
    }

    @FloatRange(from=0.0, to=1.0)
    public float getProgress() {
        return this.progress;
    }

    public long getDuration() {
        return this.composition != null ? this.composition.getDuration() : 0L;
    }

    private static class SavedState
    extends View.BaseSavedState {
        String animationName;
        float progress;
        boolean isAnimating;
        boolean isLooping;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.animationName = in.readString();
            this.progress = in.readFloat();
            this.isAnimating = in.readInt() == 1;
            this.isLooping = in.readInt() == 1;
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeString(this.animationName);
            out.writeFloat(this.progress);
            out.writeInt(this.isAnimating ? 1 : 0);
            out.writeInt(this.isLooping ? 1 : 0);
        }
    }

    public static enum CacheStrategy {
        None,
        Weak,
        Strong;

    }
}

