/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.graphics.Color;
import android.graphics.Rect;
import android.support.annotation.Nullable;
import com.airbnb.lottie.AnimatableFloatValue;
import com.airbnb.lottie.AnimatableIntegerValue;
import com.airbnb.lottie.AnimatablePathValue;
import com.airbnb.lottie.AnimatableScaleValue;
import com.airbnb.lottie.IAnimatablePathValue;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.Mask;
import com.airbnb.lottie.ScaleXY;
import com.airbnb.lottie.ShapeGroup;
import com.airbnb.lottie.Transform;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class Layer
implements Transform {
    private static final String TAG = Layer.class.getSimpleName();
    private final LottieComposition composition;
    private final List<Object> shapes = new ArrayList<Object>();
    private String layerName;
    private long layerId;
    private LottieLayerType layerType;
    private long parentId = -1L;
    private long inFrame;
    private long outFrame;
    private int frameRate;
    private final List<Mask> masks = new ArrayList<Mask>();
    private int solidWidth;
    private int solidHeight;
    private int solidColor;
    private AnimatableIntegerValue opacity;
    private AnimatableFloatValue rotation;
    private IAnimatablePathValue position;
    private AnimatablePathValue anchor;
    private AnimatableScaleValue scale;
    private boolean hasOutAnimation;
    private boolean hasInAnimation;
    private boolean hasInOutAnimation;
    @Nullable
    private List<Float> inOutKeyFrames;
    @Nullable
    private List<Float> inOutKeyTimes;
    private MatteType matteType;

    static Layer fromJson(JSONObject json, LottieComposition composition) {
        Layer layer = new Layer(composition);
        try {
            JSONObject rotation;
            layer.layerName = json.getString("nm");
            layer.layerId = json.getLong("ind");
            layer.frameRate = composition.getFrameRate();
            int layerType = json.getInt("ty");
            layer.layerType = layerType <= LottieLayerType.Shape.ordinal() ? LottieLayerType.values()[layerType] : LottieLayerType.Unknown;
            try {
                layer.parentId = json.getLong("parent");
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            layer.inFrame = json.getLong("ip");
            layer.outFrame = json.getLong("op");
            if (layer.layerType == LottieLayerType.Solid) {
                layer.solidWidth = (int)((float)json.getInt("sw") * composition.getScale());
                layer.solidHeight = (int)((float)json.getInt("sh") * composition.getScale());
                layer.solidColor = Color.parseColor((String)json.getString("sc"));
            }
            JSONObject ks = json.getJSONObject("ks");
            JSONObject opacity = null;
            try {
                opacity = ks.getJSONObject("o");
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            if (opacity != null) {
                layer.opacity = new AnimatableIntegerValue(opacity, layer.frameRate, composition, false, true);
            }
            try {
                rotation = ks.getJSONObject("r");
            }
            catch (JSONException e) {
                rotation = ks.getJSONObject("rz");
            }
            if (rotation != null) {
                layer.rotation = new AnimatableFloatValue(rotation, layer.frameRate, composition, false);
            }
            JSONObject position = null;
            try {
                position = ks.getJSONObject("p");
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            if (position != null) {
                layer.position = AnimatablePathValue.createAnimatablePathOrSplitDimensionPath(position, composition);
            }
            JSONObject anchor = null;
            try {
                anchor = ks.getJSONObject("a");
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            if (anchor != null) {
                layer.anchor = new AnimatablePathValue(anchor, composition);
            }
            JSONObject scale = null;
            try {
                scale = ks.getJSONObject("s");
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            if (scale != null) {
                layer.scale = new AnimatableScaleValue(scale, layer.frameRate, composition, false);
            }
            try {
                layer.matteType = MatteType.values()[json.getInt("tt")];
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            JSONArray jsonMasks = null;
            try {
                jsonMasks = json.getJSONArray("masksProperties");
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            if (jsonMasks != null) {
                for (int i = 0; i < jsonMasks.length(); ++i) {
                    Mask mask = new Mask(jsonMasks.getJSONObject(i), layer.frameRate, composition);
                    layer.masks.add(mask);
                }
            }
            JSONArray shapes = null;
            try {
                shapes = json.getJSONArray("shapes");
            }
            catch (JSONException mask) {
                // empty catch block
            }
            if (shapes != null) {
                for (int i = 0; i < shapes.length(); ++i) {
                    Object shape = ShapeGroup.shapeItemWithJson(shapes.getJSONObject(i), layer.frameRate, composition);
                    if (shape == null) continue;
                    layer.shapes.add(shape);
                }
            }
        }
        catch (JSONException e) {
            throw new IllegalStateException("Unable to parse layer json.", e);
        }
        layer.hasInAnimation = layer.inFrame > composition.getStartFrame();
        layer.hasOutAnimation = layer.outFrame < composition.getEndFrame();
        boolean bl = layer.hasInOutAnimation = layer.hasInAnimation || layer.hasOutAnimation;
        if (layer.hasInOutAnimation) {
            ArrayList<Float> keys = new ArrayList<Float>();
            ArrayList<Float> keyTimes = new ArrayList<Float>();
            long length = composition.getEndFrame() - composition.getStartFrame();
            if (layer.hasInAnimation) {
                keys.add(Float.valueOf(0.0f));
                keyTimes.add(Float.valueOf(0.0f));
                keys.add(Float.valueOf(1.0f));
                float inTime = (float)layer.inFrame / (float)length;
                keyTimes.add(Float.valueOf(inTime));
            } else {
                keys.add(Float.valueOf(1.0f));
                keyTimes.add(Float.valueOf(0.0f));
            }
            if (layer.hasOutAnimation) {
                keys.add(Float.valueOf(0.0f));
                keyTimes.add(Float.valueOf((float)layer.outFrame / (float)length));
                keys.add(Float.valueOf(0.0f));
                keyTimes.add(Float.valueOf(1.0f));
            } else {
                keys.add(Float.valueOf(1.0f));
                keyTimes.add(Float.valueOf(1.0f));
            }
            layer.inOutKeyTimes = keyTimes;
            layer.inOutKeyFrames = keys;
        }
        return layer;
    }

    private Layer(LottieComposition composition) {
        this.composition = composition;
    }

    @Override
    public Rect getBounds() {
        return this.composition.getBounds();
    }

    @Override
    public AnimatablePathValue getAnchor() {
        return this.anchor;
    }

    LottieComposition getComposition() {
        return this.composition;
    }

    boolean hasInAnimation() {
        return this.hasInAnimation;
    }

    boolean hasInOutAnimation() {
        return this.hasInOutAnimation;
    }

    @Nullable
    List<Float> getInOutKeyFrames() {
        return this.inOutKeyFrames;
    }

    @Nullable
    List<Float> getInOutKeyTimes() {
        return this.inOutKeyTimes;
    }

    long getId() {
        return this.layerId;
    }

    String getName() {
        return this.layerName;
    }

    List<Mask> getMasks() {
        return this.masks;
    }

    MatteType getMatteType() {
        return this.matteType;
    }

    @Override
    public AnimatableIntegerValue getOpacity() {
        return this.opacity;
    }

    long getParentId() {
        return this.parentId;
    }

    @Override
    public IAnimatablePathValue getPosition() {
        return this.position;
    }

    @Override
    public AnimatableFloatValue getRotation() {
        return this.rotation;
    }

    @Override
    public AnimatableScaleValue getScale() {
        return this.scale;
    }

    List<Object> getShapes() {
        return this.shapes;
    }

    int getSolidColor() {
        return this.solidColor;
    }

    int getSolidHeight() {
        return this.solidHeight;
    }

    int getSolidWidth() {
        return this.solidWidth;
    }

    public String toString() {
        return this.toString("");
    }

    String toString(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append(this.getName()).append("\n");
        Layer parent = this.composition.layerModelForId(this.getParentId());
        if (parent != null) {
            sb.append("\t\tParents: ").append(parent.getName());
            parent = this.composition.layerModelForId(parent.getParentId());
            while (parent != null) {
                sb.append("->").append(parent.getName());
                parent = this.composition.layerModelForId(parent.getParentId());
            }
            sb.append(prefix).append("\n");
        }
        if (this.getPosition().hasAnimation() || this.getPosition().getInitialPoint().length() != 0.0f) {
            sb.append(prefix).append("\tPosition: ").append(this.getPosition()).append("\n");
        }
        if (this.getRotation().hasAnimation() || this.getRotation().getInitialValue().floatValue() != 0.0f) {
            sb.append(prefix).append("\tRotation: ").append(this.getRotation()).append("\n");
        }
        if (this.getScale().hasAnimation() || !((ScaleXY)this.getScale().getInitialValue()).isDefault()) {
            sb.append(prefix).append("\tScale: ").append(this.getScale()).append("\n");
        }
        if (this.getAnchor().hasAnimation() || this.getAnchor().getInitialPoint().length() != 0.0f) {
            sb.append(prefix).append("\tAnchor: ").append(this.getAnchor()).append("\n");
        }
        if (!this.getMasks().isEmpty()) {
            sb.append(prefix).append("\tMasks: ").append(this.getMasks().size()).append("\n");
        }
        if (this.getSolidWidth() != 0 && this.getSolidHeight() != 0) {
            sb.append(prefix).append("\tBackground: ").append(String.format(Locale.US, "%dx%d %X\n", this.getSolidWidth(), this.getSolidHeight(), this.getSolidColor()));
        }
        if (!this.shapes.isEmpty()) {
            sb.append(prefix).append("\tShapes:\n");
            for (Object shape : this.shapes) {
                sb.append(prefix).append("\t\t").append(shape).append("\n");
            }
        }
        return sb.toString();
    }

    static enum MatteType {
        None,
        Add,
        Invert,
        Unknown;

    }

    private static enum LottieLayerType {
        None,
        Solid,
        Unknown,
        Null,
        Shape;

    }
}

