/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import com.airbnb.lottie.AnimatableLayer;
import com.airbnb.lottie.CircleShape;
import com.airbnb.lottie.EllipseShapeLayer;
import com.airbnb.lottie.RectLayer;
import com.airbnb.lottie.RectangleShape;
import com.airbnb.lottie.ShapeFill;
import com.airbnb.lottie.ShapeGroup;
import com.airbnb.lottie.ShapeLayerView;
import com.airbnb.lottie.ShapePath;
import com.airbnb.lottie.ShapeStroke;
import com.airbnb.lottie.ShapeTransform;
import com.airbnb.lottie.ShapeTrimPath;
import com.airbnb.lottie.Transform;
import java.util.ArrayList;
import java.util.Collections;

class GroupLayerView
extends AnimatableLayer {
    private final ShapeGroup shapeGroup;
    @Nullable
    private final Transform shapeTransform;

    GroupLayerView(ShapeGroup shapeGroup, @Nullable ShapeFill previousFill, @Nullable ShapeStroke previousStroke, @Nullable ShapeTrimPath previousTrimPath, @Nullable Transform previousTransform, Drawable.Callback callback) {
        super(callback);
        this.shapeGroup = shapeGroup;
        this.shapeTransform = previousTransform;
        this.setupShapeGroupWithFill(previousFill, previousStroke, previousTrimPath);
    }

    private void setupShapeGroupWithFill(ShapeFill previousFill, ShapeStroke previousStroke, ShapeTrimPath previousTrimPath) {
        if (this.shapeTransform != null) {
            this.setBounds(this.shapeTransform.getBounds());
            this.setAnchorPoint(this.shapeTransform.getAnchor().createAnimation());
            this.setPosition(this.shapeTransform.getPosition().createAnimation());
            this.setAlpha(this.shapeTransform.getOpacity().createAnimation());
            this.setTransform(this.shapeTransform.getScale().createAnimation());
            this.setRotation(this.shapeTransform.getRotation().createAnimation());
        }
        ArrayList<Object> reversedItems = new ArrayList<Object>(this.shapeGroup.getItems());
        Collections.reverse(reversedItems);
        ShapeFill currentFill = previousFill;
        ShapeStroke currentStroke = previousStroke;
        ShapeTransform currentTransform = null;
        ShapeTrimPath currentTrim = previousTrimPath;
        for (int i = 0; i < reversedItems.size(); ++i) {
            AnimatableLayer shapeLayer;
            Object item = reversedItems.get(i);
            if (item instanceof ShapeTransform) {
                currentTransform = (ShapeTransform)item;
                continue;
            }
            if (item instanceof ShapeStroke) {
                currentStroke = (ShapeStroke)item;
                continue;
            }
            if (item instanceof ShapeFill) {
                currentFill = (ShapeFill)item;
                continue;
            }
            if (item instanceof ShapeTrimPath) {
                currentTrim = (ShapeTrimPath)item;
                continue;
            }
            if (item instanceof ShapePath) {
                ShapePath shapePath = (ShapePath)item;
                shapeLayer = new ShapeLayerView(shapePath, currentFill, currentStroke, currentTrim, currentTransform, this.getCallback());
                this.addLayer(shapeLayer);
                continue;
            }
            if (item instanceof RectangleShape) {
                RectangleShape shapeRect = (RectangleShape)item;
                shapeLayer = new RectLayer(shapeRect, currentFill, currentStroke, currentTransform, this.getCallback());
                this.addLayer(shapeLayer);
                continue;
            }
            if (item instanceof CircleShape) {
                CircleShape shapeCircle = (CircleShape)item;
                shapeLayer = new EllipseShapeLayer(shapeCircle, currentFill, currentStroke, currentTrim, currentTransform, this.getCallback());
                this.addLayer(shapeLayer);
                continue;
            }
            if (!(item instanceof ShapeGroup)) continue;
            ShapeGroup shapeGroup = (ShapeGroup)item;
            GroupLayerView groupLayer = new GroupLayerView(shapeGroup, currentFill, currentStroke, currentTrim, currentTransform, this.getCallback());
            this.addLayer(groupLayer);
        }
    }
}

