/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import com.airbnb.lottie.BaseAnimatableValue;
import com.airbnb.lottie.KeyframeAnimation;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.ScaleKeyframeAnimation;
import com.airbnb.lottie.ScaleXY;
import com.airbnb.lottie.StaticKeyframeAnimation;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class AnimatableScaleValue
extends BaseAnimatableValue<ScaleXY, ScaleXY> {
    AnimatableScaleValue(LottieComposition composition) {
        super(composition);
        this.initialValue = new ScaleXY();
    }

    AnimatableScaleValue(JSONObject scaleValues, int frameRate, LottieComposition composition, boolean isDp) {
        super(scaleValues, frameRate, composition, isDp);
    }

    @Override
    protected ScaleXY valueFromObject(Object object, float scale) throws JSONException {
        JSONArray array = (JSONArray)object;
        try {
            if (array.length() >= 2) {
                return new ScaleXY().scale((float)array.getDouble(0) / 100.0f * scale, (float)array.getDouble(1) / 100.0f * scale);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return new ScaleXY();
    }

    @Override
    public KeyframeAnimation<ScaleXY> createAnimation() {
        if (!this.hasAnimation()) {
            return new StaticKeyframeAnimation<Object>(this.initialValue);
        }
        ScaleKeyframeAnimation animation = new ScaleKeyframeAnimation(this.duration, this.composition, this.keyTimes, this.keyValues, this.interpolators);
        animation.setStartDelay(this.delay);
        return animation;
    }
}

