/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import com.airbnb.lottie.AnimatableFloatValue;
import com.airbnb.lottie.AnimatableLayer;
import com.airbnb.lottie.AnimatableScaleValue;
import com.airbnb.lottie.KeyframeAnimation;
import com.airbnb.lottie.ShapeFill;
import com.airbnb.lottie.ShapeLayer;
import com.airbnb.lottie.ShapePath;
import com.airbnb.lottie.ShapeStroke;
import com.airbnb.lottie.ShapeTrimPath;
import com.airbnb.lottie.Transform;
import java.util.ArrayList;

class ShapeLayerView
extends AnimatableLayer {
    @Nullable
    private ShapeLayer fillLayer;
    @Nullable
    private ShapeLayer strokeLayer;

    ShapeLayerView(ShapePath shape, @Nullable ShapeFill fill, @Nullable ShapeStroke stroke, @Nullable ShapeTrimPath trim, Transform transformModel, Drawable.Callback callback) {
        super(callback);
        this.setBounds(transformModel.getBounds());
        this.setAnchorPoint(transformModel.getAnchor().createAnimation());
        this.setPosition(transformModel.getPosition().createAnimation());
        this.setRotation(transformModel.getRotation().createAnimation());
        AnimatableScaleValue scale = transformModel.getScale();
        this.setTransform(transformModel.getScale().createAnimation());
        if (fill != null) {
            this.fillLayer = new ShapeLayer(this.getCallback());
            this.fillLayer.setPath(shape.getShapePath().createAnimation());
            this.fillLayer.setColor(fill.getColor().createAnimation());
            this.fillLayer.setShapeAlpha(fill.getOpacity().createAnimation());
            this.fillLayer.setTransformAlpha(transformModel.getOpacity().createAnimation());
            this.fillLayer.setScale(scale.createAnimation());
            this.addLayer(this.fillLayer);
        }
        if (stroke != null) {
            this.strokeLayer = new ShapeLayer(this.getCallback());
            this.strokeLayer.setIsStroke();
            this.strokeLayer.setPath(shape.getShapePath().createAnimation());
            this.strokeLayer.setColor(stroke.getColor().createAnimation());
            this.strokeLayer.setShapeAlpha(stroke.getOpacity().createAnimation());
            this.strokeLayer.setTransformAlpha(transformModel.getOpacity().createAnimation());
            this.strokeLayer.setLineWidth(stroke.getWidth().createAnimation());
            if (!stroke.getLineDashPattern().isEmpty()) {
                ArrayList<KeyframeAnimation<Float>> dashPatternAnimations = new ArrayList<KeyframeAnimation<Float>>(stroke.getLineDashPattern().size());
                for (AnimatableFloatValue dashPattern : stroke.getLineDashPattern()) {
                    dashPatternAnimations.add(dashPattern.createAnimation());
                }
                this.strokeLayer.setDashPattern(dashPatternAnimations, stroke.getDashOffset().createAnimation());
            }
            this.strokeLayer.setLineCapType(stroke.getCapType());
            this.strokeLayer.setLineJoinType(stroke.getJoinType());
            this.strokeLayer.setScale(scale.createAnimation());
            if (trim != null) {
                this.strokeLayer.setTrimPath(trim.getStart().createAnimation(), trim.getEnd().createAnimation(), trim.getOffset().createAnimation());
            }
            this.addLayer(this.strokeLayer);
        }
    }

    @Override
    public void setAlpha(int alpha) {
        super.setAlpha(alpha);
        if (this.fillLayer != null) {
            this.fillLayer.setAlpha(alpha);
        }
        if (this.strokeLayer != null) {
            this.strokeLayer.setAlpha(alpha);
        }
    }
}

