/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.graphics.Path;
import android.graphics.PointF;
import java.util.ArrayList;
import java.util.List;

class SegmentedPath {
    private final List<Path> segments = new ArrayList<Path>();
    private final PointF currentPoint = new PointF();

    SegmentedPath() {
    }

    void moveTo(float x, float y) {
        this.currentPoint.set(x, y);
    }

    void lineTo(float x, float y) {
        Path path = new Path();
        if (this.currentPoint.x == x && this.currentPoint.y == y) {
            x += 0.01f;
            y += 0.01f;
        }
        path.moveTo(this.currentPoint.x, this.currentPoint.y);
        path.lineTo(x, y);
        this.segments.add(path);
        this.currentPoint.set(x, y);
    }

    void cubicTo(float x1, float y1, float x2, float y2, float x3, float y3) {
        Path path = new Path();
        path.moveTo(this.currentPoint.x, this.currentPoint.y);
        path.cubicTo(x1, y1, x2, y2, x3, y3);
        this.segments.add(path);
        this.currentPoint.set(x3, y3);
    }

    Path getSegment(int index) {
        return this.segments.get(index);
    }

    int getSegmentCount() {
        return this.segments.size();
    }

    boolean hasSegments() {
        return !this.segments.isEmpty();
    }
}

