/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Rect;
import android.os.AsyncTask;
import android.support.annotation.VisibleForTesting;
import android.support.v4.util.LongSparseArray;
import com.airbnb.lottie.Layer;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LottieComposition {
    private static final int MAX_PIXELS = 1000;
    private final LongSparseArray<Layer> layerMap = new LongSparseArray();
    private final List<Layer> layers = new ArrayList<Layer>();
    private Rect bounds;
    private long startFrame;
    private long endFrame;
    private int frameRate;
    private long duration;
    private boolean hasMasks;
    private boolean hasMattes;
    private float scale;

    public static Cancellable fromAssetFileName(Context context, String fileName, OnCompositionLoadedListener loadedListener) {
        InputStream stream;
        try {
            stream = context.getAssets().open(fileName);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to find file " + fileName, e);
        }
        return LottieComposition.fromInputStream(context, stream, loadedListener);
    }

    public static Cancellable fromInputStream(Context context, InputStream stream, OnCompositionLoadedListener loadedListener) {
        FileCompositionLoader loader = new FileCompositionLoader(context.getResources(), loadedListener);
        loader.execute(new InputStream[]{stream});
        return loader;
    }

    static LottieComposition fromFileSync(Context context, String fileName) {
        InputStream file;
        try {
            file = context.getAssets().open(fileName);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to find file " + fileName, e);
        }
        return LottieComposition.fromInputStream(context.getResources(), file);
    }

    public static Cancellable fromJson(Resources res, JSONObject json, OnCompositionLoadedListener loadedListener) {
        JsonCompositionLoader loader = new JsonCompositionLoader(res, loadedListener);
        loader.execute(new JSONObject[]{json});
        return loader;
    }

    static LottieComposition fromInputStream(Resources res, InputStream file) {
        try {
            int size = file.available();
            byte[] buffer = new byte[size];
            file.read(buffer);
            file.close();
            String json = new String(buffer, "UTF-8");
            JSONObject jsonObject = new JSONObject(json);
            return LottieComposition.fromJsonSync(res, jsonObject);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to find file.", e);
        }
        catch (JSONException e) {
            throw new IllegalStateException("Unable to load JSON.", e);
        }
    }

    static LottieComposition fromJsonSync(Resources res, JSONObject json) {
        int i;
        LottieComposition composition = new LottieComposition(res);
        int width = -1;
        int height = -1;
        try {
            width = json.getInt("w");
            height = json.getInt("h");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        if (width != -1 && height != -1) {
            int scaledWidth = (int)((float)width * composition.scale);
            int scaledHeight = (int)((float)height * composition.scale);
            if (Math.max(scaledWidth, scaledHeight) > 1000) {
                float factor = 1000.0f / (float)Math.max(scaledWidth, scaledHeight);
                scaledWidth = (int)((float)scaledWidth * factor);
                scaledHeight = (int)((float)scaledHeight * factor);
                composition.scale *= factor;
            }
            composition.bounds = new Rect(0, 0, scaledWidth, scaledHeight);
        }
        try {
            composition.startFrame = json.getLong("ip");
            composition.endFrame = json.getLong("op");
            composition.frameRate = json.getInt("fr");
        }
        catch (JSONException scaledWidth) {
            // empty catch block
        }
        if (composition.endFrame != 0L && composition.frameRate != 0) {
            long frameDuration = composition.endFrame - composition.startFrame;
            composition.duration = (long)((float)frameDuration / (float)composition.frameRate * 1000.0f);
        }
        try {
            JSONArray jsonLayers = json.getJSONArray("layers");
            for (i = 0; i < jsonLayers.length(); ++i) {
                Layer layer = Layer.fromJson(jsonLayers.getJSONObject(i), composition);
                LottieComposition.addLayer(composition, layer);
            }
        }
        catch (JSONException e) {
            throw new IllegalStateException("Unable to find layers.", e);
        }
        try {
            JSONArray assets = json.getJSONArray("assets");
            for (i = 0; i < assets.length(); ++i) {
                JSONObject asset = assets.getJSONObject(i);
                JSONArray layers = asset.getJSONArray("layers");
                for (int j = 0; j < layers.length(); ++j) {
                    Layer layer = Layer.fromJson(layers.getJSONObject(j), composition);
                    LottieComposition.addLayer(composition, layer);
                }
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return composition;
    }

    private static void addLayer(LottieComposition composition, Layer layer) {
        composition.layers.add(layer);
        composition.layerMap.put(layer.getId(), (Object)layer);
        if (!layer.getMasks().isEmpty()) {
            composition.hasMasks = true;
        }
        if (layer.getMatteType() != null && layer.getMatteType() != Layer.MatteType.None) {
            composition.hasMattes = true;
        }
    }

    private LottieComposition(Resources res) {
        this.scale = res.getDisplayMetrics().density;
    }

    @VisibleForTesting
    LottieComposition(long duration) {
        this.scale = 1.0f;
        this.duration = duration;
    }

    Layer layerModelForId(long id) {
        return (Layer)this.layerMap.get(id);
    }

    Rect getBounds() {
        return this.bounds;
    }

    long getDuration() {
        return this.duration;
    }

    long getEndFrame() {
        return this.endFrame;
    }

    int getFrameRate() {
        return this.frameRate;
    }

    List<Layer> getLayers() {
        return this.layers;
    }

    long getStartFrame() {
        return this.startFrame;
    }

    boolean hasMasks() {
        return this.hasMasks;
    }

    boolean hasMattes() {
        return this.hasMattes;
    }

    float getScale() {
        return this.scale;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("LottieComposition:\n");
        for (Layer layer : this.layers) {
            sb.append(layer.toString("\t"));
        }
        return sb.toString();
    }

    private static abstract class CompositionLoader<Params>
    extends AsyncTask<Params, Void, LottieComposition>
    implements Cancellable {
        private CompositionLoader() {
        }

        @Override
        public void cancel() {
            this.cancel(true);
        }
    }

    private static final class JsonCompositionLoader
    extends CompositionLoader<JSONObject> {
        private final Resources res;
        private final OnCompositionLoadedListener loadedListener;

        JsonCompositionLoader(Resources res, OnCompositionLoadedListener loadedListener) {
            this.res = res;
            this.loadedListener = loadedListener;
        }

        protected LottieComposition doInBackground(JSONObject ... params) {
            return LottieComposition.fromJsonSync(this.res, params[0]);
        }

        protected void onPostExecute(LottieComposition composition) {
            this.loadedListener.onCompositionLoaded(composition);
        }
    }

    private static final class FileCompositionLoader
    extends CompositionLoader<InputStream> {
        private final Resources res;
        private final OnCompositionLoadedListener loadedListener;

        FileCompositionLoader(Resources res, OnCompositionLoadedListener loadedListener) {
            this.res = res;
            this.loadedListener = loadedListener;
        }

        protected LottieComposition doInBackground(InputStream ... params) {
            return LottieComposition.fromInputStream(this.res, params[0]);
        }

        protected void onPostExecute(LottieComposition composition) {
            this.loadedListener.onCompositionLoaded(composition);
        }
    }

    static interface Cancellable {
        public void cancel();
    }

    public static interface OnCompositionLoadedListener {
        public void onCompositionLoaded(LottieComposition var1);
    }
}

