/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.graphics.PointF;
import com.airbnb.lottie.AnimatableFloatValue;
import com.airbnb.lottie.IAnimatablePathValue;
import com.airbnb.lottie.KeyframeAnimation;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.SplitDimensionPathKeyframeAnimation;
import org.json.JSONException;
import org.json.JSONObject;

class AnimatableSplitDimensionPathValue
implements IAnimatablePathValue {
    private final PointF point = new PointF();
    private final AnimatableFloatValue animatableXDimension;
    private final AnimatableFloatValue animatableYDimension;

    AnimatableSplitDimensionPathValue(JSONObject pointValue, LottieComposition composition) {
        try {
            this.animatableXDimension = new AnimatableFloatValue(pointValue.getJSONObject("x"), composition.getFrameRate(), composition);
            this.animatableYDimension = new AnimatableFloatValue(pointValue.getJSONObject("y"), composition.getFrameRate(), composition);
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Unable to parse split dimension path.");
        }
    }

    @Override
    public KeyframeAnimation<PointF> createAnimation() {
        return new SplitDimensionPathKeyframeAnimation(this.animatableXDimension.createAnimation(), this.animatableYDimension.createAnimation());
    }

    @Override
    public boolean hasAnimation() {
        return this.animatableXDimension.hasAnimation() || this.animatableYDimension.hasAnimation();
    }

    @Override
    public PointF getInitialPoint() {
        this.point.set(this.animatableXDimension.getInitialValue().floatValue(), this.animatableYDimension.getInitialValue().floatValue());
        return this.point;
    }
}

