/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.graphics.PointF;
import com.airbnb.lottie.BaseAnimatableValue;
import com.airbnb.lottie.JsonUtils;
import com.airbnb.lottie.KeyframeAnimation;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.PointKeyframeAnimation;
import com.airbnb.lottie.StaticKeyframeAnimation;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class AnimatablePointValue
extends BaseAnimatableValue<PointF, PointF> {
    AnimatablePointValue(JSONObject pointValues, int frameRate, LottieComposition composition) {
        super(pointValues, frameRate, composition, true);
    }

    @Override
    protected PointF valueFromObject(Object object, float scale) throws JSONException {
        if (object instanceof JSONArray) {
            return JsonUtils.pointFromJsonArray((JSONArray)object, scale);
        }
        if (object instanceof JSONObject) {
            return JsonUtils.pointValueFromJsonObject((JSONObject)object, scale);
        }
        throw new IllegalArgumentException("Unable to parse point from " + object);
    }

    @Override
    public KeyframeAnimation<PointF> createAnimation() {
        if (!this.hasAnimation()) {
            return new StaticKeyframeAnimation<Object>(this.initialValue);
        }
        PointKeyframeAnimation animation = new PointKeyframeAnimation(this.duration, this.composition, this.keyTimes, this.keyValues, this.interpolators);
        animation.setStartDelay(this.delay);
        return animation;
    }

    @Override
    public boolean hasAnimation() {
        return !this.keyValues.isEmpty();
    }
}

