/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.graphics.Color;
import com.airbnb.lottie.BaseAnimatableValue;
import com.airbnb.lottie.ColorKeyframeAnimation;
import com.airbnb.lottie.KeyframeAnimation;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.StaticKeyframeAnimation;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class AnimatableColorValue
extends BaseAnimatableValue<Integer, Integer> {
    AnimatableColorValue(JSONObject json, int frameRate, LottieComposition composition) {
        super(json, frameRate, composition, false);
    }

    @Override
    protected Integer valueFromObject(Object object, float scale) throws JSONException {
        JSONArray colorArray = (JSONArray)object;
        if (colorArray.length() == 4) {
            boolean shouldUse255 = true;
            for (int i = 0; i < colorArray.length(); ++i) {
                double colorChannel = colorArray.getDouble(i);
                if (!(colorChannel > 1.0)) continue;
                shouldUse255 = false;
            }
            float multiplier = shouldUse255 ? 255.0f : 1.0f;
            return Color.argb((int)((int)(colorArray.getDouble(3) * (double)multiplier)), (int)((int)(colorArray.getDouble(0) * (double)multiplier)), (int)((int)(colorArray.getDouble(1) * (double)multiplier)), (int)((int)(colorArray.getDouble(2) * (double)multiplier)));
        }
        return -16777216;
    }

    @Override
    public KeyframeAnimation<Integer> createAnimation() {
        if (!this.hasAnimation()) {
            return new StaticKeyframeAnimation<Object>(this.initialValue);
        }
        ColorKeyframeAnimation animation = new ColorKeyframeAnimation(this.duration, this.composition, this.keyTimes, this.keyValues, this.interpolators);
        animation.setStartDelay(this.delay);
        return animation;
    }

    @Override
    public String toString() {
        return "AnimatableColorValue{initialValue=" + this.initialValue + '}';
    }
}

