/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.model;

import android.support.annotation.RestrictTo;
import com.airbnb.lottie.animatable.AnimatableColorValue;
import com.airbnb.lottie.animatable.AnimatableFloatValue;
import com.airbnb.lottie.animatable.AnimatableIntegerValue;
import com.airbnb.lottie.model.LottieComposition;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.GROUP_ID})
public class ShapeStroke {
    private AnimatableFloatValue offset;
    private final List<AnimatableFloatValue> lineDashPattern = new ArrayList<AnimatableFloatValue>();
    private AnimatableColorValue color;
    private AnimatableIntegerValue opacity;
    private AnimatableFloatValue width;
    private LineCapType capType;
    private LineJoinType joinType;

    ShapeStroke(JSONObject json, int frameRate, LottieComposition composition) {
        try {
            JSONObject colorJson = json.getJSONObject("c");
            this.color = new AnimatableColorValue(colorJson, frameRate, composition);
            JSONObject widthJson = json.getJSONObject("w");
            this.width = new AnimatableFloatValue(widthJson, frameRate, composition);
            JSONObject opacityJson = json.getJSONObject("o");
            this.opacity = new AnimatableIntegerValue(opacityJson, frameRate, composition, false, true);
            this.capType = LineCapType.values()[json.getInt("lc") - 1];
            this.joinType = LineJoinType.values()[json.getInt("lj") - 1];
            if (json.has("d")) {
                JSONArray dashesJson = json.getJSONArray("d");
                for (int i = 0; i < dashesJson.length(); ++i) {
                    JSONObject value;
                    JSONObject dashJson = dashesJson.getJSONObject(i);
                    String n = dashJson.getString("n");
                    if (n.equals("o")) {
                        value = dashJson.getJSONObject("v");
                        this.offset = new AnimatableFloatValue(value, frameRate, composition);
                        continue;
                    }
                    if (!n.equals("d") && !n.equals("g")) continue;
                    value = dashJson.getJSONObject("v");
                    this.lineDashPattern.add(new AnimatableFloatValue(value, frameRate, composition));
                }
                if (this.lineDashPattern.size() == 1) {
                    this.lineDashPattern.add(this.lineDashPattern.get(0));
                }
            }
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Unable to parse stroke " + json, e);
        }
    }

    public AnimatableColorValue getColor() {
        return this.color;
    }

    public AnimatableIntegerValue getOpacity() {
        return this.opacity;
    }

    public AnimatableFloatValue getWidth() {
        return this.width;
    }

    public List<AnimatableFloatValue> getLineDashPattern() {
        return this.lineDashPattern;
    }

    public AnimatableFloatValue getDashOffset() {
        return this.offset;
    }

    public LineCapType getCapType() {
        return this.capType;
    }

    public LineJoinType getJoinType() {
        return this.joinType;
    }

    public static enum LineJoinType {
        Miter,
        Round,
        Bevel;

    }

    public static enum LineCapType {
        Butt,
        Round,
        Unknown;

    }
}

