/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.model;

import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import com.airbnb.lottie.model.CircleShape;
import com.airbnb.lottie.model.LottieComposition;
import com.airbnb.lottie.model.RectangleShape;
import com.airbnb.lottie.model.ShapeFill;
import com.airbnb.lottie.model.ShapePath;
import com.airbnb.lottie.model.ShapeStroke;
import com.airbnb.lottie.model.ShapeTransform;
import com.airbnb.lottie.model.ShapeTrimPath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.GROUP_ID})
public class ShapeGroup {
    private String name;
    private final List<Object> items = new ArrayList<Object>();

    @Nullable
    static Object shapeItemWithJson(JSONObject json, int framerate, LottieComposition composition) {
        String type = null;
        try {
            type = json.getString("ty");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        if (type == null) {
            throw new IllegalStateException("Shape has no type.");
        }
        switch (type) {
            case "gr": {
                return new ShapeGroup(json, framerate, composition);
            }
            case "st": {
                return new ShapeStroke(json, framerate, composition);
            }
            case "fl": {
                return new ShapeFill(json, framerate, composition);
            }
            case "tr": {
                return new ShapeTransform(json, framerate, composition);
            }
            case "sh": {
                return new ShapePath(json, framerate, composition);
            }
            case "el": {
                return new CircleShape(json, framerate, composition);
            }
            case "rc": {
                return new RectangleShape(json, framerate, composition);
            }
            case "tm": {
                return new ShapeTrimPath(json, framerate, composition);
            }
        }
        return null;
    }

    private ShapeGroup(JSONObject json, int frameRate, LottieComposition composition) {
        JSONArray jsonItems = null;
        try {
            jsonItems = json.getJSONArray("it");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        if (jsonItems == null) {
            jsonItems = new JSONArray();
        }
        try {
            this.name = json.getString("nm");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        for (int i = 0; i < jsonItems.length(); ++i) {
            JSONObject jsonItem = null;
            try {
                jsonItem = jsonItems.getJSONObject(i);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            if (jsonItem == null) {
                throw new IllegalStateException("Unable to get jsonItem");
            }
            Object newItem = ShapeGroup.shapeItemWithJson(jsonItem, frameRate, composition);
            if (newItem == null) continue;
            this.items.add(newItem);
        }
    }

    public List<Object> getItems() {
        return this.items;
    }

    public String toString() {
        return "ShapeGroup{name='" + this.name + "' Shapes: " + Arrays.toString(this.items.toArray()) + '}';
    }
}

