/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.model;

import android.support.annotation.RestrictTo;
import com.airbnb.lottie.animatable.AnimatableColorValue;
import com.airbnb.lottie.animatable.AnimatableIntegerValue;
import com.airbnb.lottie.model.LottieComposition;
import org.json.JSONException;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.GROUP_ID})
public class ShapeFill {
    private static final String TAG = ShapeFill.class.getSimpleName();
    private boolean fillEnabled;
    private AnimatableColorValue color;
    private AnimatableIntegerValue opacity;

    ShapeFill(JSONObject json, int frameRate, LottieComposition composition) {
        JSONObject jsonColor = null;
        try {
            jsonColor = json.getJSONObject("c");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        if (jsonColor != null) {
            this.color = new AnimatableColorValue(jsonColor, frameRate, composition);
        }
        JSONObject jsonOpacity = null;
        try {
            jsonOpacity = json.getJSONObject("o");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        if (jsonOpacity != null) {
            this.opacity = new AnimatableIntegerValue(jsonOpacity, frameRate, composition, false, true);
        }
        try {
            this.fillEnabled = json.getBoolean("fillEnabled");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public AnimatableColorValue getColor() {
        return this.color;
    }

    public AnimatableIntegerValue getOpacity() {
        return this.opacity;
    }

    public String toString() {
        return "ShapeFill{color=" + Integer.toHexString((Integer)this.color.getInitialValue()) + ", fillEnabled=" + this.fillEnabled + ", opacity=" + this.opacity.getInitialValue() + '}';
    }
}

