/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.model;

import android.support.annotation.RestrictTo;
import com.airbnb.lottie.animatable.AnimatableFloatValue;
import com.airbnb.lottie.animatable.AnimatablePathValue;
import com.airbnb.lottie.animatable.AnimatablePointValue;
import com.airbnb.lottie.model.LottieComposition;
import org.json.JSONException;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.GROUP_ID})
public class RectangleShape {
    private static final String TAG = RectangleShape.class.getSimpleName();
    private AnimatablePathValue position;
    private AnimatablePointValue size;
    private AnimatableFloatValue cornerRadius;

    RectangleShape(JSONObject json, int frameRate, LottieComposition composition) {
        try {
            JSONObject positionJson = json.getJSONObject("p");
            this.position = new AnimatablePathValue(positionJson, frameRate, composition);
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Unable to parse rectangle position.", e);
        }
        try {
            JSONObject cornerRadiusJson = json.getJSONObject("r");
            this.cornerRadius = new AnimatableFloatValue(cornerRadiusJson, frameRate, composition);
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Unable to parse rectangle corner radius.", e);
        }
        try {
            JSONObject sizeJson = json.getJSONObject("s");
            this.size = new AnimatablePointValue(sizeJson, frameRate, composition);
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Unable to parse rectangle size.", e);
        }
    }

    public AnimatableFloatValue getCornerRadius() {
        return this.cornerRadius;
    }

    public AnimatablePointValue getSize() {
        return this.size;
    }

    public AnimatablePathValue getPosition() {
        return this.position;
    }

    public String toString() {
        return "RectangleShape{cornerRadius=" + this.cornerRadius.getInitialValue() + ", position=" + this.position + ", size=" + this.size + '}';
    }
}

