/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.layers;

import android.graphics.Canvas;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.PathEffect;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.airbnb.lottie.animatable.AnimatableFloatValue;
import com.airbnb.lottie.animation.KeyframeAnimation;
import com.airbnb.lottie.layers.AnimatableLayer;
import com.airbnb.lottie.model.RectangleShape;
import com.airbnb.lottie.model.ShapeFill;
import com.airbnb.lottie.model.ShapeStroke;
import com.airbnb.lottie.model.Transform;
import java.util.ArrayList;
import java.util.List;

class RectLayer
extends AnimatableLayer {
    @Nullable
    private RoundRectLayer fillLayer;
    @Nullable
    private RoundRectLayer strokeLayer;

    RectLayer(RectangleShape rectShape, @Nullable ShapeFill fill, @Nullable ShapeStroke stroke, Transform transform, Drawable.Callback callback) {
        super(callback);
        this.setBounds(transform.getBounds());
        this.setAnchorPoint(transform.getAnchor().createAnimation());
        this.setAlpha(transform.getOpacity().createAnimation());
        this.setPosition(transform.getPosition().createAnimation());
        this.setTransform(transform.getScale().createAnimation());
        this.setRotation(transform.getRotation().createAnimation());
        if (fill != null) {
            this.fillLayer = new RoundRectLayer(this.getCallback());
            this.fillLayer.setColor(fill.getColor().createAnimation());
            this.fillLayer.setShapeAlpha(fill.getOpacity().createAnimation());
            this.fillLayer.setTransformAlpha(transform.getOpacity().createAnimation());
            this.fillLayer.setRectCornerRadius(rectShape.getCornerRadius().createAnimation());
            this.fillLayer.setRectSize(rectShape.getSize().createAnimation());
            this.fillLayer.setRectPosition(rectShape.getPosition().createAnimation());
            this.addLayer(this.fillLayer);
        }
        if (stroke != null) {
            this.strokeLayer = new RoundRectLayer(this.getCallback());
            this.strokeLayer.setIsStroke();
            this.strokeLayer.setColor(stroke.getColor().createAnimation());
            this.strokeLayer.setShapeAlpha(stroke.getOpacity().createAnimation());
            this.strokeLayer.setTransformAlpha(transform.getOpacity().createAnimation());
            this.strokeLayer.setLineWidth(stroke.getWidth().createAnimation());
            if (!stroke.getLineDashPattern().isEmpty()) {
                ArrayList<KeyframeAnimation<Float>> dashPatternAnimations = new ArrayList<KeyframeAnimation<Float>>(stroke.getLineDashPattern().size());
                for (AnimatableFloatValue dashPattern : stroke.getLineDashPattern()) {
                    dashPatternAnimations.add(dashPattern.createAnimation());
                }
                this.strokeLayer.setDashPattern(dashPatternAnimations, stroke.getDashOffset().createAnimation());
            }
            this.strokeLayer.setLineCapType(stroke.getCapType());
            this.strokeLayer.setRectCornerRadius(rectShape.getCornerRadius().createAnimation());
            this.strokeLayer.setRectSize(rectShape.getSize().createAnimation());
            this.strokeLayer.setRectPosition(rectShape.getPosition().createAnimation());
            this.strokeLayer.setLineJoinType(stroke.getJoinType());
            this.addLayer(this.strokeLayer);
        }
    }

    @Override
    public void setAlpha(int alpha) {
        super.setAlpha(alpha);
        if (this.fillLayer != null) {
            this.fillLayer.setAlpha(alpha);
        }
        if (this.strokeLayer != null) {
            this.strokeLayer.setAlpha(alpha);
        }
    }

    private static class RoundRectLayer
    extends AnimatableLayer {
        private final KeyframeAnimation.AnimationListener<Integer> alphaChangedListener = new KeyframeAnimation.AnimationListener<Integer>(){

            @Override
            public void onValueChanged(Integer value) {
                RoundRectLayer.this.invalidateSelf();
            }
        };
        private final KeyframeAnimation.AnimationListener<Integer> colorChangedListener = new KeyframeAnimation.AnimationListener<Integer>(){

            @Override
            public void onValueChanged(Integer value) {
                RoundRectLayer.this.onColorChanged();
            }
        };
        private final KeyframeAnimation.AnimationListener<Float> lineWidthChangedListener = new KeyframeAnimation.AnimationListener<Float>(){

            @Override
            public void onValueChanged(Float value) {
                RoundRectLayer.this.onLineWidthChanged();
            }
        };
        private final KeyframeAnimation.AnimationListener<Float> dashPatternChangedListener = new KeyframeAnimation.AnimationListener<Float>(){

            @Override
            public void onValueChanged(Float value) {
                RoundRectLayer.this.onDashPatternChanged();
            }
        };
        private final KeyframeAnimation.AnimationListener<Float> cornerRadiusChangedListener = new KeyframeAnimation.AnimationListener<Float>(){

            @Override
            public void onValueChanged(Float value) {
                RoundRectLayer.this.invalidateSelf();
            }
        };
        private final KeyframeAnimation.AnimationListener<PointF> rectPositionChangedListener = new KeyframeAnimation.AnimationListener<PointF>(){

            @Override
            public void onValueChanged(PointF value) {
                RoundRectLayer.this.invalidateSelf();
            }
        };
        private final KeyframeAnimation.AnimationListener<PointF> rectSizeChangedListener = new KeyframeAnimation.AnimationListener<PointF>(){

            @Override
            public void onValueChanged(PointF value) {
                RoundRectLayer.this.invalidateSelf();
            }
        };
        private final Paint paint = new Paint();
        private final RectF fillRect = new RectF();
        private KeyframeAnimation<Integer> color;
        private KeyframeAnimation<Float> lineWidth;
        private KeyframeAnimation<Integer> shapeAlpha;
        private KeyframeAnimation<Integer> transformAlpha;
        private KeyframeAnimation<Float> rectCornerRadius;
        private KeyframeAnimation<PointF> rectPosition;
        private KeyframeAnimation<PointF> rectSize;
        @Nullable
        private List<KeyframeAnimation<Float>> lineDashPattern;
        @Nullable
        private KeyframeAnimation<Float> lineDashPatternOffset;

        RoundRectLayer(Drawable.Callback callback) {
            super(callback);
            this.paint.setAntiAlias(true);
            this.paint.setStyle(Paint.Style.FILL);
        }

        void setShapeAlpha(KeyframeAnimation<Integer> shapeAlpha) {
            if (this.shapeAlpha != null) {
                this.removeAnimation(this.shapeAlpha);
                this.shapeAlpha.removeUpdateListener(this.alphaChangedListener);
            }
            this.shapeAlpha = shapeAlpha;
            this.addAnimation(shapeAlpha);
            shapeAlpha.addUpdateListener(this.alphaChangedListener);
            this.invalidateSelf();
        }

        void setTransformAlpha(KeyframeAnimation<Integer> transformAlpha) {
            if (this.transformAlpha != null) {
                this.removeAnimation(this.transformAlpha);
                this.transformAlpha.removeUpdateListener(this.alphaChangedListener);
            }
            this.transformAlpha = transformAlpha;
            this.addAnimation(transformAlpha);
            transformAlpha.addUpdateListener(this.alphaChangedListener);
            this.invalidateSelf();
        }

        @Override
        public void setAlpha(int alpha) {
            this.paint.setAlpha(alpha);
        }

        @Override
        public int getAlpha() {
            Integer shapeAlpha = this.shapeAlpha == null ? 255 : this.shapeAlpha.getValue();
            Integer transformAlpha = this.transformAlpha == null ? 255 : this.transformAlpha.getValue();
            int layerAlpha = super.getAlpha();
            return (int)((float)shapeAlpha.intValue() / 255.0f * (float)transformAlpha.intValue() / 255.0f * (float)layerAlpha / 255.0f * 255.0f);
        }

        public void setColor(KeyframeAnimation<Integer> color) {
            if (this.color != null) {
                this.removeAnimation(this.color);
                this.color.removeUpdateListener(this.colorChangedListener);
            }
            this.color = color;
            this.addAnimation(color);
            color.addUpdateListener(this.colorChangedListener);
            this.onColorChanged();
        }

        private void onColorChanged() {
            this.paint.setColor(this.color.getValue().intValue());
            this.invalidateSelf();
        }

        private void setIsStroke() {
            this.paint.setStyle(Paint.Style.STROKE);
            this.invalidateSelf();
        }

        void setLineWidth(KeyframeAnimation<Float> lineWidth) {
            if (this.lineWidth != null) {
                this.removeAnimation(this.lineWidth);
                this.lineWidth.removeUpdateListener(this.lineWidthChangedListener);
            }
            this.lineWidth = lineWidth;
            this.addAnimation(lineWidth);
            lineWidth.addUpdateListener(this.lineWidthChangedListener);
            this.onLineWidthChanged();
        }

        private void onLineWidthChanged() {
            this.paint.setStrokeWidth(this.lineWidth.getValue().floatValue());
            this.invalidateSelf();
        }

        void setDashPattern(List<KeyframeAnimation<Float>> lineDashPattern, KeyframeAnimation<Float> offset) {
            if (this.lineDashPattern != null) {
                this.removeAnimation(this.lineDashPattern.get(0));
                this.lineDashPattern.get(0).removeUpdateListener(this.dashPatternChangedListener);
                this.removeAnimation(this.lineDashPattern.get(1));
                this.lineDashPattern.get(1).removeUpdateListener(this.dashPatternChangedListener);
            }
            if (this.lineDashPatternOffset != null) {
                this.removeAnimation(this.lineDashPatternOffset);
                this.lineDashPatternOffset.removeUpdateListener(this.dashPatternChangedListener);
            }
            if (lineDashPattern.isEmpty()) {
                return;
            }
            this.lineDashPattern = lineDashPattern;
            this.lineDashPatternOffset = offset;
            this.addAnimation(lineDashPattern.get(0));
            this.addAnimation(lineDashPattern.get(1));
            lineDashPattern.get(0).addUpdateListener(this.dashPatternChangedListener);
            if (!lineDashPattern.get(1).equals(lineDashPattern.get(1))) {
                lineDashPattern.get(1).addUpdateListener(this.dashPatternChangedListener);
            }
            this.addAnimation(offset);
            offset.addUpdateListener(this.dashPatternChangedListener);
            this.onDashPatternChanged();
        }

        private void onDashPatternChanged() {
            if (this.lineDashPattern == null || this.lineDashPatternOffset == null) {
                throw new IllegalStateException("LineDashPattern is null");
            }
            float[] values = new float[this.lineDashPattern.size()];
            for (int i = 0; i < this.lineDashPattern.size(); ++i) {
                values[i] = this.lineDashPattern.get(i).getValue().floatValue();
            }
            this.paint.setPathEffect((PathEffect)new DashPathEffect(values, this.lineDashPatternOffset.getValue().floatValue()));
            this.invalidateSelf();
        }

        void setLineCapType(ShapeStroke.LineCapType lineCapType) {
            switch (lineCapType) {
                case Round: {
                    this.paint.setStrokeCap(Paint.Cap.ROUND);
                    break;
                }
                case Butt: {
                    this.paint.setStrokeCap(Paint.Cap.BUTT);
                }
            }
        }

        void setLineJoinType(ShapeStroke.LineJoinType lineJoinType) {
            switch (lineJoinType) {
                case Bevel: {
                    this.paint.setStrokeJoin(Paint.Join.BEVEL);
                    break;
                }
                case Miter: {
                    this.paint.setStrokeJoin(Paint.Join.MITER);
                    break;
                }
                case Round: {
                    this.paint.setStrokeJoin(Paint.Join.ROUND);
                }
            }
        }

        void setRectCornerRadius(KeyframeAnimation<Float> rectCornerRadius) {
            if (this.rectCornerRadius != null) {
                this.removeAnimation(rectCornerRadius);
                this.rectCornerRadius.removeUpdateListener(this.cornerRadiusChangedListener);
            }
            this.rectCornerRadius = rectCornerRadius;
            this.addAnimation(rectCornerRadius);
            rectCornerRadius.addUpdateListener(this.cornerRadiusChangedListener);
            this.invalidateSelf();
        }

        void setRectPosition(KeyframeAnimation<PointF> rectPosition) {
            if (this.rectPosition != null) {
                this.removeAnimation(this.rectPosition);
                this.rectPosition.removeUpdateListener(this.rectPositionChangedListener);
            }
            this.rectPosition = rectPosition;
            this.addAnimation(rectPosition);
            rectPosition.addUpdateListener(this.rectPositionChangedListener);
            this.invalidateSelf();
        }

        void setRectSize(KeyframeAnimation<PointF> rectSize) {
            if (this.rectSize != null) {
                this.removeAnimation(this.rectSize);
                this.rectSize.removeUpdateListener(this.rectSizeChangedListener);
            }
            this.rectSize = rectSize;
            this.addAnimation(rectSize);
            rectSize.addUpdateListener(this.rectSizeChangedListener);
            this.invalidateSelf();
        }

        @Override
        public void draw(@NonNull Canvas canvas) {
            if (this.paint.getStyle() == Paint.Style.STROKE && this.paint.getStrokeWidth() == 0.0f) {
                return;
            }
            this.paint.setAlpha(this.getAlpha());
            float halfWidth = this.rectSize.getValue().x / 2.0f;
            float halfHeight = this.rectSize.getValue().y / 2.0f;
            this.fillRect.set(this.rectPosition.getValue().x - halfWidth, this.rectPosition.getValue().y - halfHeight, this.rectPosition.getValue().x + halfWidth, this.rectPosition.getValue().y + halfHeight);
            if (this.rectCornerRadius.getValue().floatValue() == 0.0f) {
                canvas.drawRect(this.fillRect, this.paint);
            } else {
                canvas.drawRoundRect(this.fillRect, this.rectCornerRadius.getValue().floatValue(), this.rectCornerRadius.getValue().floatValue(), this.paint);
            }
        }
    }
}

