/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.layers;

import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.drawable.Drawable;
import com.airbnb.lottie.animatable.AnimatableFloatValue;
import com.airbnb.lottie.animation.KeyframeAnimation;
import com.airbnb.lottie.animation.StaticKeyframeAnimation;
import com.airbnb.lottie.layers.AnimatableLayer;
import com.airbnb.lottie.layers.ShapeLayer;
import com.airbnb.lottie.model.CircleShape;
import com.airbnb.lottie.model.ShapeFill;
import com.airbnb.lottie.model.ShapeStroke;
import com.airbnb.lottie.model.ShapeTrimPath;
import com.airbnb.lottie.model.Transform;
import java.util.ArrayList;

class EllipseShapeLayer
extends AnimatableLayer {
    EllipseShapeLayer(CircleShape circleShape, ShapeFill fill, ShapeStroke stroke, ShapeTrimPath trim, Transform transform, Drawable.Callback callback) {
        super(callback);
        this.setBounds(transform.getBounds());
        this.setAnchorPoint(transform.getAnchor().createAnimation());
        this.setAlpha(transform.getOpacity().createAnimation());
        this.setPosition(transform.getPosition().createAnimation());
        this.setTransform(transform.getScale().createAnimation());
        this.setRotation(transform.getRotation().createAnimation());
        if (fill != null) {
            CircleShapeLayer fillLayer = new CircleShapeLayer(this.getCallback());
            fillLayer.setColor(fill.getColor().createAnimation());
            fillLayer.setAlpha(fill.getOpacity().createAnimation());
            fillLayer.updateCircle(circleShape.getPosition().createAnimation(), circleShape.getSize().createAnimation());
            this.addLayer(fillLayer);
        }
        if (stroke != null) {
            CircleShapeLayer strokeLayer = new CircleShapeLayer(this.getCallback());
            strokeLayer.setIsStroke();
            strokeLayer.setColor(stroke.getColor().createAnimation());
            strokeLayer.setAlpha(stroke.getOpacity().createAnimation());
            strokeLayer.setLineWidth(stroke.getWidth().createAnimation());
            if (!stroke.getLineDashPattern().isEmpty()) {
                ArrayList<KeyframeAnimation<Float>> dashPatternAnimations = new ArrayList<KeyframeAnimation<Float>>(stroke.getLineDashPattern().size());
                for (AnimatableFloatValue dashPattern : stroke.getLineDashPattern()) {
                    dashPatternAnimations.add(dashPattern.createAnimation());
                }
                strokeLayer.setDashPattern(dashPatternAnimations, stroke.getDashOffset().createAnimation());
            }
            strokeLayer.setLineCapType(stroke.getCapType());
            strokeLayer.updateCircle(circleShape.getPosition().createAnimation(), circleShape.getSize().createAnimation());
            if (trim != null) {
                strokeLayer.setTrimPath(trim.getStart().createAnimation(), trim.getEnd().createAnimation(), trim.getOffset().createAnimation());
            }
            this.addLayer(strokeLayer);
        }
    }

    private static final class CircleShapeLayer
    extends ShapeLayer {
        private static final float ELLIPSE_CONTROL_POINT_PERCENTAGE = 0.55228f;
        private final KeyframeAnimation.AnimationListener<PointF> circleSizeChangedListener = new KeyframeAnimation.AnimationListener<PointF>(){

            @Override
            public void onValueChanged(PointF progress) {
                CircleShapeLayer.this.onCircleSizeChanged();
            }
        };
        private final KeyframeAnimation.AnimationListener<PointF> circlePositionChangedListener = new KeyframeAnimation.AnimationListener<PointF>(){

            @Override
            public void onValueChanged(PointF progress) {
                CircleShapeLayer.this.invalidateSelf();
            }
        };
        private final Paint paint = new Paint();
        private final Path path = new Path();
        private KeyframeAnimation<PointF> circleSize;
        private KeyframeAnimation<PointF> circlePosition;

        CircleShapeLayer(Drawable.Callback callback) {
            super(callback);
            this.paint.setAntiAlias(true);
            this.paint.setStyle(Paint.Style.FILL);
            this.setPath(new StaticKeyframeAnimation<Path>(this.path));
        }

        void updateCircle(KeyframeAnimation<PointF> circlePosition, KeyframeAnimation<PointF> circleSize) {
            if (this.circleSize != null) {
                this.removeAnimation(this.circleSize);
                this.circleSize.removeUpdateListener(this.circleSizeChangedListener);
            }
            if (this.circlePosition != null) {
                this.removeAnimation(this.circlePosition);
                this.circlePosition.removeUpdateListener(this.circlePositionChangedListener);
            }
            this.circleSize = circleSize;
            this.circlePosition = circlePosition;
            this.addAnimation(circleSize);
            circleSize.addUpdateListener(this.circleSizeChangedListener);
            this.addAnimation(circlePosition);
            circlePosition.addUpdateListener(this.circlePositionChangedListener);
            this.onCircleSizeChanged();
        }

        private void onCircleSizeChanged() {
            float halfWidth = this.circleSize.getValue().x / 2.0f;
            float halfHeight = this.circleSize.getValue().y / 2.0f;
            this.setBounds(0, 0, (int)halfWidth * 2, (int)halfHeight * 2);
            float cpW = halfWidth * 0.55228f;
            float cpH = halfHeight * 0.55228f;
            this.path.reset();
            this.path.moveTo(0.0f, -halfHeight);
            this.path.cubicTo(0.0f + cpW, -halfHeight, halfWidth, 0.0f - cpH, halfWidth, 0.0f);
            this.path.cubicTo(halfWidth, 0.0f + cpH, 0.0f + cpW, halfHeight, 0.0f, halfHeight);
            this.path.cubicTo(0.0f - cpW, halfHeight, -halfWidth, 0.0f + cpH, -halfWidth, 0.0f);
            this.path.cubicTo(-halfWidth, 0.0f - cpH, 0.0f - cpW, -halfHeight, 0.0f, -halfHeight);
            this.path.offset(this.circlePosition.getValue().x, this.circlePosition.getValue().y);
            this.onPathChanged();
            this.invalidateSelf();
        }
    }
}

