/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.animation;

import android.support.annotation.RestrictTo;
import android.view.animation.Interpolator;
import com.airbnb.lottie.animation.KeyframeAnimation;
import com.airbnb.lottie.model.LottieComposition;
import com.airbnb.lottie.utils.MiscUtils;
import com.airbnb.lottie.utils.ScaleXY;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.GROUP_ID})
public class ScaleKeyframeAnimation
extends KeyframeAnimation<ScaleXY> {
    private final ScaleXY outTransform = new ScaleXY();
    private final List<ScaleXY> transforms;

    public ScaleKeyframeAnimation(long duration, LottieComposition composition, List<Float> keyTimes, List<ScaleXY> transforms, List<Interpolator> interpolators) {
        super(duration, composition, keyTimes, interpolators);
        this.transforms = transforms;
    }

    @Override
    public ScaleXY getValue() {
        if (this.progress <= 0.0f) {
            return this.transforms.get(0);
        }
        if (this.progress >= 1.0f) {
            return this.transforms.get(this.transforms.size() - 1);
        }
        int keyframeIndex = this.getKeyframeIndex();
        float startKeytime = ((Float)this.keyTimes.get(keyframeIndex)).floatValue();
        float endKeytime = ((Float)this.keyTimes.get(keyframeIndex + 1)).floatValue();
        float percentageIntoFrame = 0.0f;
        if (!this.isDiscrete) {
            percentageIntoFrame = (this.progress - startKeytime) / (endKeytime - startKeytime);
            if (this.interpolators != null) {
                percentageIntoFrame = ((Interpolator)this.interpolators.get(keyframeIndex)).getInterpolation(percentageIntoFrame);
            }
        }
        ScaleXY startTransform = this.transforms.get(keyframeIndex);
        ScaleXY endTransform = this.transforms.get(keyframeIndex + 1);
        this.outTransform.scale(MiscUtils.lerp(startTransform.getScaleX(), endTransform.getScaleX(), percentageIntoFrame), MiscUtils.lerp(startTransform.getScaleY(), endTransform.getScaleY(), percentageIntoFrame));
        return this.outTransform;
    }
}

