/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.animatable;

import android.graphics.Path;
import android.graphics.PointF;
import android.support.annotation.RestrictTo;
import com.airbnb.lottie.animatable.BaseAnimatableValue;
import com.airbnb.lottie.animation.KeyframeAnimation;
import com.airbnb.lottie.animation.ShapeKeyframeAnimation;
import com.airbnb.lottie.animation.StaticKeyframeAnimation;
import com.airbnb.lottie.model.CubicCurveData;
import com.airbnb.lottie.model.LottieComposition;
import com.airbnb.lottie.model.ShapeData;
import com.airbnb.lottie.utils.MiscUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.GROUP_ID})
public class AnimatableShapeValue
extends BaseAnimatableValue<ShapeData, Path> {
    private final Path convertTypePath = new Path();
    private boolean closed;

    public AnimatableShapeValue(JSONObject json, int frameRate, LottieComposition composition, boolean closed) {
        super(null, frameRate, composition, true);
        this.closed = closed;
        this.init(json);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected ShapeData valueFromObject(Object object, float scale) throws JSONException {
        pointsData = null;
        if (object instanceof JSONArray) {
            try {
                firstObject = ((JSONArray)object).get(0);
                if (!(firstObject instanceof JSONObject) || !((JSONObject)firstObject).has("v")) ** GOTO lbl12
                pointsData = (JSONObject)firstObject;
            }
            catch (JSONException e) {
                throw new IllegalStateException("Unable to get shape. " + object);
            }
        } else if (object instanceof JSONObject && ((JSONObject)object).has("v")) {
            pointsData = (JSONObject)object;
        }
lbl12:
        // 5 sources

        if (pointsData == null) {
            return null;
        }
        pointsArray = null;
        inTangents = null;
        outTangents = null;
        try {
            pointsArray = pointsData.getJSONArray("v");
            inTangents = pointsData.getJSONArray("i");
            outTangents = pointsData.getJSONArray("o");
            if (pointsData.has("c")) {
                this.closed = pointsData.getBoolean("c");
            }
        }
        catch (JSONException var7_8) {
            // empty catch block
        }
        if (pointsArray == null || inTangents == null || outTangents == null || pointsArray.length() != inTangents.length() || pointsArray.length() != outTangents.length()) {
            throw new IllegalStateException("Unable to process points array or tangents. " + pointsData);
        }
        shape = new ShapeData();
        vertex = this.vertexAtIndex(0, pointsArray);
        vertex.x *= scale;
        vertex.y *= scale;
        shape.setInitialPoint(vertex);
        for (i = 1; i < pointsArray.length(); ++i) {
            vertex = this.vertexAtIndex(i, pointsArray);
            previousVertex = this.vertexAtIndex(i - 1, pointsArray);
            cp1 = this.vertexAtIndex(i - 1, outTangents);
            cp2 = this.vertexAtIndex(i, inTangents);
            shapeCp1 = MiscUtils.addPoints(previousVertex, cp1);
            shapeCp2 = MiscUtils.addPoints(vertex, cp2);
            shapeCp1.x *= scale;
            shapeCp1.y *= scale;
            shapeCp2.x *= scale;
            shapeCp2.y *= scale;
            vertex.x *= scale;
            vertex.y *= scale;
            shape.addCurve(new CubicCurveData(shapeCp1, shapeCp2, vertex));
        }
        if (this.closed) {
            vertex = this.vertexAtIndex(0, pointsArray);
            previousVertex = this.vertexAtIndex(pointsArray.length() - 1, pointsArray);
            cp1 = this.vertexAtIndex(pointsArray.length() - 1, outTangents);
            cp2 = this.vertexAtIndex(0, inTangents);
            shapeCp1 = MiscUtils.addPoints(previousVertex, cp1);
            shapeCp2 = MiscUtils.addPoints(vertex, cp2);
            if (scale != 1.0f) {
                shapeCp1.x *= scale;
                shapeCp1.y *= scale;
                shapeCp2.x *= scale;
                shapeCp2.y *= scale;
                vertex.x *= scale;
                vertex.y *= scale;
            }
            shape.addCurve(new CubicCurveData(shapeCp1, shapeCp2, vertex));
        }
        return shape;
    }

    private PointF vertexAtIndex(int idx, JSONArray points) {
        if (idx >= points.length()) {
            throw new IllegalArgumentException("Invalid index " + idx + ". There are only " + points.length() + " points.");
        }
        try {
            JSONArray pointArray = points.getJSONArray(idx);
            Object x = pointArray.get(0);
            Object y = pointArray.get(1);
            return new PointF(x instanceof Double ? new Float((Double)x).floatValue() : (float)((Integer)x).intValue(), y instanceof Double ? new Float((Double)y).floatValue() : (float)((Integer)y).intValue());
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Unable to get point.", e);
        }
    }

    @Override
    public KeyframeAnimation<Path> createAnimation() {
        if (!this.hasAnimation()) {
            return new StaticKeyframeAnimation<Path>(this.convertType((ShapeData)this.initialValue));
        }
        ShapeKeyframeAnimation animation = new ShapeKeyframeAnimation(this.duration, this.composition, this.keyTimes, this.keyValues, this.interpolators);
        animation.setStartDelay(this.delay);
        return animation;
    }

    @Override
    Path convertType(ShapeData shapeData) {
        this.convertTypePath.reset();
        MiscUtils.getPathFromData(shapeData, this.convertTypePath);
        return this.convertTypePath;
    }
}

