/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.animatable;

import android.graphics.PointF;
import android.support.annotation.RestrictTo;
import com.airbnb.lottie.animatable.BaseAnimatableValue;
import com.airbnb.lottie.animation.KeyframeAnimation;
import com.airbnb.lottie.animation.PointKeyframeAnimation;
import com.airbnb.lottie.animation.StaticKeyframeAnimation;
import com.airbnb.lottie.model.LottieComposition;
import com.airbnb.lottie.utils.JsonUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@RestrictTo(value={RestrictTo.Scope.GROUP_ID})
public class AnimatablePointValue
extends BaseAnimatableValue<PointF, PointF> {
    public AnimatablePointValue(JSONObject pointValues, int frameRate, LottieComposition composition) {
        super(pointValues, frameRate, composition, true);
    }

    @Override
    protected PointF valueFromObject(Object object, float scale) throws JSONException {
        if (object instanceof JSONArray) {
            return JsonUtils.pointFromJsonArray((JSONArray)object, scale);
        }
        if (object instanceof JSONObject) {
            return JsonUtils.pointValueFromJsonObject((JSONObject)object, scale);
        }
        throw new IllegalArgumentException("Unable to parse point from " + object);
    }

    @Override
    public KeyframeAnimation<PointF> createAnimation() {
        if (!this.hasAnimation()) {
            return new StaticKeyframeAnimation<Object>(this.initialValue);
        }
        PointKeyframeAnimation animation = new PointKeyframeAnimation(this.duration, this.composition, this.keyTimes, this.keyValues, this.interpolators);
        animation.setStartDelay(this.delay);
        return animation;
    }

    @Override
    public boolean hasAnimation() {
        return !this.keyValues.isEmpty();
    }
}

