/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy.preload;

import android.content.Context;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.airbnb.epoxy.BaseEpoxyAdapter;
import com.airbnb.epoxy.EpoxyAdapter;
import com.airbnb.epoxy.EpoxyController;
import com.airbnb.epoxy.EpoxyControllerAdapter;
import com.airbnb.epoxy.EpoxyModel;
import com.airbnb.epoxy.InternalExposerKt;
import com.airbnb.epoxy.preload.EpoxyModelPreloader;
import com.airbnb.epoxy.preload.PreloadRequestHolder;
import com.airbnb.epoxy.preload.PreloadTargetProvider;
import com.airbnb.epoxy.preload.PreloadableViewDataProvider;
import com.airbnb.epoxy.preload.ViewData;
import com.airbnb.epoxy.preload.ViewMetadata;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 9*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u00019Be\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012 \u0010\b\u001a\u001c\u0012\u0004\u0012\u00020\n\u0012\b\u0012\u00060\u000bj\u0002`\f\u0012\u0004\u0012\u00020\r0\tj\u0002`\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u001c\u0010\u0011\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0006\b\u0001\u0012\u00028\u00000\u00130\u0012\u00a2\u0006\u0002\u0010\u0014Be\b\u0016\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012 \u0010\b\u001a\u001c\u0012\u0004\u0012\u00020\n\u0012\b\u0012\u00060\u000bj\u0002`\f\u0012\u0004\u0012\u00020\r0\tj\u0002`\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u001c\u0010\u0011\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0006\b\u0001\u0012\u00028\u00000\u00130\u0012\u00a2\u0006\u0002\u0010\u0017Be\b\u0002\u0012\u0006\u0010\u0015\u001a\u00020\u0018\u0012\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012 \u0010\b\u001a\u001c\u0012\u0004\u0012\u00020\n\u0012\b\u0012\u00060\u000bj\u0002`\f\u0012\u0004\u0012\u00020\r0\tj\u0002`\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u001c\u0010\u0011\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0006\b\u0001\u0012\u00028\u00000\u00130\u0012\u00a2\u0006\u0002\u0010\u001aJ \u0010'\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020\u00102\u0006\u0010)\u001a\u00020\u00102\u0006\u0010*\u001a\u00020+H\u0002J\u0006\u0010,\u001a\u00020\rJ\u0018\u0010-\u001a\u00020\r2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u0010H\u0016J \u00101\u001a\u00020\r2\u0006\u0010.\u001a\u00020/2\u0006\u00102\u001a\u00020\u00102\u0006\u00103\u001a\u00020\u0010H\u0016J\u0010\u00104\u001a\u00020\r2\u0006\u00105\u001a\u00020\u0010H\u0002J\f\u00106\u001a\u00020\u0010*\u00020\u0010H\u0002J\f\u00107\u001a\u00020+*\u00020\u0010H\u0002J\f\u00108\u001a\u00020+*\u00020\u0010H\u0002R\u000e\u0010\u0015\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\u0011\u001a*\u0012\u0010\u0012\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030!0 \u0012\u0014\u0012\u0012\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0006\b\u0001\u0012\u00028\u00000\u00130\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/airbnb/epoxy/preload/EpoxyPreloader;", "P", "Lcom/airbnb/epoxy/preload/PreloadRequestHolder;", "Landroidx/recyclerview/widget/RecyclerView$OnScrollListener;", "epoxyController", "Lcom/airbnb/epoxy/EpoxyController;", "requestHolderFactory", "Lkotlin/Function0;", "errorHandler", "Lkotlin/Function2;", "Landroid/content/Context;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "", "Lcom/airbnb/epoxy/preload/PreloadErrorHandler;", "maxItemsToPreload", "", "modelPreloaders", "", "Lcom/airbnb/epoxy/preload/EpoxyModelPreloader;", "(Lcom/airbnb/epoxy/EpoxyController;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function2;ILjava/util/List;)V", "adapter", "Lcom/airbnb/epoxy/EpoxyAdapter;", "(Lcom/airbnb/epoxy/EpoxyAdapter;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function2;ILjava/util/List;)V", "Lcom/airbnb/epoxy/BaseEpoxyAdapter;", "preloadTargetFactory", "(Lcom/airbnb/epoxy/BaseEpoxyAdapter;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function2;ILjava/util/List;)V", "lastPreloadRange", "Lkotlin/ranges/IntProgression;", "lastVisibleRange", "Lkotlin/ranges/IntRange;", "", "Ljava/lang/Class;", "Lcom/airbnb/epoxy/EpoxyModel;", "Lcom/airbnb/epoxy/preload/PreloadTargetProvider;", "scrollState", "totalItemCount", "viewDataCache", "Lcom/airbnb/epoxy/preload/PreloadableViewDataProvider;", "calculatePreloadRange", "firstVisiblePosition", "lastVisiblePosition", "isIncreasing", "", "cancelPreloadRequests", "onScrollStateChanged", "recyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "newState", "onScrolled", "dx", "dy", "preloadAdapterPosition", "position", "clampToAdapterRange", "isFling", "isInvalid", "Companion", "epoxy-adapter_release"})
public final class EpoxyPreloader<P extends PreloadRequestHolder>
extends RecyclerView.OnScrollListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BaseEpoxyAdapter adapter;
    private final int maxItemsToPreload;
    @NotNull
    private IntRange lastVisibleRange;
    @NotNull
    private IntProgression lastPreloadRange;
    private int totalItemCount;
    private int scrollState;
    @NotNull
    private final Map<Class<? extends EpoxyModel<?>>, EpoxyModelPreloader<?, ?, ? extends P>> modelPreloaders;
    @NotNull
    private final PreloadTargetProvider<P> requestHolderFactory;
    @NotNull
    private final PreloadableViewDataProvider viewDataCache;
    private static final int FLING_THRESHOLD_PX = 75;

    /*
     * WARNING - void declaration
     */
    private EpoxyPreloader(BaseEpoxyAdapter adapter, Function0<? extends P> preloadTargetFactory, Function2<? super Context, ? super RuntimeException, Unit> errorHandler, int maxItemsToPreload, List<? extends EpoxyModelPreloader<?, ?, ? extends P>> modelPreloaders) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        this.adapter = adapter;
        this.maxItemsToPreload = maxItemsToPreload;
        this.lastVisibleRange = IntRange.Companion.getEMPTY();
        this.lastPreloadRange = (IntProgression)IntRange.Companion.getEMPTY();
        this.totalItemCount = -1;
        Iterable iterable = modelPreloaders;
        EpoxyPreloader epoxyPreloader = this;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var9_11 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            EpoxyModelPreloader epoxyModelPreloader = (EpoxyModelPreloader)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getModelType(), element$iv$iv);
        }
        epoxyPreloader.modelPreloaders = destination$iv$iv;
        this.requestHolderFactory = new PreloadTargetProvider<P>(this.maxItemsToPreload, preloadTargetFactory);
        this.viewDataCache = new PreloadableViewDataProvider(this.adapter, errorHandler);
        if (!(this.maxItemsToPreload > 0)) {
            boolean bl = false;
            String string = "maxItemsToPreload must be greater than 0. Was " + this.maxItemsToPreload;
            throw new IllegalArgumentException(string.toString());
        }
    }

    public EpoxyPreloader(@NotNull EpoxyController epoxyController, @NotNull Function0<? extends P> requestHolderFactory, @NotNull Function2<? super Context, ? super RuntimeException, Unit> errorHandler, int maxItemsToPreload, @NotNull List<? extends EpoxyModelPreloader<?, ?, ? extends P>> modelPreloaders) {
        Intrinsics.checkNotNullParameter((Object)epoxyController, (String)"epoxyController");
        Intrinsics.checkNotNullParameter(requestHolderFactory, (String)"requestHolderFactory");
        Intrinsics.checkNotNullParameter(errorHandler, (String)"errorHandler");
        Intrinsics.checkNotNullParameter(modelPreloaders, (String)"modelPreloaders");
        EpoxyControllerAdapter epoxyControllerAdapter = epoxyController.getAdapter();
        Intrinsics.checkNotNullExpressionValue((Object)epoxyControllerAdapter, (String)"epoxyController.adapter");
        this(epoxyControllerAdapter, requestHolderFactory, errorHandler, maxItemsToPreload, modelPreloaders);
    }

    public EpoxyPreloader(@NotNull EpoxyAdapter adapter, @NotNull Function0<? extends P> requestHolderFactory, @NotNull Function2<? super Context, ? super RuntimeException, Unit> errorHandler, int maxItemsToPreload, @NotNull List<? extends EpoxyModelPreloader<?, ?, ? extends P>> modelPreloaders) {
        Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
        Intrinsics.checkNotNullParameter(requestHolderFactory, (String)"requestHolderFactory");
        Intrinsics.checkNotNullParameter(errorHandler, (String)"errorHandler");
        Intrinsics.checkNotNullParameter(modelPreloaders, (String)"modelPreloaders");
        this((BaseEpoxyAdapter)adapter, requestHolderFactory, errorHandler, maxItemsToPreload, modelPreloaders);
    }

    public void onScrollStateChanged(@NotNull RecyclerView recyclerView, int newState) {
        Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
        this.scrollState = newState;
    }

    /*
     * WARNING - void declaration
     */
    public void onScrolled(@NotNull RecyclerView recyclerView, int dx, int dy) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
        if (dx == 0 && dy == 0) {
            return;
        }
        if (this.isFling(dx) || this.isFling(dy)) {
            return;
        }
        RecyclerView.Adapter adapter = recyclerView.getAdapter();
        this.totalItemCount = adapter != null ? adapter.getItemCount() : 0;
        RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
        Intrinsics.checkNotNull((Object)layoutManager, (String)"null cannot be cast to non-null type androidx.recyclerview.widget.LinearLayoutManager");
        LinearLayoutManager layoutManager2 = (LinearLayoutManager)layoutManager;
        int firstVisiblePosition = layoutManager2.findFirstVisibleItemPosition();
        int lastVisiblePosition = layoutManager2.findLastVisibleItemPosition();
        if (this.isInvalid(firstVisiblePosition) || this.isInvalid(lastVisiblePosition)) {
            this.lastVisibleRange = IntRange.Companion.getEMPTY();
            this.lastPreloadRange = (IntProgression)IntRange.Companion.getEMPTY();
            return;
        }
        IntRange visibleRange = new IntRange(firstVisiblePosition, lastVisiblePosition);
        if (Intrinsics.areEqual((Object)visibleRange, (Object)this.lastVisibleRange)) {
            return;
        }
        boolean isIncreasing = visibleRange.getFirst() > this.lastVisibleRange.getFirst() || visibleRange.getLast() > this.lastVisibleRange.getLast();
        IntProgression preloadRange = this.calculatePreloadRange(firstVisiblePosition, lastVisiblePosition, isIncreasing);
        Iterable iterable = CollectionsKt.subtract((Iterable)((Iterable)preloadRange), (Iterable)((Iterable)this.lastPreloadRange));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int it = ((Number)element$iv).intValue();
            boolean bl = false;
            this.preloadAdapterPosition(it);
        }
        this.lastVisibleRange = visibleRange;
        this.lastPreloadRange = preloadRange;
    }

    private final boolean isFling(int $this$isFling) {
        return Math.abs($this$isFling) > 75;
    }

    private final IntProgression calculatePreloadRange(int firstVisiblePosition, int lastVisiblePosition, boolean isIncreasing) {
        int from = isIncreasing ? lastVisiblePosition + 1 : firstVisiblePosition - 1;
        int to = from + (isIncreasing ? this.maxItemsToPreload - 1 : 1 - this.maxItemsToPreload);
        return IntProgression.Companion.fromClosedRange(this.clampToAdapterRange(from), this.clampToAdapterRange(to), isIncreasing ? 1 : -1);
    }

    private final boolean isInvalid(int $this$isInvalid) {
        return $this$isInvalid == -1 || $this$isInvalid >= this.totalItemCount;
    }

    private final int clampToAdapterRange(int $this$clampToAdapterRange) {
        return Math.min(this.totalItemCount - 1, Math.max($this$clampToAdapterRange, 0));
    }

    /*
     * WARNING - void declaration
     */
    private final void preloadAdapterPosition(int position) {
        void $this$forEach$iv;
        EpoxyModel<?> epoxyModel = InternalExposerKt.getModelForPositionInternal(this.adapter, position);
        Object object = epoxyModel instanceof EpoxyModel ? epoxyModel : null;
        if (object == null) {
            return;
        }
        Object epoxyModel2 = object;
        EpoxyModelPreloader<?, ?, P> epoxyModelPreloader = this.modelPreloaders.get(epoxyModel2.getClass());
        EpoxyModelPreloader<?, ?, P> epoxyModelPreloader2 = epoxyModelPreloader instanceof EpoxyModelPreloader ? epoxyModelPreloader : null;
        if (epoxyModelPreloader2 == null) {
            return;
        }
        EpoxyModelPreloader<?, ?, P> preloader = epoxyModelPreloader2;
        epoxyModel = this.viewDataCache.dataForModel(preloader, epoxyModel2, position);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ViewData viewData = (ViewData)element$iv;
            boolean bl = false;
            P preloadTarget = this.requestHolderFactory.next$epoxy_adapter_release();
            preloader.startPreload(epoxyModel2, preloadTarget, viewData);
        }
    }

    public final void cancelPreloadRequests() {
        this.requestHolderFactory.clearAll();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0082\u0001\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0006\"\b\b\u0001\u0010\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00070\f2 \u0010\r\u001a\u001c\u0012\u0004\u0012\u00020\u000f\u0012\b\u0012\u00060\u0010j\u0002`\u0011\u0012\u0004\u0012\u00020\u00120\u000ej\u0002`\u00132\u0006\u0010\u0014\u001a\u00020\u00042*\u0010\u0015\u001a&\u0012\"\u0012 \u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u0018\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0019\u0012\u0006\b\u0001\u0012\u0002H\u00070\u00170\u0016J|\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0006\"\b\b\u0001\u0010\u0007*\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00070\f2 \u0010\r\u001a\u001c\u0012\u0004\u0012\u00020\u000f\u0012\b\u0012\u00060\u0010j\u0002`\u0011\u0012\u0004\u0012\u00020\u00120\u000ej\u0002`\u00132\u0006\u0010\u0014\u001a\u00020\u00042$\u0010\u001c\u001a \u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u0018\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0019\u0012\u0006\b\u0001\u0012\u0002H\u00070\u0017J\u0082\u0001\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0006\"\b\b\u0001\u0010\u0007*\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00070\f2 \u0010\r\u001a\u001c\u0012\u0004\u0012\u00020\u000f\u0012\b\u0012\u00060\u0010j\u0002`\u0011\u0012\u0004\u0012\u00020\u00120\u000ej\u0002`\u00132\u0006\u0010\u0014\u001a\u00020\u00042*\u0010\u0015\u001a&\u0012\"\u0012 \u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u0018\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0019\u0012\u0006\b\u0001\u0012\u0002H\u00070\u00170\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/airbnb/epoxy/preload/EpoxyPreloader$Companion;", "", "()V", "FLING_THRESHOLD_PX", "", "with", "Lcom/airbnb/epoxy/preload/EpoxyPreloader;", "P", "Lcom/airbnb/epoxy/preload/PreloadRequestHolder;", "epoxyAdapter", "Lcom/airbnb/epoxy/EpoxyAdapter;", "requestHolderFactory", "Lkotlin/Function0;", "errorHandler", "Lkotlin/Function2;", "Landroid/content/Context;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "", "Lcom/airbnb/epoxy/preload/PreloadErrorHandler;", "maxItemsToPreload", "modelPreloaders", "", "Lcom/airbnb/epoxy/preload/EpoxyModelPreloader;", "Lcom/airbnb/epoxy/EpoxyModel;", "Lcom/airbnb/epoxy/preload/ViewMetadata;", "epoxyController", "Lcom/airbnb/epoxy/EpoxyController;", "modelPreloader", "epoxy-adapter_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <P extends PreloadRequestHolder> EpoxyPreloader<P> with(@NotNull EpoxyController epoxyController, @NotNull Function0<? extends P> requestHolderFactory, @NotNull Function2<? super Context, ? super RuntimeException, Unit> errorHandler, int maxItemsToPreload, @NotNull EpoxyModelPreloader<? extends EpoxyModel<?>, ? extends ViewMetadata, ? extends P> modelPreloader) {
            Intrinsics.checkNotNullParameter((Object)epoxyController, (String)"epoxyController");
            Intrinsics.checkNotNullParameter(requestHolderFactory, (String)"requestHolderFactory");
            Intrinsics.checkNotNullParameter(errorHandler, (String)"errorHandler");
            Intrinsics.checkNotNullParameter(modelPreloader, (String)"modelPreloader");
            return this.with(epoxyController, requestHolderFactory, errorHandler, maxItemsToPreload, CollectionsKt.listOf(modelPreloader));
        }

        @NotNull
        public final <P extends PreloadRequestHolder> EpoxyPreloader<P> with(@NotNull EpoxyController epoxyController, @NotNull Function0<? extends P> requestHolderFactory, @NotNull Function2<? super Context, ? super RuntimeException, Unit> errorHandler, int maxItemsToPreload, @NotNull List<? extends EpoxyModelPreloader<? extends EpoxyModel<?>, ? extends ViewMetadata, ? extends P>> modelPreloaders) {
            Intrinsics.checkNotNullParameter((Object)epoxyController, (String)"epoxyController");
            Intrinsics.checkNotNullParameter(requestHolderFactory, (String)"requestHolderFactory");
            Intrinsics.checkNotNullParameter(errorHandler, (String)"errorHandler");
            Intrinsics.checkNotNullParameter(modelPreloaders, (String)"modelPreloaders");
            return new EpoxyPreloader<P>(epoxyController, requestHolderFactory, errorHandler, maxItemsToPreload, modelPreloaders);
        }

        @NotNull
        public final <P extends PreloadRequestHolder> EpoxyPreloader<P> with(@NotNull EpoxyAdapter epoxyAdapter, @NotNull Function0<? extends P> requestHolderFactory, @NotNull Function2<? super Context, ? super RuntimeException, Unit> errorHandler, int maxItemsToPreload, @NotNull List<? extends EpoxyModelPreloader<? extends EpoxyModel<?>, ? extends ViewMetadata, ? extends P>> modelPreloaders) {
            Intrinsics.checkNotNullParameter((Object)epoxyAdapter, (String)"epoxyAdapter");
            Intrinsics.checkNotNullParameter(requestHolderFactory, (String)"requestHolderFactory");
            Intrinsics.checkNotNullParameter(errorHandler, (String)"errorHandler");
            Intrinsics.checkNotNullParameter(modelPreloaders, (String)"modelPreloaders");
            return new EpoxyPreloader<P>(epoxyAdapter, requestHolderFactory, errorHandler, maxItemsToPreload, modelPreloaders);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

