/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewStub;
import androidx.annotation.VisibleForTesting;
import androidx.recyclerview.widget.RecyclerView;
import com.airbnb.epoxy.EpoxyHolder;
import com.airbnb.epoxy.EpoxyModel;
import com.airbnb.epoxy.EpoxyModelGroup;
import com.airbnb.epoxy.EpoxyViewHolder;
import com.airbnb.epoxy.HelperAdapter;
import com.airbnb.epoxy.LocalGroupRecycledViewPool;
import com.airbnb.epoxy.ViewStubData;
import com.airbnb.epoxy.ViewTypeManager;
import com.airbnb.viewmodeladapter.R;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 32\u00020\u0001:\u00013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u001b\u001a\u00020\u001c2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001e2\f\u0010\u001f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001eH\u0002J\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0006J\u0010\u0010#\u001a\u00020!2\u0006\u0010$\u001a\u00020%H\u0014J\u001e\u0010&\u001a\u00020!2\u0006\u0010'\u001a\u00020\b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0011H\u0002J\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010'\u001a\u00020\bH\u0002J\u0010\u0010)\u001a\u00020\b2\u0006\u0010*\u001a\u00020\bH\u0002J\u001c\u0010+\u001a\u00020\u00122\u0006\u0010,\u001a\u00020\b2\n\u0010-\u001a\u0006\u0012\u0002\b\u00030\u001eH\u0002J\u0010\u0010.\u001a\u00020!2\u0006\u0010/\u001a\u000200H\u0002J\u0006\u00101\u001a\u00020!J\b\u00102\u001a\u00020\u001cH\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u00020\u00168\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001a\u00a8\u00064"}, d2={"Lcom/airbnb/epoxy/ModelGroupHolder;", "Lcom/airbnb/epoxy/EpoxyHolder;", "modelGroupParent", "Landroid/view/ViewParent;", "(Landroid/view/ViewParent;)V", "boundGroup", "Lcom/airbnb/epoxy/EpoxyModelGroup;", "childContainer", "Landroid/view/ViewGroup;", "<set-?>", "rootView", "getRootView", "()Landroid/view/ViewGroup;", "stubs", "", "Lcom/airbnb/epoxy/ViewStubData;", "viewHolders", "Ljava/util/ArrayList;", "Lcom/airbnb/epoxy/EpoxyViewHolder;", "getViewHolders", "()Ljava/util/ArrayList;", "viewPool", "Landroidx/recyclerview/widget/RecyclerView$RecycledViewPool;", "getViewPool$annotations", "()V", "getViewPool", "()Landroidx/recyclerview/widget/RecyclerView$RecycledViewPool;", "areSameViewType", "", "model1", "Lcom/airbnb/epoxy/EpoxyModel;", "model2", "bindGroupIfNeeded", "", "group", "bindView", "itemView", "Landroid/view/View;", "collectViewStubs", "viewGroup", "createViewStubData", "findChildContainer", "outermostRoot", "getViewHolder", "parent", "model", "removeAndRecycleView", "modelPosition", "", "unbindGroup", "usingStubs", "Companion", "epoxy-adapter_release"})
public final class ModelGroupHolder
extends EpoxyHolder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ViewParent modelGroupParent;
    @NotNull
    private final ArrayList<EpoxyViewHolder> viewHolders;
    @NotNull
    private final RecyclerView.RecycledViewPool viewPool;
    private ViewGroup rootView;
    private ViewGroup childContainer;
    private List<ViewStubData> stubs;
    @Nullable
    private EpoxyModelGroup boundGroup;
    @NotNull
    private static final HelperAdapter HELPER_ADAPTER = new HelperAdapter();

    public ModelGroupHolder(@NotNull ViewParent modelGroupParent) {
        Intrinsics.checkNotNullParameter((Object)modelGroupParent, (String)"modelGroupParent");
        this.modelGroupParent = modelGroupParent;
        this.viewHolders = new ArrayList(4);
        this.viewPool = ModelGroupHolder.Companion.findViewPool(this.modelGroupParent);
    }

    @NotNull
    public final ArrayList<EpoxyViewHolder> getViewHolders() {
        return this.viewHolders;
    }

    @NotNull
    public final RecyclerView.RecycledViewPool getViewPool() {
        return this.viewPool;
    }

    @VisibleForTesting
    public static /* synthetic */ void getViewPool$annotations() {
    }

    @NotNull
    public final ViewGroup getRootView() {
        ViewGroup viewGroup = this.rootView;
        if (viewGroup != null) {
            return viewGroup;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"rootView");
        return null;
    }

    private final boolean usingStubs() {
        List<ViewStubData> list = this.stubs;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"stubs");
            list = null;
        }
        return !((Collection)list).isEmpty();
    }

    @Override
    protected void bindView(@NotNull View itemView) {
        List<ViewStubData> list;
        Intrinsics.checkNotNullParameter((Object)itemView, (String)"itemView");
        if (!(itemView instanceof ViewGroup)) {
            throw new IllegalStateException("The layout provided to EpoxyModelGroup must be a ViewGroup");
        }
        this.rootView = (ViewGroup)itemView;
        this.childContainer = this.findChildContainer(this.getRootView());
        ViewGroup viewGroup = this.childContainer;
        if (viewGroup == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"childContainer");
            viewGroup = null;
        }
        if (viewGroup.getChildCount() != 0) {
            ViewGroup viewGroup2 = this.childContainer;
            if (viewGroup2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"childContainer");
                viewGroup2 = null;
            }
            list = this.createViewStubData(viewGroup2);
        } else {
            list = CollectionsKt.emptyList();
        }
        this.stubs = list;
    }

    private final ViewGroup findChildContainer(ViewGroup outermostRoot) {
        View customRoot = outermostRoot.findViewById(R.id.epoxy_model_group_child_container);
        ViewGroup viewGroup = customRoot instanceof ViewGroup ? (ViewGroup)customRoot : null;
        if (viewGroup == null) {
            viewGroup = outermostRoot;
        }
        return viewGroup;
    }

    private final List<ViewStubData> createViewStubData(ViewGroup viewGroup) {
        ArrayList<ViewStubData> arrayList;
        ArrayList<ViewStubData> $this$createViewStubData_u24lambda_u240 = arrayList = new ArrayList<ViewStubData>(4);
        boolean bl = false;
        this.collectViewStubs(viewGroup, $this$createViewStubData_u24lambda_u240);
        if ($this$createViewStubData_u24lambda_u240.isEmpty()) {
            throw new IllegalStateException("No view stubs found. If viewgroup is not empty it must contain ViewStubs.");
        }
        return arrayList;
    }

    private final void collectViewStubs(ViewGroup viewGroup, ArrayList<ViewStubData> stubs) {
        int n = viewGroup.getChildCount();
        for (int i = 0; i < n; ++i) {
            View child = viewGroup.getChildAt(i);
            if (child instanceof ViewGroup) {
                this.collectViewStubs((ViewGroup)child, stubs);
                continue;
            }
            if (!(child instanceof ViewStub)) continue;
            stubs.add(new ViewStubData(viewGroup, (ViewStub)child, i));
        }
    }

    public final void bindGroupIfNeeded(@NotNull EpoxyModelGroup group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        EpoxyModelGroup previouslyBoundGroup = this.boundGroup;
        if (previouslyBoundGroup == group) {
            return;
        }
        if (previouslyBoundGroup != null && previouslyBoundGroup.models.size() > group.models.size()) {
            int i = previouslyBoundGroup.models.size() - 1;
            int n = group.models.size();
            if (n <= i) {
                while (true) {
                    this.removeAndRecycleView(i);
                    if (i == n) break;
                    --i;
                }
            }
        }
        this.boundGroup = group;
        List<EpoxyModel<?>> models = group.models;
        int modelCount = models.size();
        if (this.usingStubs()) {
            List<ViewStubData> list = this.stubs;
            if (list == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"stubs");
                list = null;
            }
            if (list.size() < modelCount) {
                StringBuilder stringBuilder = new StringBuilder().append("Insufficient view stubs for EpoxyModelGroup. ").append(modelCount).append(" models were provided but only ");
                List<ViewStubData> list2 = this.stubs;
                if (list2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"stubs");
                    list2 = null;
                }
                throw new IllegalStateException(stringBuilder.append(list2.size()).append(" view stubs exist.").toString());
            }
        }
        this.viewHolders.ensureCapacity(modelCount);
        for (int i = 0; i < modelCount; ++i) {
            ViewStubData parent;
            ViewStubData stubData;
            ViewStubData viewStubData;
            EpoxyModel previouslyBoundModel;
            EpoxyModel<?> model = models.get(i);
            Object object = previouslyBoundGroup;
            EpoxyModel epoxyModel = previouslyBoundModel = object != null && (object = ((EpoxyModelGroup)object).models) != null ? (EpoxyModel)CollectionsKt.getOrNull((List)object, (int)i) : null;
            List<ViewStubData> list = this.stubs;
            if (list == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"stubs");
                list = null;
            }
            if (((viewStubData = (stubData = (ViewStubData)CollectionsKt.getOrNull(list, (int)i))) == null || (viewStubData = viewStubData.getViewGroup()) == null) && (viewStubData = this.childContainer) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"childContainer");
                viewStubData = parent = null;
            }
            if (previouslyBoundModel != null) {
                if (this.areSameViewType(previouslyBoundModel, model)) continue;
                this.removeAndRecycleView(i);
            }
            Intrinsics.checkNotNullExpressionValue(model, (String)"model");
            EpoxyViewHolder holder = this.getViewHolder((ViewGroup)parent, model);
            if (stubData == null) {
                ViewGroup viewGroup = this.childContainer;
                if (viewGroup == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"childContainer");
                    viewGroup = null;
                }
                viewGroup.addView(holder.itemView, i);
            } else {
                View view = holder.itemView;
                Intrinsics.checkNotNullExpressionValue((Object)view, (String)"holder.itemView");
                stubData.setView(view, group.useViewStubLayoutParams(model, i));
            }
            this.viewHolders.add(i, holder);
        }
    }

    private final boolean areSameViewType(EpoxyModel<?> model1, EpoxyModel<?> model2) {
        return ViewTypeManager.getViewType(model1) == ViewTypeManager.getViewType(model2);
    }

    private final EpoxyViewHolder getViewHolder(ViewGroup parent, EpoxyModel<?> model) {
        int viewType = ViewTypeManager.getViewType(model);
        RecyclerView.ViewHolder recycledView = this.viewPool.getRecycledView(viewType);
        EpoxyViewHolder epoxyViewHolder = recycledView instanceof EpoxyViewHolder ? (EpoxyViewHolder)recycledView : null;
        if (epoxyViewHolder == null) {
            epoxyViewHolder = HELPER_ADAPTER.createViewHolder(this.modelGroupParent, model, parent, viewType);
        }
        return epoxyViewHolder;
    }

    public final void unbindGroup() {
        if (this.boundGroup == null) {
            throw new IllegalStateException("Group is not bound");
        }
        int n = this.viewHolders.size();
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            this.removeAndRecycleView(this.viewHolders.size() - 1);
        }
        this.boundGroup = null;
    }

    private final void removeAndRecycleView(int modelPosition) {
        if (this.usingStubs()) {
            List<ViewStubData> list = this.stubs;
            if (list == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"stubs");
                list = null;
            }
            list.get(modelPosition).resetStub();
        } else {
            ViewGroup viewGroup = this.childContainer;
            if (viewGroup == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"childContainer");
                viewGroup = null;
            }
            viewGroup.removeViewAt(modelPosition);
        }
        EpoxyViewHolder epoxyViewHolder = this.viewHolders.remove(modelPosition);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)epoxyViewHolder), (String)"viewHolders.removeAt(modelPosition)");
        EpoxyViewHolder viewHolder = epoxyViewHolder;
        viewHolder.unbind();
        this.viewPool.putRecycledView((RecyclerView.ViewHolder)viewHolder);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/airbnb/epoxy/ModelGroupHolder$Companion;", "", "()V", "HELPER_ADAPTER", "Lcom/airbnb/epoxy/HelperAdapter;", "findViewPool", "Landroidx/recyclerview/widget/RecyclerView$RecycledViewPool;", "view", "Landroid/view/ViewParent;", "epoxy-adapter_release"})
    public static final class Companion {
        private Companion() {
        }

        private final RecyclerView.RecycledViewPool findViewPool(ViewParent view) {
            RecyclerView.RecycledViewPool viewPool = null;
            while (viewPool == null) {
                ViewParent parent;
                viewPool = view instanceof RecyclerView ? ((RecyclerView)view).getRecycledViewPool() : ((parent = view.getParent()) != null ? this.findViewPool(parent) : (RecyclerView.RecycledViewPool)new LocalGroupRecycledViewPool());
            }
            return viewPool;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

