package com.airbnb.epoxy;

import androidx.annotation.LayoutRes;
import androidx.annotation.Nullable;
import java.lang.CharSequence;
import java.lang.Number;

@EpoxyBuildScope
public interface GroupModelBuilder extends ModelCollector {
  GroupModelBuilder onBind(OnModelBoundListener<GroupModel_, ModelGroupHolder> listener);

  GroupModelBuilder onUnbind(OnModelUnboundListener<GroupModel_, ModelGroupHolder> listener);

  GroupModelBuilder onVisibilityStateChanged(
      OnModelVisibilityStateChangedListener<GroupModel_, ModelGroupHolder> listener);

  GroupModelBuilder onVisibilityChanged(
      OnModelVisibilityChangedListener<GroupModel_, ModelGroupHolder> listener);

  GroupModelBuilder shouldSaveViewState(boolean shouldSaveViewState);

  GroupModelBuilder id(long id);

  GroupModelBuilder id(@Nullable Number... ids);

  GroupModelBuilder id(long id1, long id2);

  GroupModelBuilder id(@Nullable CharSequence key);

  GroupModelBuilder id(@Nullable CharSequence key, @Nullable CharSequence... otherKeys);

  GroupModelBuilder id(@Nullable CharSequence key, long id);

  GroupModelBuilder layout(@LayoutRes int layoutRes);

  GroupModelBuilder spanSizeOverride(
      @Nullable EpoxyModel.SpanSizeOverrideCallback spanSizeCallback);
}
