/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import android.graphics.Rect;
import android.view.View;
import androidx.annotation.Px;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

public class EpoxyItemSpacingDecorator
extends RecyclerView.ItemDecoration {
    private int pxBetweenItems;
    private boolean verticallyScrolling;
    private boolean horizontallyScrolling;
    private boolean firstItem;
    private boolean lastItem;
    private boolean grid;
    private boolean isFirstItemInRow;
    private boolean fillsLastSpan;
    private boolean isInFirstRow;
    private boolean isInLastRow;

    public EpoxyItemSpacingDecorator() {
        this(0);
    }

    public EpoxyItemSpacingDecorator(@Px int pxBetweenItems) {
        this.setPxBetweenItems(pxBetweenItems);
    }

    public void setPxBetweenItems(@Px int pxBetweenItems) {
        this.pxBetweenItems = pxBetweenItems;
    }

    @Px
    public int getPxBetweenItems() {
        return this.pxBetweenItems;
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        outRect.setEmpty();
        int position = parent.getChildAdapterPosition(view);
        if (position == -1) {
            return;
        }
        RecyclerView.LayoutManager layout2 = parent.getLayoutManager();
        this.calculatePositionDetails(parent, position, layout2);
        boolean left = this.useLeftPadding();
        boolean right = this.useRightPadding();
        boolean top = this.useTopPadding();
        boolean bottom = this.useBottomPadding();
        if (EpoxyItemSpacingDecorator.shouldReverseLayout(layout2, this.horizontallyScrolling)) {
            boolean temp;
            if (this.horizontallyScrolling) {
                temp = left;
                left = right;
                right = temp;
            } else {
                temp = top;
                top = bottom;
                bottom = temp;
            }
        }
        int padding = this.pxBetweenItems / 2;
        outRect.right = right ? padding : 0;
        outRect.left = left ? padding : 0;
        outRect.top = top ? padding : 0;
        outRect.bottom = bottom ? padding : 0;
    }

    private void calculatePositionDetails(RecyclerView parent, int position, RecyclerView.LayoutManager layout2) {
        int itemCount = parent.getAdapter().getItemCount();
        this.firstItem = position == 0;
        this.lastItem = position == itemCount - 1;
        this.horizontallyScrolling = layout2.canScrollHorizontally();
        this.verticallyScrolling = layout2.canScrollVertically();
        this.grid = layout2 instanceof GridLayoutManager;
        if (this.grid) {
            GridLayoutManager grid = (GridLayoutManager)layout2;
            GridLayoutManager.SpanSizeLookup spanSizeLookup = grid.getSpanSizeLookup();
            int spanSize = spanSizeLookup.getSpanSize(position);
            int spanCount = grid.getSpanCount();
            int spanIndex = spanSizeLookup.getSpanIndex(position, spanCount);
            this.isFirstItemInRow = spanIndex == 0;
            this.fillsLastSpan = spanIndex + spanSize == spanCount;
            this.isInFirstRow = EpoxyItemSpacingDecorator.isInFirstRow(position, spanSizeLookup, spanCount);
            this.isInLastRow = !this.isInFirstRow && EpoxyItemSpacingDecorator.isInLastRow(position, itemCount, spanSizeLookup, spanCount);
        }
    }

    private static boolean shouldReverseLayout(RecyclerView.LayoutManager layout2, boolean horizontallyScrolling) {
        boolean rtl;
        boolean reverseLayout = layout2 instanceof LinearLayoutManager && ((LinearLayoutManager)layout2).getReverseLayout();
        boolean bl = rtl = layout2.getLayoutDirection() == 1;
        if (horizontallyScrolling && rtl) {
            reverseLayout = !reverseLayout;
        }
        return reverseLayout;
    }

    private boolean useBottomPadding() {
        if (this.grid) {
            return this.horizontallyScrolling && !this.fillsLastSpan || this.verticallyScrolling && !this.isInLastRow;
        }
        return this.verticallyScrolling && !this.lastItem;
    }

    private boolean useTopPadding() {
        if (this.grid) {
            return this.horizontallyScrolling && !this.isFirstItemInRow || this.verticallyScrolling && !this.isInFirstRow;
        }
        return this.verticallyScrolling && !this.firstItem;
    }

    private boolean useRightPadding() {
        if (this.grid) {
            return this.horizontallyScrolling && !this.isInLastRow || this.verticallyScrolling && !this.fillsLastSpan;
        }
        return this.horizontallyScrolling && !this.lastItem;
    }

    private boolean useLeftPadding() {
        if (this.grid) {
            return this.horizontallyScrolling && !this.isInFirstRow || this.verticallyScrolling && !this.isFirstItemInRow;
        }
        return this.horizontallyScrolling && !this.firstItem;
    }

    private static boolean isInFirstRow(int position, GridLayoutManager.SpanSizeLookup spanSizeLookup, int spanCount) {
        int totalSpan = 0;
        for (int i = 0; i <= position; ++i) {
            if ((totalSpan += spanSizeLookup.getSpanSize(i)) <= spanCount) continue;
            return false;
        }
        return true;
    }

    private static boolean isInLastRow(int position, int itemCount, GridLayoutManager.SpanSizeLookup spanSizeLookup, int spanCount) {
        int totalSpan = 0;
        for (int i = itemCount - 1; i >= position; --i) {
            if ((totalSpan += spanSizeLookup.getSpanSize(i)) <= spanCount) continue;
            return false;
        }
        return true;
    }
}

