/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import androidx.annotation.MainThread;

public final class EpoxyAsyncUtil {
    public static final Handler MAIN_THREAD_HANDLER = EpoxyAsyncUtil.createHandler(Looper.getMainLooper(), false);
    public static final Handler AYSNC_MAIN_THREAD_HANDLER = EpoxyAsyncUtil.createHandler(Looper.getMainLooper(), true);
    private static Handler asyncBackgroundHandler;

    private EpoxyAsyncUtil() {
    }

    @MainThread
    public static Handler getAsyncBackgroundHandler() {
        if (asyncBackgroundHandler == null) {
            asyncBackgroundHandler = EpoxyAsyncUtil.createHandler(EpoxyAsyncUtil.buildBackgroundLooper("epoxy"), true);
        }
        return asyncBackgroundHandler;
    }

    public static Handler createHandler(Looper looper, boolean async) {
        if (!async) {
            return new Handler(looper);
        }
        if (Build.VERSION.SDK_INT >= 28) {
            return Handler.createAsync((Looper)looper);
        }
        if (Build.VERSION.SDK_INT >= 16) {
            try {
                return (Handler)Handler.class.getDeclaredConstructor(Looper.class, Handler.Callback.class, Boolean.TYPE).newInstance(looper, null, true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return new Handler(looper);
    }

    public static Looper buildBackgroundLooper(String threadName) {
        HandlerThread handlerThread = new HandlerThread(threadName);
        handlerThread.start();
        return handlerThread.getLooper();
    }
}

