/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import androidx.annotation.Nullable;
import com.airbnb.epoxy.BaseEpoxyAdapter;
import com.airbnb.epoxy.DiffHelper;
import com.airbnb.epoxy.EpoxyModel;
import com.airbnb.epoxy.HiddenEpoxyModel;
import com.airbnb.epoxy.ModelList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public abstract class EpoxyAdapter
extends BaseEpoxyAdapter {
    private final HiddenEpoxyModel hiddenModel = new HiddenEpoxyModel();
    protected final List<EpoxyModel<?>> models = new ModelList();
    private DiffHelper diffHelper;

    List<EpoxyModel<?>> getCurrentModels() {
        return this.models;
    }

    protected void enableDiffing() {
        if (this.diffHelper != null) {
            throw new IllegalStateException("Diffing was already enabled");
        }
        if (!this.models.isEmpty()) {
            throw new IllegalStateException("You must enable diffing before modifying models");
        }
        if (!this.hasStableIds()) {
            throw new IllegalStateException("You must have stable ids to use diffing");
        }
        this.diffHelper = new DiffHelper(this, false);
    }

    @Override
    EpoxyModel<?> getModelForPosition(int position) {
        HiddenEpoxyModel model = this.models.get(position);
        return model.isShown() ? model : this.hiddenModel;
    }

    protected void notifyModelsChanged() {
        if (this.diffHelper == null) {
            throw new IllegalStateException("You must enable diffing before notifying models changed");
        }
        this.diffHelper.notifyModelChanges();
    }

    protected void notifyModelChanged(EpoxyModel<?> model) {
        this.notifyModelChanged(model, null);
    }

    protected void notifyModelChanged(EpoxyModel<?> model, @Nullable Object payload) {
        int index = this.getModelPosition(model);
        if (index != -1) {
            this.notifyItemChanged(index, payload);
        }
    }

    protected void addModel(EpoxyModel<?> modelToAdd) {
        int initialSize = this.models.size();
        this.pauseModelListNotifications();
        this.models.add(modelToAdd);
        this.resumeModelListNotifications();
        this.notifyItemRangeInserted(initialSize, 1);
    }

    protected void addModels(EpoxyModel<?> ... modelsToAdd) {
        int initialSize = this.models.size();
        int numModelsToAdd = modelsToAdd.length;
        ((ModelList)this.models).ensureCapacity(initialSize + numModelsToAdd);
        this.pauseModelListNotifications();
        Collections.addAll(this.models, modelsToAdd);
        this.resumeModelListNotifications();
        this.notifyItemRangeInserted(initialSize, numModelsToAdd);
    }

    protected void addModels(Collection<? extends EpoxyModel<?>> modelsToAdd) {
        int initialSize = this.models.size();
        this.pauseModelListNotifications();
        this.models.addAll(modelsToAdd);
        this.resumeModelListNotifications();
        this.notifyItemRangeInserted(initialSize, modelsToAdd.size());
    }

    protected void insertModelBefore(EpoxyModel<?> modelToInsert, EpoxyModel<?> modelToInsertBefore) {
        int targetIndex = this.getModelPosition(modelToInsertBefore);
        if (targetIndex == -1) {
            throw new IllegalStateException("Model is not added: " + modelToInsertBefore);
        }
        this.pauseModelListNotifications();
        this.models.add(targetIndex, modelToInsert);
        this.resumeModelListNotifications();
        this.notifyItemInserted(targetIndex);
    }

    protected void insertModelAfter(EpoxyModel<?> modelToInsert, EpoxyModel<?> modelToInsertAfter) {
        int modelIndex = this.getModelPosition(modelToInsertAfter);
        if (modelIndex == -1) {
            throw new IllegalStateException("Model is not added: " + modelToInsertAfter);
        }
        int targetIndex = modelIndex + 1;
        this.pauseModelListNotifications();
        this.models.add(targetIndex, modelToInsert);
        this.resumeModelListNotifications();
        this.notifyItemInserted(targetIndex);
    }

    protected void removeModel(EpoxyModel<?> model) {
        int index = this.getModelPosition(model);
        if (index != -1) {
            this.pauseModelListNotifications();
            this.models.remove(index);
            this.resumeModelListNotifications();
            this.notifyItemRemoved(index);
        }
    }

    protected void removeAllModels() {
        int numModelsRemoved = this.models.size();
        this.pauseModelListNotifications();
        this.models.clear();
        this.resumeModelListNotifications();
        this.notifyItemRangeRemoved(0, numModelsRemoved);
    }

    protected void removeAllAfterModel(EpoxyModel<?> model) {
        List<EpoxyModel<?>> modelsToRemove = this.getAllModelsAfter(model);
        int numModelsRemoved = modelsToRemove.size();
        int initialModelCount = this.models.size();
        this.pauseModelListNotifications();
        modelsToRemove.clear();
        this.resumeModelListNotifications();
        this.notifyItemRangeRemoved(initialModelCount - numModelsRemoved, numModelsRemoved);
    }

    protected void showModel(EpoxyModel<?> model, boolean show) {
        if (model.isShown() == show) {
            return;
        }
        model.show(show);
        this.notifyModelChanged(model);
    }

    protected void showModel(EpoxyModel<?> model) {
        this.showModel(model, true);
    }

    protected void showModels(EpoxyModel<?> ... models) {
        this.showModels(Arrays.asList(models));
    }

    protected void showModels(boolean show, EpoxyModel<?> ... models) {
        this.showModels(Arrays.asList(models), show);
    }

    protected void showModels(Iterable<EpoxyModel<?>> models) {
        this.showModels(models, true);
    }

    protected void showModels(Iterable<EpoxyModel<?>> models, boolean show) {
        for (EpoxyModel<?> model : models) {
            this.showModel(model, show);
        }
    }

    protected void hideModel(EpoxyModel<?> model) {
        this.showModel(model, false);
    }

    protected void hideModels(Iterable<EpoxyModel<?>> models) {
        this.showModels(models, false);
    }

    protected void hideModels(EpoxyModel<?> ... models) {
        this.hideModels(Arrays.asList(models));
    }

    protected void hideAllAfterModel(EpoxyModel<?> model) {
        this.hideModels(this.getAllModelsAfter(model));
    }

    protected List<EpoxyModel<?>> getAllModelsAfter(EpoxyModel<?> model) {
        int index = this.getModelPosition(model);
        if (index == -1) {
            throw new IllegalStateException("Model is not added: " + model);
        }
        return this.models.subList(index + 1, this.models.size());
    }

    private void pauseModelListNotifications() {
        ((ModelList)this.models).pauseNotifications();
    }

    private void resumeModelListNotifications() {
        ((ModelList)this.models).resumeNotifications();
    }
}

