/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy.processor;

import androidx.room.compiler.processing.XAnnotation;
import androidx.room.compiler.processing.XAnnotationBox;
import androidx.room.compiler.processing.XElement;
import androidx.room.compiler.processing.XElementKt;
import androidx.room.compiler.processing.XFieldElement;
import androidx.room.compiler.processing.XMethodElement;
import androidx.room.compiler.processing.XNullability;
import androidx.room.compiler.processing.XProcessingEnv;
import androidx.room.compiler.processing.XType;
import androidx.room.compiler.processing.XTypeElement;
import androidx.room.compiler.processing.XVariableElement;
import com.airbnb.epoxy.CallbackProp;
import com.airbnb.epoxy.ModelProp;
import com.airbnb.epoxy.TextProp;
import com.airbnb.epoxy.processor.AttributeInfo;
import com.airbnb.epoxy.processor.Logger;
import com.airbnb.epoxy.processor.Memoizer;
import com.airbnb.epoxy.processor.ModelViewProcessor;
import com.airbnb.epoxy.processor.TypeNameWorkaroundKt;
import com.airbnb.epoxy.processor.Utils;
import com.airbnb.epoxy.processor.ViewAttributeInfoKt;
import com.airbnb.epoxy.processor.ViewAttributeType;
import com.airbnb.epoxy.processor.XProcessingUtilsKt;
import com.airbnb.epoxy.processor.resourcescanning.ResourceScanner;
import com.airbnb.epoxy.processor.resourcescanning.ResourceValue;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeVariableName;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0018\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010*\u001a\u00020(2\u0006\u0010+\u001a\u00020,H\u0002J \u0010-\u001a\u00020\u00072\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0002J<\u00101\u001a\u00020(2\b\u00102\u001a\u0004\u0018\u00010\u00052\u0006\u00103\u001a\u0002042\b\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u00105\u001a\u0002062\u0006\u0010!\u001a\u00020\u0005H\u0002J\u0010\u00107\u001a\u00020\u00052\u0006\u00108\u001a\u00020\u0007H\u0016J\b\u00109\u001a\u00020\u0005H\u0016J\u0012\u0010:\u001a\u0004\u0018\u00010\u00052\u0006\u0010;\u001a\u000206H\u0002J\u001a\u0010<\u001a\u0004\u0018\u00010$2\u0006\u0010.\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010=\u001a\u00020(2\u0006\u0010+\u001a\u00020,2\u0006\u0010>\u001a\u00020\u00072\u0006\u0010?\u001a\u000206H\u0002J\b\u0010@\u001a\u00020\u0005H\u0016J&\u0010A\u001a\u00020(2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020D0C2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\f\u0010E\u001a\u00020\u0007*\u00020,H\u0002R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0018R\u0014\u0010\u001a\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0018R\u0011\u0010\u001b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0013R\u0011\u0010\u001d\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0018R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010!\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0013R\u0013\u0010#\u001a\u0004\u0018\u00010$\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lcom/airbnb/epoxy/processor/ViewAttributeInfo;", "Lcom/airbnb/epoxy/processor/AttributeInfo;", "viewElement", "Landroidx/room/compiler/processing/XTypeElement;", "viewPackage", "", "hasDefaultKotlinValue", "", "viewAttributeElement", "Landroidx/room/compiler/processing/XElement;", "logger", "Lcom/airbnb/epoxy/processor/Logger;", "resourceProcessor", "Lcom/airbnb/epoxy/processor/resourcescanning/ResourceScanner;", "memoizer", "Lcom/airbnb/epoxy/processor/Memoizer;", "(Landroidx/room/compiler/processing/XTypeElement;Ljava/lang/String;ZLandroidx/room/compiler/processing/XElement;Lcom/airbnb/epoxy/processor/Logger;Lcom/airbnb/epoxy/processor/resourcescanning/ResourceScanner;Lcom/airbnb/epoxy/processor/Memoizer;)V", "constantFieldNameForDefaultValue", "getConstantFieldNameForDefaultValue", "()Ljava/lang/String;", "setConstantFieldNameForDefaultValue", "(Ljava/lang/String;)V", "generateStringOverloads", "getGenerateStringOverloads", "()Z", "getHasDefaultKotlinValue", "isRequired", "propName", "getPropName", "resetWithNull", "getResetWithNull", "getViewAttributeElement", "()Landroidx/room/compiler/processing/XElement;", "viewAttributeName", "getViewAttributeName", "viewAttributeTypeName", "Lcom/airbnb/epoxy/processor/ViewAttributeType;", "getViewAttributeTypeName", "()Lcom/airbnb/epoxy/processor/ViewAttributeType;", "assignDefaultValue", "", "defaultConstant", "assignNullability", "paramElement", "Landroidx/room/compiler/processing/XVariableElement;", "checkElementForConstant", "element", "Landroidx/room/compiler/processing/XFieldElement;", "constantName", "createJavaDoc", "docComment", "codeToSetDefault", "Lcom/airbnb/epoxy/processor/AttributeInfo$DefaultValue;", "attributeTypeName", "Lcom/squareup/javapoet/TypeName;", "generatedGetterName", "isOverload", "generatedSetterName", "getSimpleName", "name", "getViewAttributeType", "parseAnnotations", "markedNullable", "typeName", "toString", "validatePropOptions", "options", "", "Lcom/airbnb/epoxy/ModelProp$Option;", "isNullable", "epoxy-processor"})
public final class ViewAttributeInfo
extends AttributeInfo {
    @NotNull
    private final XTypeElement viewElement;
    private final boolean hasDefaultKotlinValue;
    @NotNull
    private final XElement viewAttributeElement;
    @NotNull
    private final String propName;
    @NotNull
    private final String viewAttributeName;
    private final boolean resetWithNull;
    private final boolean generateStringOverloads;
    @Nullable
    private final ViewAttributeType viewAttributeTypeName;
    @Nullable
    private String constantFieldNameForDefaultValue;

    public ViewAttributeInfo(@NotNull XTypeElement viewElement, @NotNull String viewPackage, boolean hasDefaultKotlinValue, @NotNull XElement viewAttributeElement, @NotNull Logger logger2, @NotNull ResourceScanner resourceProcessor2, @NotNull Memoizer memoizer) {
        XVariableElement xVariableElement;
        Intrinsics.checkNotNullParameter((Object)viewElement, (String)"viewElement");
        Intrinsics.checkNotNullParameter((Object)viewPackage, (String)"viewPackage");
        Intrinsics.checkNotNullParameter((Object)viewAttributeElement, (String)"viewAttributeElement");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)resourceProcessor2, (String)"resourceProcessor");
        Intrinsics.checkNotNullParameter((Object)memoizer, (String)"memoizer");
        super(memoizer);
        this.viewElement = viewElement;
        this.hasDefaultKotlinValue = hasDefaultKotlinValue;
        this.viewAttributeElement = viewAttributeElement;
        XAnnotationBox propAnnotation = this.viewAttributeElement.getAnnotation(Reflection.getOrCreateKotlinClass(ModelProp.class));
        XAnnotationBox textAnnotation = this.viewAttributeElement.getAnnotation(Reflection.getOrCreateKotlinClass(TextProp.class));
        XAnnotationBox callbackAnnotation = this.viewAttributeElement.getAnnotation(Reflection.getOrCreateKotlinClass(CallbackProp.class));
        HashSet<ModelProp.Option> options = new HashSet<ModelProp.Option>();
        XElement xElement = this.viewAttributeElement;
        if (xElement instanceof XMethodElement) {
            xVariableElement = (XVariableElement)CollectionsKt.first((List)((XMethodElement)this.viewAttributeElement).getParameters());
        } else if (xElement instanceof XVariableElement) {
            xVariableElement = (XVariableElement)this.viewAttributeElement;
        } else {
            throw new IllegalStateException(("Unsupported element type " + this.viewAttributeElement).toString());
        }
        XVariableElement param = xVariableElement;
        this.viewAttributeTypeName = this.getViewAttributeType(this.viewAttributeElement, logger2);
        this.setGroupKey("");
        String defaultConstant = "";
        if (propAnnotation != null) {
            defaultConstant = ((ModelProp)propAnnotation.getValue()).defaultValue();
            this.setGroupKey(((ModelProp)propAnnotation.getValue()).group());
            CollectionsKt.addAll((Collection)options, (Object[])((ModelProp)propAnnotation.getValue()).options());
            CollectionsKt.addAll((Collection)options, (Object[])((ModelProp)propAnnotation.getValue()).value());
        } else if (textAnnotation != null) {
            int stringResValue = ((TextProp)textAnnotation.getValue()).defaultRes();
            if (stringResValue != 0) {
                ResourceValue stringResource = resourceProcessor2.getResourceValue((KClass<? extends Annotation>)Reflection.getOrCreateKotlinClass(TextProp.class), this.viewAttributeElement, "defaultRes", stringResValue);
                if (!stringResource.isStringResource()) {
                    logger2.logError(this.viewAttributeElement, "@TextProp value for defaultRes must be a String resource.", new Object[0]);
                }
                this.getCodeToSetDefault().setExplicit(stringResource.getCode());
            }
            options.add(ModelProp.Option.GenerateStringOverloads);
        } else if (callbackAnnotation != null) {
            options.add(ModelProp.Option.DoNotHash);
            if (this.isNullable(param)) {
                options.add(ModelProp.Option.NullOnRecycle);
            } else {
                Object[] objectArray = new Object[1];
                Intrinsics.checkNotNullExpressionValue((Object)CallbackProp.class.getSimpleName(), (String)"CallbackProp::class.java.simpleName");
                logger2.logError("Setters with %s must be marked Nullable", objectArray);
            }
        }
        this.setGenerateSetter(true);
        this.setGenerateGetter(true);
        this.setHasFinalModifier(false);
        this.setPackagePrivate(Utils.isFieldPackagePrivate(this.viewAttributeElement));
        this.setGenerated(true);
        this.setUseInHash(!options.contains(ModelProp.Option.DoNotHash));
        this.setIgnoreRequireHashCode(options.contains(ModelProp.Option.IgnoreRequireHashCode));
        this.resetWithNull = options.contains(ModelProp.Option.NullOnRecycle);
        this.generateStringOverloads = options.contains(ModelProp.Option.GenerateStringOverloads);
        this.setRootClass(this.viewElement.getName());
        this.setPackageName(viewPackage);
        this.viewAttributeName = XProcessingUtilsKt.getExpectName(this.viewAttributeElement);
        this.propName = Utils.INSTANCE.removeSetPrefix(this.viewAttributeName);
        this.setXType(param.getType(), memoizer);
        this.assignDefaultValue(defaultConstant, logger2);
        this.assignNullability(param);
        this.createJavaDoc(this.viewAttributeElement.getDocComment(), this.getCodeToSetDefault(), this.constantFieldNameForDefaultValue, this.viewElement, this.getTypeName(), this.viewAttributeName);
        this.validatePropOptions(logger2, (Set<? extends ModelProp.Option>)options, memoizer);
        if (this.generateStringOverloads) {
            this.setXType(memoizer.getStringAttributeType(), memoizer);
            if (this.getCodeToSetDefault().isPresent()) {
                if (this.getCodeToSetDefault().getExplicit() != null) {
                    Object[] objectArray = new Object[]{this.getTypeName(), this.getCodeToSetDefault().getExplicit()};
                    this.getCodeToSetDefault().setExplicit(CodeBlock.of((String)" new $T($L)", (Object[])objectArray));
                }
                if (this.getCodeToSetDefault().getImplicit() != null) {
                    Object[] objectArray = new Object[]{this.getTypeName(), this.getCodeToSetDefault().getImplicit()};
                    this.getCodeToSetDefault().setImplicit(CodeBlock.of((String)" new $T($L)", (Object[])objectArray));
                }
            } else {
                Object[] objectArray = new Object[]{this.getTypeName()};
                this.getCodeToSetDefault().setImplicit(CodeBlock.of((String)" new $T()", (Object[])objectArray));
            }
        }
        this.setFieldName(this.propName + '_' + this.getSimpleName(this.getTypeName()));
        this.parseAnnotations(param, this.isNullable(param), this.getTypeName());
        if (this.generateStringOverloads) {
            this.getSetterAnnotations().clear();
            this.getGetterAnnotations().clear();
        }
    }

    public final boolean getHasDefaultKotlinValue() {
        return this.hasDefaultKotlinValue;
    }

    @NotNull
    public final XElement getViewAttributeElement() {
        return this.viewAttributeElement;
    }

    @NotNull
    public final String getPropName() {
        return this.propName;
    }

    @NotNull
    public final String getViewAttributeName() {
        return this.viewAttributeName;
    }

    public final boolean getResetWithNull() {
        return this.resetWithNull;
    }

    public final boolean getGenerateStringOverloads() {
        return this.generateStringOverloads;
    }

    @Nullable
    public final ViewAttributeType getViewAttributeTypeName() {
        return this.viewAttributeTypeName;
    }

    @Nullable
    public final String getConstantFieldNameForDefaultValue() {
        return this.constantFieldNameForDefaultValue;
    }

    public final void setConstantFieldNameForDefaultValue(@Nullable String string) {
        this.constantFieldNameForDefaultValue = string;
    }

    @Override
    public boolean isRequired() {
        return this.hasDefaultKotlinValue ? false : (this.generateStringOverloads ? !this.isNullable() && this.constantFieldNameForDefaultValue == null : super.isRequired());
    }

    private final ViewAttributeType getViewAttributeType(XElement element, Logger logger2) {
        ViewAttributeType viewAttributeType;
        if (XElementKt.isMethod((XElement)element)) {
            viewAttributeType = ViewAttributeType.Method.INSTANCE;
        } else if (XElementKt.isField((XElement)element)) {
            viewAttributeType = ViewAttributeType.Field.INSTANCE;
        } else {
            Object[] objectArray = new Object[]{element};
            logger2.logError(element, "Element must be either method or field (element: %s)", objectArray);
            viewAttributeType = null;
        }
        return viewAttributeType;
    }

    private final void assignNullability(XVariableElement paramElement) {
        if (this.isPrimitive()) {
            return;
        }
        this.setNullable(false);
        if (this.isNullable(paramElement)) {
            this.setNullable(true);
            Object[] objectArray = new Object[]{this.getTypeName()};
            this.getCodeToSetDefault().setImplicit(CodeBlock.of((String)"($T) null", (Object[])objectArray));
        }
    }

    private final boolean isNullable(XVariableElement $this$isNullable) {
        return this.getMemoizer().getEnvironment().getBackend() == XProcessingEnv.Backend.KSP ? (XProcessingUtilsKt.isJavaSourceInKsp((XElement)$this$isNullable) ? ViewAttributeInfo.isNullable$hasNullableAnnotation($this$isNullable) : $this$isNullable.getType().getNullability() == XNullability.NULLABLE) : ViewAttributeInfo.isNullable$hasNullableAnnotation($this$isNullable);
    }

    private final void assignDefaultValue(String defaultConstant, Logger logger2) {
        if (this.hasDefaultKotlinValue) {
            if (((CharSequence)defaultConstant).length() > 0) {
                Object[] objectArray = new Object[]{this.viewElement.getName(), this.viewAttributeName};
                logger2.logError("Default set via both kotlin parameter and annotation constant. Use only one. (%s#%s)", objectArray);
            }
            return;
        }
        if (((CharSequence)defaultConstant).length() == 0) {
            if (this.isPrimitive()) {
                this.getCodeToSetDefault().setImplicit(CodeBlock.of((String)Utils.INSTANCE.getDefaultValue(this.getTypeName()), (Object[])new Object[0]));
            }
            return;
        }
        XTypeElement viewClass = this.viewElement;
        while (viewClass != null) {
            for (XFieldElement element : viewClass.getDeclaredFields()) {
                if (!this.checkElementForConstant(element, defaultConstant, logger2)) continue;
                return;
            }
            XType xType = viewClass.getSuperType();
            viewClass = xType != null ? xType.getTypeElement() : null;
        }
        Object[] objectArray = new Object[]{this.viewElement.getName(), this.viewAttributeName, defaultConstant};
        logger2.logError((XElement)this.viewElement, "The default value for (%s#%s) could not be found. Expected a constant named '%s' in the view class.", objectArray);
    }

    private final boolean checkElementForConstant(XFieldElement element, String constantName, Logger logger2) {
        if (!XElementKt.isField((XElement)((XElement)element)) || !Intrinsics.areEqual((Object)element.getName(), (Object)constantName)) {
            return false;
        }
        if (!element.isFinal() || !element.isStatic() || element.isPrivate() && this.getMemoizer().getEnvironment().getBackend() != XProcessingEnv.Backend.KSP) {
            Object[] objectArray = new Object[]{this.viewElement.getName(), this.viewAttributeName};
            logger2.logError((XElement)element, "Default values for view props must be static, final, and not private. (%s#%s)", objectArray);
            return true;
        }
        if (!XProcessingUtilsKt.isSubTypeOf(element.getType(), this.getXType())) {
            Object[] objectArray = new Object[]{this.viewElement.getName(), this.viewAttributeName, this.getTypeName()};
            logger2.logError((XElement)element, "The default value for (%s#%s) must be a %s.", objectArray);
            return true;
        }
        this.constantFieldNameForDefaultValue = constantName;
        Object[] objectArray = new Object[]{this.viewElement.getClassName(), constantName};
        this.getCodeToSetDefault().setExplicit(CodeBlock.of((String)"$T.$L", (Object[])objectArray));
        return true;
    }

    private final void validatePropOptions(Logger logger2, Set<? extends ModelProp.Option> options, Memoizer memoizer) {
        Object[] objectArray;
        if (options.contains(ModelProp.Option.IgnoreRequireHashCode) && options.contains(ModelProp.Option.DoNotHash)) {
            objectArray = new Object[5];
            objectArray[0] = ModelProp.Option.DoNotHash;
            objectArray[1] = ModelProp.Option.IgnoreRequireHashCode;
            Intrinsics.checkNotNullExpressionValue((Object)ModelProp.class.getSimpleName(), (String)"ModelProp::class.java.simpleName");
            objectArray[3] = this.getRootClass();
            objectArray[4] = this.viewAttributeName;
            logger2.logError("Illegal to use both %s and %s options in an %s annotation. (%s#%s)", objectArray);
        }
        if (options.contains(ModelProp.Option.GenerateStringOverloads) && !this.getXType().isSameType(memoizer.getCharSequenceType()) && !this.getXType().isSameType(memoizer.getCharSequenceNullableType())) {
            objectArray = new Object[]{ModelProp.Option.GenerateStringOverloads, this.getRootClass(), this.viewAttributeName};
            logger2.logError(this.viewAttributeElement, "Setters with %s option must be a CharSequence. (%s#%s)", objectArray);
        }
        if (!(!options.contains(ModelProp.Option.NullOnRecycle) || this.hasSetNullability() && this.isNullable())) {
            objectArray = new Object[]{ModelProp.Option.NullOnRecycle, this.getRootClass(), this.viewAttributeName};
            logger2.logError("Setters with %s option must have a type that is annotated with @Nullable. (%s#%s)", objectArray);
        }
    }

    private final String getSimpleName(TypeName name) {
        String string;
        if (name.isPrimitive()) {
            return Utils.capitalizeFirstLetter(name.withoutAnnotations().toString());
        }
        TypeName typeName2 = name;
        if (typeName2 instanceof ClassName) {
            string = ((ClassName)name).simpleName();
        } else if (typeName2 instanceof ArrayTypeName) {
            StringBuilder stringBuilder = new StringBuilder();
            TypeName typeName3 = ((ArrayTypeName)name).componentType;
            Intrinsics.checkNotNullExpressionValue((Object)typeName3, (String)"name.componentType");
            String string2 = this.getSimpleName(typeName3);
            Intrinsics.checkNotNull((Object)string2);
            string = stringBuilder.append(string2).append("Array").toString();
        } else if (typeName2 instanceof ParameterizedTypeName) {
            ClassName className = ((ParameterizedTypeName)name).rawType;
            Intrinsics.checkNotNullExpressionValue((Object)className, (String)"name.rawType");
            string = this.getSimpleName((TypeName)className);
        } else if (typeName2 instanceof TypeVariableName) {
            string = Utils.capitalizeFirstLetter(((TypeVariableName)name).name);
        } else {
            String string3 = name.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"name.toString()");
            string = StringsKt.replace$default((String)string3, (String)".", (String)"", (boolean)false, (int)4, null);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final void parseAnnotations(XVariableElement paramElement, boolean markedNullable, TypeName typeName2) {
        for (XAnnotation xAnnotation : paramElement.getAllAnnotations()) {
            if (ModelViewProcessor.Companion.getModelPropAnnotationSimpleNames().contains(xAnnotation.getName()) || Intrinsics.areEqual((Object)xAnnotation.getName(), (Object)"SuppressWarnings")) continue;
            AnnotationSpec annotationSpec = XProcessingUtilsKt.toAnnotationSpec(xAnnotation, this.getMemoizer());
            this.getSetterAnnotations().add(annotationSpec);
            this.getGetterAnnotations().add(annotationSpec);
        }
        if (!typeName2.isPrimitive()) {
            boolean $i$f$none;
            Iterable $this$none$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.getSetterAnnotations();
            boolean $i$f$map = false;
            Iterator iterator = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string;
                void annotation;
                AnnotationSpec annotationSpec = (AnnotationSpec)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                TypeName type = annotation.type;
                if (type instanceof ClassName) {
                    string = ((ClassName)type).simpleName();
                } else {
                    String string2 = annotation.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"annotation.toString()");
                    string = StringsKt.substringAfterLast$default((String)string2, (String)".", null, (int)2, null);
                }
                collection.add(string);
            }
            List annotations = (List)destination$iv$iv;
            if (markedNullable) {
                boolean bl;
                block15: {
                    $this$none$iv = annotations;
                    $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            String it = (String)element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)it, (Object)"Nullable")) continue;
                            bl = false;
                            break block15;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    List<AnnotationSpec> list = this.getSetterAnnotations();
                    AnnotationSpec annotationSpec = ViewAttributeInfoKt.getNULLABLE_ANNOTATION_SPEC();
                    Intrinsics.checkNotNullExpressionValue((Object)annotationSpec, (String)"NULLABLE_ANNOTATION_SPEC");
                    list.add(annotationSpec);
                    List<AnnotationSpec> list2 = this.getGetterAnnotations();
                    AnnotationSpec annotationSpec2 = ViewAttributeInfoKt.getNULLABLE_ANNOTATION_SPEC();
                    Intrinsics.checkNotNullExpressionValue((Object)annotationSpec2, (String)"NULLABLE_ANNOTATION_SPEC");
                    list2.add(annotationSpec2);
                }
            } else {
                boolean bl;
                block16: {
                    $this$none$iv = annotations;
                    $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            String it = (String)element$iv;
                            boolean bl3 = false;
                            if (!(Intrinsics.areEqual((Object)it, (Object)"NotNull") || Intrinsics.areEqual((Object)it, (Object)"NonNull"))) continue;
                            bl = false;
                            break block16;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    List<AnnotationSpec> list = this.getSetterAnnotations();
                    AnnotationSpec annotationSpec = ViewAttributeInfoKt.getNON_NULL_ANNOTATION_SPEC();
                    Intrinsics.checkNotNullExpressionValue((Object)annotationSpec, (String)"NON_NULL_ANNOTATION_SPEC");
                    list.add(annotationSpec);
                    List<AnnotationSpec> list3 = this.getGetterAnnotations();
                    AnnotationSpec annotationSpec3 = ViewAttributeInfoKt.getNON_NULL_ANNOTATION_SPEC();
                    Intrinsics.checkNotNullExpressionValue((Object)annotationSpec3, (String)"NON_NULL_ANNOTATION_SPEC");
                    list3.add(annotationSpec3);
                }
            }
        }
    }

    private final void createJavaDoc(String docComment, AttributeInfo.DefaultValue codeToSetDefault, String constantFieldNameForDefaultValue, XTypeElement viewElement, TypeName attributeTypeName, String viewAttributeName) {
        Object[] objectArray;
        this.setJavaDocString(docComment);
        if (this.getJavaDoc() == null) {
            this.setJavaDoc(CodeBlock.of((String)"", (Object[])new Object[0]));
        }
        CodeBlock codeBlock = this.getJavaDoc();
        Intrinsics.checkNotNull((Object)codeBlock);
        CodeBlock.Builder builder = codeBlock.toBuilder();
        CodeBlock codeBlock2 = this.getJavaDoc();
        Intrinsics.checkNotNull((Object)codeBlock2);
        if (!codeBlock2.isEmpty()) {
            builder.add("\n<p>\n", new Object[0]);
        }
        if (this.isRequired()) {
            builder.add("<i>Required.</i>", new Object[0]);
        } else {
            builder.add("<i>Optional</i>: ", new Object[0]);
            if (this.hasDefaultKotlinValue) {
                builder.add("View function has a Kotlin default argument", new Object[0]);
            } else if (constantFieldNameForDefaultValue == null) {
                objectArray = new Object[]{codeToSetDefault.value()};
                builder.add("Default value is $L", objectArray);
            } else {
                objectArray = new Object[]{viewElement.getClassName(), constantFieldNameForDefaultValue};
                builder.add("Default value is <b>{@value $T#$L}</b>", objectArray);
            }
        }
        if (Intrinsics.areEqual((Object)this.viewAttributeTypeName, (Object)ViewAttributeType.Field.INSTANCE)) {
            objectArray = new Object[]{TypeNameWorkaroundKt.typeNameWithWorkaround(viewElement.getType(), this.getMemoizer()), viewAttributeName};
            builder.add("\n\n@see $T#$L", objectArray);
        } else {
            objectArray = new Object[]{TypeNameWorkaroundKt.typeNameWithWorkaround(viewElement.getType(), this.getMemoizer()), viewAttributeName, attributeTypeName};
            builder.add("\n\n@see $T#$L($T)", objectArray);
        }
        this.setJavaDoc(builder.add("\n", new Object[0]).build());
    }

    @Override
    @NotNull
    public String generatedSetterName() {
        return this.propName;
    }

    @Override
    @NotNull
    public String generatedGetterName(boolean isOverload) {
        if (isOverload) {
            StringBuilder stringBuilder = new StringBuilder().append(this.propName);
            String string = this.getSimpleName(this.getTypeName());
            Intrinsics.checkNotNull((Object)string);
            return stringBuilder.append(string).toString();
        }
        if (this.generateStringOverloads) {
            return "get" + Utils.capitalizeFirstLetter(this.propName);
        }
        return this.propName;
    }

    @Override
    @NotNull
    public String toString() {
        return "View Prop {view='" + this.viewElement.getName() + "', name='" + this.viewAttributeName + "', type=" + this.getTypeName() + ", hasDefaultKotlinValue=" + this.hasDefaultKotlinValue + '}';
    }

    private static final boolean isNullable$hasNullableAnnotation(XVariableElement $this_isNullable) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = $this_isNullable.getAllAnnotations();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    XAnnotation it = (XAnnotation)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)"Nullable")) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }
}

