/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy.processor;

import androidx.room.compiler.processing.XElement;
import androidx.room.compiler.processing.XExecutableParameterElement;
import androidx.room.compiler.processing.XFieldElement;
import androidx.room.compiler.processing.XHasModifiers;
import androidx.room.compiler.processing.XMethodElement;
import androidx.room.compiler.processing.XProcessingEnv;
import androidx.room.compiler.processing.XRawType;
import androidx.room.compiler.processing.XType;
import androidx.room.compiler.processing.XTypeElement;
import com.airbnb.epoxy.processor.EpoxyProcessorException;
import com.airbnb.epoxy.processor.Logger;
import com.airbnb.epoxy.processor.Memoizer;
import com.airbnb.epoxy.processor.XProcessingUtilsKt;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J5\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010\u00042\u0016\u0010'\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010(\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010)J/\u0010\"\u001a\u00020#2\b\u0010&\u001a\u0004\u0018\u00010\u00042\u0016\u0010'\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010(\"\u0004\u0018\u00010\u0001H\u0007\u00a2\u0006\u0002\u0010*J\u0014\u0010+\u001a\u0004\u0018\u00010\u00042\b\u0010,\u001a\u0004\u0018\u00010\u0004H\u0007J\u000e\u0010-\u001a\u00020\u00042\u0006\u0010.\u001a\u00020/J\u0018\u00100\u001a\u0004\u0018\u0001012\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000205J\"\u00106\u001a\u0004\u0018\u00010\u001d2\u0006\u00102\u001a\u0002032\u0006\u00107\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0007J\u001e\u00108\u001a\u00020\u001b2\u0006\u00102\u001a\u0002032\u0006\u00107\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J\u0010\u00109\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020%H\u0007J\u0018\u0010:\u001a\u00020\u001b2\u0006\u0010$\u001a\u0002012\u0006\u00104\u001a\u000205H\u0007J\u000e\u0010;\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020%J\u000e\u0010<\u001a\u00020\u00042\u0006\u0010=\u001a\u00020\u0004J\u0010\u0010>\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020\u0004H\u0007J/\u0010?\u001a\u00020@2\b\u0010&\u001a\u0004\u0018\u00010\u00042\u0016\u0010'\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010(\"\u0004\u0018\u00010\u0001H\u0007\u00a2\u0006\u0002\u0010AJ\u000e\u0010B\u001a\u00020\u00042\u0006\u0010C\u001a\u00020\u0004J.\u0010D\u001a\u00020\u001b2\u0006\u0010E\u001a\u00020%2\n\u0010F\u001a\u0006\u0012\u0002\b\u00030G2\u0006\u0010H\u001a\u00020I2\b\b\u0002\u0010J\u001a\u00020\u001bH\u0007J\u001e\u0010K\u001a\u00020\u001b*\u0002012\u0006\u0010L\u001a\u00020!2\n\u0010M\u001a\u0006\u0012\u0002\b\u00030NJ\u0012\u0010O\u001a\u00020\u001b*\u0002012\u0006\u0010L\u001a\u00020!J\u0012\u0010P\u001a\u00020\u001b*\u0002012\u0006\u0010L\u001a\u00020!J\u0012\u0010Q\u001a\u00020\u001b*\u0002012\u0006\u0010L\u001a\u00020!J\u0012\u0010R\u001a\u00020\u001b*\u0002012\u0006\u0010L\u001a\u00020!R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006S"}, d2={"Lcom/airbnb/epoxy/processor/Utils;", "", "()V", "ANDROID_VIEW_TYPE", "", "EPOXY_CONTROLLER_TYPE", "EPOXY_HOLDER_TYPE", "EPOXY_MODEL_TYPE", "EPOXY_VIEW_HOLDER_TYPE", "GENERATED_MODEL_INTERFACE", "MODEL_CHECKED_CHANGE_LISTENER_TYPE", "MODEL_CLICK_LISTENER_TYPE", "MODEL_LONG_CLICK_LISTENER_TYPE", "ON_BIND_MODEL_LISTENER_TYPE", "ON_UNBIND_MODEL_LISTENER_TYPE", "ON_VISIBILITY_MODEL_LISTENER_TYPE", "ON_VISIBILITY_STATE_MODEL_LISTENER_TYPE", "PATTERN_STARTS_WITH_SET", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "UNTYPED_EPOXY_MODEL_TYPE", "VIEW_CHECKED_CHANGE_LISTENER_TYPE", "VIEW_CLICK_LISTENER_TYPE", "VIEW_LONG_CLICK_LISTENER_TYPE", "WRAPPED_CHECKED_LISTENER_TYPE", "WRAPPED_LISTENER_TYPE", "areParamsTheSame", "", "method1", "Landroidx/room/compiler/processing/XMethodElement;", "method2", "Lcom/squareup/javapoet/MethodSpec;", "environment", "Landroidx/room/compiler/processing/XProcessingEnv;", "buildEpoxyException", "Lcom/airbnb/epoxy/processor/EpoxyProcessorException;", "element", "Landroidx/room/compiler/processing/XElement;", "msg", "args", "", "(Landroidx/room/compiler/processing/XElement;Ljava/lang/String;[Ljava/lang/Object;)Lcom/airbnb/epoxy/processor/EpoxyProcessorException;", "(Ljava/lang/String;[Ljava/lang/Object;)Lcom/airbnb/epoxy/processor/EpoxyProcessorException;", "capitalizeFirstLetter", "original", "getDefaultValue", "attributeType", "Lcom/squareup/javapoet/TypeName;", "getEpoxyObjectType", "Landroidx/room/compiler/processing/XType;", "clazz", "Landroidx/room/compiler/processing/XTypeElement;", "memoizer", "Lcom/airbnb/epoxy/processor/Memoizer;", "getMethodOnClass", "method", "implementsMethod", "isFieldPackagePrivate", "isIterableType", "isSetterMethod", "removeSetPrefix", "string", "startsWithIs", "throwError", "", "(Ljava/lang/String;[Ljava/lang/Object;)V", "toSnakeCase", "s", "validateFieldAccessibleViaGeneratedCode", "fieldElement", "annotationClass", "Ljava/lang/Class;", "logger", "Lcom/airbnb/epoxy/processor/Logger;", "skipPrivateFieldCheck", "isAssignableToRawType", "processingEnv", "targetClass", "Lkotlin/reflect/KClass;", "isClass", "isIterable", "isMap", "isSet", "epoxy-processor"})
public final class Utils {
    @NotNull
    public static final Utils INSTANCE = new Utils();
    private static final Pattern PATTERN_STARTS_WITH_SET = Pattern.compile("set[A-Z]\\w*");
    @NotNull
    public static final String EPOXY_MODEL_TYPE = "com.airbnb.epoxy.EpoxyModel<?>";
    @NotNull
    public static final String UNTYPED_EPOXY_MODEL_TYPE = "com.airbnb.epoxy.EpoxyModel";
    @NotNull
    public static final String EPOXY_VIEW_HOLDER_TYPE = "com.airbnb.epoxy.EpoxyViewHolder";
    @NotNull
    public static final String EPOXY_HOLDER_TYPE = "com.airbnb.epoxy.EpoxyHolder";
    @NotNull
    public static final String ANDROID_VIEW_TYPE = "android.view.View";
    @NotNull
    public static final String EPOXY_CONTROLLER_TYPE = "com.airbnb.epoxy.EpoxyController";
    @NotNull
    public static final String VIEW_CLICK_LISTENER_TYPE = "android.view.View.OnClickListener";
    @NotNull
    public static final String VIEW_LONG_CLICK_LISTENER_TYPE = "android.view.View.OnLongClickListener";
    @NotNull
    public static final String VIEW_CHECKED_CHANGE_LISTENER_TYPE = "android.widget.CompoundButton.OnCheckedChangeListener";
    @NotNull
    public static final String GENERATED_MODEL_INTERFACE = "com.airbnb.epoxy.GeneratedModel";
    @NotNull
    public static final String MODEL_CLICK_LISTENER_TYPE = "com.airbnb.epoxy.OnModelClickListener";
    @NotNull
    public static final String MODEL_LONG_CLICK_LISTENER_TYPE = "com.airbnb.epoxy.OnModelLongClickListener";
    @NotNull
    public static final String MODEL_CHECKED_CHANGE_LISTENER_TYPE = "com.airbnb.epoxy.OnModelCheckedChangeListener";
    @NotNull
    public static final String ON_BIND_MODEL_LISTENER_TYPE = "com.airbnb.epoxy.OnModelBoundListener";
    @NotNull
    public static final String ON_UNBIND_MODEL_LISTENER_TYPE = "com.airbnb.epoxy.OnModelUnboundListener";
    @NotNull
    public static final String WRAPPED_LISTENER_TYPE = "com.airbnb.epoxy.WrappedEpoxyModelClickListener";
    @NotNull
    public static final String WRAPPED_CHECKED_LISTENER_TYPE = "com.airbnb.epoxy.WrappedEpoxyModelCheckedChangeListener";
    @NotNull
    public static final String ON_VISIBILITY_STATE_MODEL_LISTENER_TYPE = "com.airbnb.epoxy.OnModelVisibilityStateChangedListener";
    @NotNull
    public static final String ON_VISIBILITY_MODEL_LISTENER_TYPE = "com.airbnb.epoxy.OnModelVisibilityChangedListener";

    private Utils() {
    }

    @JvmStatic
    public static final void throwError(@Nullable String msg, Object ... args) throws EpoxyProcessorException {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        String string = msg;
        Intrinsics.checkNotNull((Object)string);
        String string2 = string;
        Object[] objectArray = Arrays.copyOf(args, args.length);
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
        throw new EpoxyProcessorException(string3, null, null, 6, null);
    }

    @JvmStatic
    @NotNull
    public static final EpoxyProcessorException buildEpoxyException(@Nullable String msg, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        String string = msg;
        Intrinsics.checkNotNull((Object)string);
        String string2 = string;
        Object[] objectArray = Arrays.copyOf(args, args.length);
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
        return new EpoxyProcessorException(string3, null, null, 6, null);
    }

    @NotNull
    public final EpoxyProcessorException buildEpoxyException(@NotNull XElement element, @Nullable String msg, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        String string = msg;
        Intrinsics.checkNotNull((Object)string);
        String string2 = string;
        Object[] objectArray = Arrays.copyOf(args, args.length);
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
        return new EpoxyProcessorException(string3, null, element, 2, null);
    }

    @JvmStatic
    public static final boolean isIterableType(@NotNull XType element, @NotNull Memoizer memoizer) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)memoizer, (String)"memoizer");
        return XProcessingUtilsKt.isSubTypeOf(element, memoizer.getIterableType());
    }

    public final boolean isSet(@NotNull XType $this$isSet, @NotNull XProcessingEnv processingEnv) {
        Intrinsics.checkNotNullParameter((Object)$this$isSet, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)processingEnv, (String)"processingEnv");
        return this.isAssignableToRawType($this$isSet, processingEnv, Reflection.getOrCreateKotlinClass(Set.class));
    }

    public final boolean isMap(@NotNull XType $this$isMap, @NotNull XProcessingEnv processingEnv) {
        Intrinsics.checkNotNullParameter((Object)$this$isMap, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)processingEnv, (String)"processingEnv");
        return this.isAssignableToRawType($this$isMap, processingEnv, Reflection.getOrCreateKotlinClass(Map.class));
    }

    public final boolean isIterable(@NotNull XType $this$isIterable, @NotNull XProcessingEnv processingEnv) {
        Intrinsics.checkNotNullParameter((Object)$this$isIterable, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)processingEnv, (String)"processingEnv");
        return this.isAssignableToRawType($this$isIterable, processingEnv, Reflection.getOrCreateKotlinClass(Iterable.class));
    }

    public final boolean isClass(@NotNull XType $this$isClass, @NotNull XProcessingEnv processingEnv) {
        Intrinsics.checkNotNullParameter((Object)$this$isClass, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)processingEnv, (String)"processingEnv");
        return this.isAssignableToRawType($this$isClass, processingEnv, Reflection.getOrCreateKotlinClass(Class.class));
    }

    public final boolean isAssignableToRawType(@NotNull XType $this$isAssignableToRawType, @NotNull XProcessingEnv processingEnv, @NotNull KClass<?> targetClass) {
        Intrinsics.checkNotNullParameter((Object)$this$isAssignableToRawType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)processingEnv, (String)"processingEnv");
        Intrinsics.checkNotNullParameter(targetClass, (String)"targetClass");
        if ($this$isAssignableToRawType.isTypeOf(targetClass)) {
            return true;
        }
        XRawType targetRawType = processingEnv.requireTypeElement(targetClass).getType().getRawType();
        return targetRawType.isAssignableFrom($this$isAssignableToRawType.getRawType());
    }

    @JvmStatic
    public static final boolean isFieldPackagePrivate(@NotNull XElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!(element instanceof XHasModifiers)) {
            return false;
        }
        return !((XHasModifiers)element).isPrivate() && !((XHasModifiers)element).isProtected() && !((XHasModifiers)element).isPublic();
    }

    public final boolean implementsMethod(@NotNull XTypeElement clazz, @NotNull MethodSpec method, @NotNull XProcessingEnv environment) {
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        XMethodElement xMethodElement = Utils.getMethodOnClass(clazz, method, environment);
        if (xMethodElement == null) {
            return false;
        }
        XMethodElement methodOnClass = xMethodElement;
        return !methodOnClass.isAbstract();
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @Nullable
    public static final XMethodElement getMethodOnClass(@NotNull XTypeElement clazz, @NotNull MethodSpec method, @NotNull XProcessingEnv environment) {
        Object v0;
        block3: {
            void $this$firstOrNull$iv;
            Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
            Iterable iterable = clazz.getDeclaredMethods();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                XMethodElement methodElement = (XMethodElement)element$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)methodElement.getName(), (Object)method.name) && INSTANCE.areParamsTheSame(methodElement, method, environment))) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        XMethodElement xMethodElement = v0;
        if (xMethodElement != null) {
            XMethodElement it = xMethodElement;
            boolean bl = false;
            return it;
        }
        XType xType = clazz.getSuperType();
        if (xType == null || (xType = xType.getTypeElement()) == null) {
            return null;
        }
        XType superClazz = xType;
        return Utils.getMethodOnClass((XTypeElement)superClazz, method, environment);
    }

    private final boolean areParamsTheSame(XMethodElement method1, MethodSpec method2, XProcessingEnv environment) {
        List params1 = method1.getParameters();
        List params2 = method2.parameters;
        if (params1.size() != params2.size()) {
            return false;
        }
        int n = params1.size();
        for (int i = 0; i < n; ++i) {
            XExecutableParameterElement param1 = (XExecutableParameterElement)params1.get(i);
            Object e = params2.get(i);
            Intrinsics.checkNotNullExpressionValue(e, (String)"params2[i]");
            ParameterSpec param2 = (ParameterSpec)e;
            XRawType param1Type = param1.getType().getRawType();
            TypeName typeName2 = param2.type;
            Intrinsics.checkNotNullExpressionValue((Object)typeName2, (String)"param2.type");
            XRawType param2Type = environment.requireType(typeName2).getRawType();
            if (!(param1.getType().extendsBound() == null ? !param1Type.isAssignableFrom(param2Type) : !Intrinsics.areEqual((Object)param1Type, (Object)param2Type))) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public final XType getEpoxyObjectType(@NotNull XTypeElement clazz, @NotNull Memoizer memoizer) {
        Object superTypeArguments;
        Object object;
        Object object2;
        block7: {
            XType recursiveResult;
            block8: {
                Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
                Intrinsics.checkNotNullParameter((Object)memoizer, (String)"memoizer");
                XType xType = clazz.getSuperType();
                if (xType == null || (xType = xType.getTypeElement()) == null) {
                    return null;
                }
                XType superTypeElement = xType;
                recursiveResult = this.getEpoxyObjectType((XTypeElement)superTypeElement, memoizer);
                if (recursiveResult == null) break block7;
                if (recursiveResult.getTypeElement() != null) break block8;
                XType xType2 = recursiveResult.extendsBound();
                if ((xType2 != null ? xType2.getTypeElement() : null) == null) break block7;
            }
            return recursiveResult;
        }
        if ((object2 = clazz.getSuperType()) == null || (object2 = object2.getTypeArguments()) == null) {
            object2 = CollectionsKt.emptyList();
        }
        if ((object = (XType)CollectionsKt.singleOrNull((List)(superTypeArguments = object2))) != null) {
            XType it = object;
            boolean bl = false;
            return it;
        }
        object = superTypeArguments.iterator();
        while (object.hasNext()) {
            XType superTypeArgument = (XType)object.next();
            if (!XProcessingUtilsKt.isSubTypeOf(superTypeArgument, memoizer.getAndroidViewType()) && !XProcessingUtilsKt.isSubTypeOf(superTypeArgument, memoizer.getEpoxyHolderType())) continue;
            return superTypeArgument;
        }
        return null;
    }

    @JvmOverloads
    public final boolean validateFieldAccessibleViaGeneratedCode(@NotNull XElement fieldElement, @NotNull Class<?> annotationClass, @NotNull Logger logger2, boolean skipPrivateFieldCheck) {
        Intrinsics.checkNotNullParameter((Object)fieldElement, (String)"fieldElement");
        Intrinsics.checkNotNullParameter(annotationClass, (String)"annotationClass");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        if (!(fieldElement instanceof XHasModifiers)) {
            return false;
        }
        XTypeElement xTypeElement = XProcessingUtilsKt.getEnclosingTypeElement(fieldElement);
        Intrinsics.checkNotNull((Object)xTypeElement);
        XTypeElement enclosingElement = xTypeElement;
        if (!(fieldElement instanceof XFieldElement)) {
            Object[] objectArray = new Object[3];
            Intrinsics.checkNotNullExpressionValue((Object)annotationClass.getSimpleName(), (String)"annotationClass.simpleName");
            objectArray[1] = XProcessingUtilsKt.getExpectName((XElement)enclosingElement);
            objectArray[2] = XProcessingUtilsKt.getExpectName(fieldElement);
            logger2.logError(fieldElement, "%s annotation must be on field. (class: %s, element: %s)", objectArray);
            return false;
        }
        if (((XHasModifiers)fieldElement).isPrivate() && !skipPrivateFieldCheck) {
            Object[] objectArray = new Object[3];
            Intrinsics.checkNotNullExpressionValue((Object)annotationClass.getSimpleName(), (String)"annotationClass.simpleName");
            objectArray[1] = XProcessingUtilsKt.getExpectName((XElement)enclosingElement);
            objectArray[2] = XProcessingUtilsKt.getExpectName(fieldElement);
            logger2.logError(fieldElement, "%s annotations must not be on private fields. (class: %s, field: %s)", objectArray);
            return false;
        }
        if (((XHasModifiers)fieldElement).isStatic()) {
            Object[] objectArray = new Object[3];
            Intrinsics.checkNotNullExpressionValue((Object)annotationClass.getSimpleName(), (String)"annotationClass.simpleName");
            objectArray[1] = XProcessingUtilsKt.getExpectName((XElement)enclosingElement);
            objectArray[2] = XProcessingUtilsKt.getExpectName(fieldElement);
            logger2.logError(fieldElement, "%s annotations must not be on static fields. (class: %s, field: %s)", objectArray);
            return false;
        }
        if (enclosingElement.getEnclosingTypeElement() != null && !enclosingElement.isStatic()) {
            Object[] objectArray = new Object[3];
            Intrinsics.checkNotNullExpressionValue((Object)annotationClass.getSimpleName(), (String)"annotationClass.simpleName");
            objectArray[1] = XProcessingUtilsKt.getExpectName((XElement)enclosingElement);
            objectArray[2] = XProcessingUtilsKt.getExpectName(fieldElement);
            logger2.logError(fieldElement, "Nested classes with %s annotations must be static. (class: %s, field: %s)", objectArray);
            return false;
        }
        if (!enclosingElement.isClass()) {
            Object[] objectArray = new Object[3];
            Intrinsics.checkNotNullExpressionValue((Object)annotationClass.getSimpleName(), (String)"annotationClass.simpleName");
            objectArray[1] = XProcessingUtilsKt.getExpectName((XElement)enclosingElement);
            objectArray[2] = XProcessingUtilsKt.getExpectName(fieldElement);
            logger2.logError(fieldElement, "%s annotations may only be contained in classes. (class: %s, field: %s)", objectArray);
            return false;
        }
        if (enclosingElement.isPrivate()) {
            Object[] objectArray = new Object[3];
            Intrinsics.checkNotNullExpressionValue((Object)annotationClass.getSimpleName(), (String)"annotationClass.simpleName");
            objectArray[1] = XProcessingUtilsKt.getExpectName((XElement)enclosingElement);
            objectArray[2] = XProcessingUtilsKt.getExpectName(fieldElement);
            logger2.logError(fieldElement, "%s annotations may not be contained in private classes. (class: %s, field: %s)", objectArray);
            return false;
        }
        return true;
    }

    public static /* synthetic */ boolean validateFieldAccessibleViaGeneratedCode$default(Utils utils, XElement xElement, Class clazz, Logger logger2, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = XProcessingUtilsKt.isKsp(xElement);
        }
        return utils.validateFieldAccessibleViaGeneratedCode(xElement, clazz, logger2, bl);
    }

    @JvmStatic
    @Nullable
    public static final String capitalizeFirstLetter(@Nullable String original) {
        String string;
        if (original == null || ((CharSequence)original).length() == 0) {
            string = original;
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = original.substring(0, 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String string3 = string2.toUpperCase();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toUpperCase()");
            StringBuilder stringBuilder2 = stringBuilder.append(string3);
            String string4 = original.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
            string = stringBuilder2.append(string4).toString();
        }
        return string;
    }

    @JvmStatic
    public static final boolean startsWithIs(@NotNull String original) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        return StringsKt.startsWith$default((String)original, (String)"is", (boolean)false, (int)2, null) && original.length() > 2 && Character.isUpperCase(original.charAt(2));
    }

    public final boolean isSetterMethod(@NotNull XElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        XMethodElement xMethodElement = element instanceof XMethodElement ? (XMethodElement)element : null;
        if (xMethodElement == null) {
            return false;
        }
        XMethodElement method = xMethodElement;
        return PATTERN_STARTS_WITH_SET.matcher(method.getName()).matches() && method.getParameters().size() == 1;
    }

    @NotNull
    public final String removeSetPrefix(@NotNull String string) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        if (!PATTERN_STARTS_WITH_SET.matcher(string).matches()) {
            string2 = string;
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            String string3 = String.valueOf(string.charAt(3)).toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase()");
            StringBuilder stringBuilder2 = stringBuilder.append(string3);
            String string4 = string.substring(4);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
            string2 = stringBuilder2.append(string4).toString();
        }
        return string2;
    }

    @NotNull
    public final String toSnakeCase(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        CharSequence charSequence = s;
        Regex regex = new Regex("([^_A-Z])([A-Z])");
        String string = "$1_$2";
        String string2 = regex.replace(charSequence, string).toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase()");
        return string2;
    }

    @NotNull
    public final String getDefaultValue(@NotNull TypeName attributeType) {
        Intrinsics.checkNotNullParameter((Object)attributeType, (String)"attributeType");
        return attributeType == TypeName.BOOLEAN ? "false" : (attributeType == TypeName.INT ? "0" : (attributeType == TypeName.BYTE ? "(byte) 0" : (attributeType == TypeName.CHAR ? "(char) 0" : (attributeType == TypeName.SHORT ? "(short) 0" : (attributeType == TypeName.LONG ? "0L" : (attributeType == TypeName.FLOAT ? "0.0f" : (attributeType == TypeName.DOUBLE ? "0.0d" : "null")))))));
    }

    @JvmOverloads
    public final boolean validateFieldAccessibleViaGeneratedCode(@NotNull XElement fieldElement, @NotNull Class<?> annotationClass, @NotNull Logger logger2) {
        Intrinsics.checkNotNullParameter((Object)fieldElement, (String)"fieldElement");
        Intrinsics.checkNotNullParameter(annotationClass, (String)"annotationClass");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        return Utils.validateFieldAccessibleViaGeneratedCode$default(this, fieldElement, annotationClass, logger2, false, 8, null);
    }
}

