/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy.processor;

import androidx.room.compiler.processing.XMessager;
import java.util.ArrayList;
import java.util.List;
import javax.tools.Diagnostic;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0006H\u0002J\u000e\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0003J\u0006\u0010\u0016\u001a\u00020\u000fJ\u0014\u0010\u0017\u001a\u00020\u0018*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/airbnb/epoxy/processor/Timer;", "", "name", "", "(Ljava/lang/String;)V", "lastTimingNanos", "", "Ljava/lang/Long;", "getName", "()Ljava/lang/String;", "startNanos", "timingSteps", "", "Lcom/airbnb/epoxy/processor/Timer$TimingStep;", "finishAndPrint", "", "messager", "Landroidx/room/compiler/processing/XMessager;", "formatNanos", "nanos", "markStepCompleted", "stepDescription", "start", "roundTo", "", "numFractionDigits", "", "TimingStep", "epoxy-processor"})
public final class Timer {
    @NotNull
    private final String name;
    @NotNull
    private final List<TimingStep> timingSteps;
    @Nullable
    private Long startNanos;
    @Nullable
    private Long lastTimingNanos;

    public Timer(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        this.timingSteps = new ArrayList();
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final void start() {
        this.timingSteps.clear();
        this.lastTimingNanos = this.startNanos = Long.valueOf(System.nanoTime());
    }

    public final void markStepCompleted(@NotNull String stepDescription) {
        Intrinsics.checkNotNullParameter((Object)stepDescription, (String)"stepDescription");
        long nowNanos = System.nanoTime();
        Long l = this.lastTimingNanos;
        if (l == null) {
            throw new IllegalStateException("Timer was not started".toString());
        }
        long lastNanos = l;
        this.lastTimingNanos = nowNanos;
        this.timingSteps.add(new TimingStep(nowNanos - lastNanos, stepDescription));
    }

    public final void finishAndPrint(@NotNull XMessager messager) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)messager, (String)"messager");
        Long l = this.startNanos;
        if (l == null) {
            throw new IllegalStateException("Timer was not started".toString());
        }
        long start = l;
        StringBuilder $this$finishAndPrint_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        StringBuilder stringBuilder2 = $this$finishAndPrint_u24lambda_u241.append(this.name + " finished in " + this.formatNanos(System.nanoTime() - start));
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
        Iterable $this$forEach$iv = this.timingSteps;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TimingStep step = (TimingStep)element$iv;
            boolean bl2 = false;
            StringBuilder stringBuilder3 = $this$finishAndPrint_u24lambda_u241.append(" - " + step.getDescription() + " (" + this.formatNanos(step.getDurationNanos()) + ')');
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        String message = string;
        messager.printMessage(Diagnostic.Kind.WARNING, message);
    }

    private final String formatNanos(long nanos) {
        double diffMs = this.roundTo((double)nanos / 1000000.0, 3);
        return diffMs + " ms";
    }

    private final double roundTo(double $this$roundTo, int numFractionDigits) {
        double factor = Math.pow(10.0, numFractionDigits);
        return (double)MathKt.roundToInt((double)($this$roundTo * factor)) / factor;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/airbnb/epoxy/processor/Timer$TimingStep;", "", "durationNanos", "", "description", "", "(JLjava/lang/String;)V", "getDescription", "()Ljava/lang/String;", "getDurationNanos", "()J", "epoxy-processor"})
    private static final class TimingStep {
        private final long durationNanos;
        @NotNull
        private final String description;

        public TimingStep(long durationNanos, @NotNull String description) {
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            this.durationNanos = durationNanos;
            this.description = description;
        }

        public final long getDurationNanos() {
            return this.durationNanos;
        }

        @NotNull
        public final String getDescription() {
            return this.description;
        }
    }
}

