/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy.processor;

import androidx.room.compiler.processing.XAnnotationBox;
import androidx.room.compiler.processing.XType;
import androidx.room.compiler.processing.XTypeElement;
import androidx.room.compiler.processing.XTypeKt;
import com.airbnb.epoxy.PackageModelViewConfig;
import com.airbnb.epoxy.processor.Utils;
import com.airbnb.epoxy.processor.resourcescanning.ResourceValue;
import com.squareup.javapoet.ClassName;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0003J\u0013\u0010'\u001a\u0004\u0018\u00010\u000f*\u00020(H\u0002\u00a2\u0006\u0002\u0010)R\u001d\u0010\b\u001a\u0004\u0018\u00010\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u0015\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011R\u0015\u0010\u0013\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0014\u0010\u0011R\u0015\u0010\u0015\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0016\u0010\u0011R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001aR\u0011\u0010 \u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u0006*"}, d2={"Lcom/airbnb/epoxy/processor/PackageModelViewSettings;", "", "rClassName", "Landroidx/room/compiler/processing/XTypeElement;", "annotation", "Landroidx/room/compiler/processing/XAnnotationBox;", "Lcom/airbnb/epoxy/PackageModelViewConfig;", "(Landroidx/room/compiler/processing/XTypeElement;Landroidx/room/compiler/processing/XAnnotationBox;)V", "defaultBaseModel", "Landroidx/room/compiler/processing/XType;", "getDefaultBaseModel", "()Landroidx/room/compiler/processing/XType;", "defaultBaseModel$delegate", "Lkotlin/Lazy;", "disableGenerateBuilderOverloads", "", "getDisableGenerateBuilderOverloads", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "disableGenerateGetters", "getDisableGenerateGetters", "disableGenerateReset", "getDisableGenerateReset", "generatedModelSuffix", "", "getGeneratedModelSuffix", "()Ljava/lang/String;", "includeAlternateLayouts", "getIncludeAlternateLayouts", "()Z", "layoutName", "getLayoutName", "rClass", "Lcom/squareup/javapoet/ClassName;", "getRClass", "()Lcom/squareup/javapoet/ClassName;", "getNameForView", "Lcom/airbnb/epoxy/processor/resourcescanning/ResourceValue;", "viewElement", "toBoolean", "Lcom/airbnb/epoxy/PackageModelViewConfig$Option;", "(Lcom/airbnb/epoxy/PackageModelViewConfig$Option;)Ljava/lang/Boolean;", "epoxy-processor"})
public final class PackageModelViewSettings {
    @NotNull
    private final ClassName rClass;
    @NotNull
    private final String layoutName;
    private final boolean includeAlternateLayouts;
    @NotNull
    private final String generatedModelSuffix;
    @Nullable
    private final Boolean disableGenerateBuilderOverloads;
    @Nullable
    private final Boolean disableGenerateGetters;
    @Nullable
    private final Boolean disableGenerateReset;
    @NotNull
    private final Lazy defaultBaseModel$delegate;

    public PackageModelViewSettings(@NotNull XTypeElement rClassName, @NotNull XAnnotationBox<PackageModelViewConfig> annotation) {
        Intrinsics.checkNotNullParameter((Object)rClassName, (String)"rClassName");
        Intrinsics.checkNotNullParameter(annotation, (String)"annotation");
        String[] stringArray = new String[]{"layout"};
        ClassName className = ClassName.get((String)rClassName.getPackageName(), (String)"R", (String[])stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)className, (String)"get(rClassName.packageName, \"R\", \"layout\")");
        this.rClass = className;
        this.layoutName = ((PackageModelViewConfig)annotation.getValue()).defaultLayoutPattern();
        this.includeAlternateLayouts = ((PackageModelViewConfig)annotation.getValue()).useLayoutOverloads();
        this.generatedModelSuffix = ((PackageModelViewConfig)annotation.getValue()).generatedModelSuffix();
        this.disableGenerateBuilderOverloads = this.toBoolean(((PackageModelViewConfig)annotation.getValue()).disableGenerateBuilderOverloads());
        this.disableGenerateGetters = this.toBoolean(((PackageModelViewConfig)annotation.getValue()).disableGenerateGetters());
        this.disableGenerateReset = this.toBoolean(((PackageModelViewConfig)annotation.getValue()).disableGenerateReset());
        this.defaultBaseModel$delegate = LazyKt.lazy((Function0)((Function0)new Function0<XType>(annotation){
            final /* synthetic */ XAnnotationBox<PackageModelViewConfig> $annotation;
            {
                this.$annotation = $annotation;
                super(0);
            }

            @Nullable
            public final XType invoke() {
                Object object;
                XType xType = this.$annotation.getAsType("defaultBaseModelClass");
                if (xType != null) {
                    XType xType2;
                    XType it = xType2 = xType;
                    boolean bl = false;
                    object = !XTypeKt.isVoid((XType)it) && !XTypeKt.isVoidObject((XType)it) ? xType2 : null;
                } else {
                    object = null;
                }
                return object;
            }
        }));
    }

    @NotNull
    public final ClassName getRClass() {
        return this.rClass;
    }

    @NotNull
    public final String getLayoutName() {
        return this.layoutName;
    }

    public final boolean getIncludeAlternateLayouts() {
        return this.includeAlternateLayouts;
    }

    @NotNull
    public final String getGeneratedModelSuffix() {
        return this.generatedModelSuffix;
    }

    @Nullable
    public final Boolean getDisableGenerateBuilderOverloads() {
        return this.disableGenerateBuilderOverloads;
    }

    @Nullable
    public final Boolean getDisableGenerateGetters() {
        return this.disableGenerateGetters;
    }

    @Nullable
    public final Boolean getDisableGenerateReset() {
        return this.disableGenerateReset;
    }

    @Nullable
    public final XType getDefaultBaseModel() {
        Lazy lazy = this.defaultBaseModel$delegate;
        return (XType)lazy.getValue();
    }

    @NotNull
    public final ResourceValue getNameForView(@NotNull XTypeElement viewElement) {
        Intrinsics.checkNotNullParameter((Object)viewElement, (String)"viewElement");
        String viewName = Utils.INSTANCE.toSnakeCase(viewElement.getName());
        String resourceName = StringsKt.replace$default((String)this.layoutName, (String)"%s", (String)viewName, (boolean)false, (int)4, null);
        return new ResourceValue(this.rClass, resourceName, 0);
    }

    private final Boolean toBoolean(PackageModelViewConfig.Option $this$toBoolean) {
        Boolean bl;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$toBoolean.ordinal()]) {
            case 1: {
                bl = null;
                break;
            }
            case 2: {
                bl = true;
                break;
            }
            case 3: {
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PackageModelViewConfig.Option.values().length];
            try {
                nArray[PackageModelViewConfig.Option.Default.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PackageModelViewConfig.Option.Enabled.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PackageModelViewConfig.Option.Disabled.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

