/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy.processor;

import androidx.room.compiler.processing.XArrayType;
import androidx.room.compiler.processing.XConstructorElement;
import androidx.room.compiler.processing.XElement;
import androidx.room.compiler.processing.XExecutableParameterElement;
import androidx.room.compiler.processing.XFieldElement;
import androidx.room.compiler.processing.XHasModifiers;
import androidx.room.compiler.processing.XMethodElement;
import androidx.room.compiler.processing.XProcessingEnv;
import androidx.room.compiler.processing.XType;
import androidx.room.compiler.processing.XTypeElement;
import androidx.room.compiler.processing.XTypeKt;
import com.airbnb.epoxy.EpoxyAttribute;
import com.airbnb.epoxy.ModelView;
import com.airbnb.epoxy.processor.AttributeInfo;
import com.airbnb.epoxy.processor.ClassNames;
import com.airbnb.epoxy.processor.EpoxyProcessor;
import com.airbnb.epoxy.processor.GeneratedModelInfo;
import com.airbnb.epoxy.processor.Logger;
import com.airbnb.epoxy.processor.Memoizer;
import com.airbnb.epoxy.processor.MemoizerKt;
import com.airbnb.epoxy.processor.MethodInfo;
import com.airbnb.epoxy.processor.MethodInfoLight;
import com.airbnb.epoxy.processor.Type;
import com.airbnb.epoxy.processor.TypeNameWorkaroundKt;
import com.airbnb.epoxy.processor.Utils;
import com.airbnb.epoxy.processor.ViewAttributeInfo;
import com.airbnb.epoxy.processor.XProcessingUtilsKt;
import com.airbnb.epoxy.processor.resourcescanning.ResourceScanner;
import com.google.devtools.ksp.UtilsKt;
import com.google.devtools.ksp.processing.Resolver;
import com.google.devtools.ksp.symbol.KSClassDeclaration;
import com.google.devtools.ksp.symbol.KSType;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u00002\u00020\u0001:\u0006\u0081\u0001\u0082\u0001\u0083\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010f\u001a\u00020\u00102\u0006\u0010g\u001a\u00020%2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010h\u001a\u00020iJ\u001c\u0010j\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010k\u001a\u00020%2\u0006\u0010l\u001a\u00020\u0000J\u0014\u0010m\u001a\b\u0012\u0004\u0012\u00020I0\u001d2\u0006\u0010n\u001a\u00020%J\u001a\u0010o\u001a\u0004\u0018\u00010B2\u0006\u0010k\u001a\u00020%2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J:\u0010p\u001a\b\u0012\u0004\u0012\u00020q0\u001d2\u0006\u0010r\u001a\u00020\b2\u0006\u0010s\u001a\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\u00052\u0014\b\u0002\u0010t\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020?0uJ\u001c\u0010v\u001a\b\u0012\u0004\u0012\u00020N0M2\u0006\u0010w\u001a\u00020\b2\u0006\u0010l\u001a\u00020\u0000J\u000e\u0010x\u001a\u00020V2\u0006\u0010y\u001a\u00020\bJ\u000e\u0010z\u001a\u00020?2\u0006\u0010k\u001a\u00020%J\u000e\u0010{\u001a\u00020?2\u0006\u0010k\u001a\u00020%J\u000e\u0010|\u001a\u00020X2\u0006\u0010y\u001a\u00020\bJ\u0010\u0010}\u001a\u00020?2\u0006\u0010w\u001a\u00020%H\u0002J!\u0010~\u001a\u0004\u0018\u00010%2\u0006\u0010\u007f\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u00052\u0007\u0010\u0080\u0001\u001a\u00020\u000fR\u001b\u0010\u0007\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0011\u001a\u00020\u00128FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\f\u001a\u0004\b\u0013\u0010\u0014R\u001b\u0010\u0016\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\f\u001a\u0004\b\u0017\u0010\nR\u001b\u0010\u0019\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\f\u001a\u0004\b\u001a\u0010\nR \u0010\u001c\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001b\u0010!\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010\f\u001a\u0004\b\"\u0010\nR\u001d\u0010$\u001a\u0004\u0018\u00010%8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b(\u0010\f\u001a\u0004\b&\u0010'R\u001b\u0010)\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b+\u0010\f\u001a\u0004\b*\u0010\nR#\u0010,\u001a\n .*\u0004\u0018\u00010-0-8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b1\u0010\f\u001a\u0004\b/\u00100R\u001b\u00102\u001a\u00020%8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b4\u0010\f\u001a\u0004\b3\u0010'R\u001b\u00105\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b7\u0010\f\u001a\u0004\b6\u0010\nR\u001b\u00108\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b:\u0010\f\u001a\u0004\b9\u0010\nR\u001b\u0010;\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b=\u0010\f\u001a\u0004\b<\u0010\nR\u001a\u0010>\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020?0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010@\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020?0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010A\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010B0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010C\u001a\u00020?8F\u00a2\u0006\u0006\u001a\u0004\bC\u0010DR\u001b\u0010E\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bG\u0010\f\u001a\u0004\bF\u0010\nR \u0010H\u001a\u0014\u0012\u0004\u0012\u00020%\u0012\n\u0012\b\u0012\u0004\u0012\u00020I0\u001d0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bJ\u0010KR \u0010L\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020N0M0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010O\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bQ\u0010\f\u001a\u0004\bP\u0010\nR\u001b\u0010R\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bT\u0010\f\u001a\u0004\bS\u0010\nR\u001a\u0010U\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020V0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010W\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020X0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010Y\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010%0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010Z\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\\\u0010\f\u001a\u0004\b[\u0010\nR\u001b\u0010]\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b_\u0010\f\u001a\u0004\b^\u0010\nR\u001b\u0010`\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bb\u0010\f\u001a\u0004\ba\u0010\nR\u001b\u0010c\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\be\u0010\f\u001a\u0004\bd\u0010\n\u00a8\u0006\u0084\u0001"}, d2={"Lcom/airbnb/epoxy/processor/Memoizer;", "", "environment", "Landroidx/room/compiler/processing/XProcessingEnv;", "logger", "Lcom/airbnb/epoxy/processor/Logger;", "(Landroidx/room/compiler/processing/XProcessingEnv;Lcom/airbnb/epoxy/processor/Logger;)V", "androidViewType", "Landroidx/room/compiler/processing/XType;", "getAndroidViewType", "()Landroidx/room/compiler/processing/XType;", "androidViewType$delegate", "Lkotlin/Lazy;", "annotationsOnSuperView", "", "", "Lcom/airbnb/epoxy/processor/Memoizer$SuperViewAnnotations;", "baseBindWithDiffMethod", "Landroidx/room/compiler/processing/XMethodElement;", "getBaseBindWithDiffMethod", "()Landroidx/room/compiler/processing/XMethodElement;", "baseBindWithDiffMethod$delegate", "charSequenceNullableType", "getCharSequenceNullableType", "charSequenceNullableType$delegate", "charSequenceType", "getCharSequenceType", "charSequenceType$delegate", "classConstructors", "", "Lcom/airbnb/epoxy/processor/GeneratedModelInfo$ConstructorInfo;", "getEnvironment", "()Landroidx/room/compiler/processing/XProcessingEnv;", "epoxyControllerType", "getEpoxyControllerType", "epoxyControllerType$delegate", "epoxyDataBindingModelBaseClass", "Landroidx/room/compiler/processing/XTypeElement;", "getEpoxyDataBindingModelBaseClass", "()Landroidx/room/compiler/processing/XTypeElement;", "epoxyDataBindingModelBaseClass$delegate", "epoxyHolderType", "getEpoxyHolderType", "epoxyHolderType$delegate", "epoxyModelClassAnnotation", "Lcom/squareup/javapoet/ClassName;", "kotlin.jvm.PlatformType", "getEpoxyModelClassAnnotation", "()Lcom/squareup/javapoet/ClassName;", "epoxyModelClassAnnotation$delegate", "epoxyModelClassElementUntyped", "getEpoxyModelClassElementUntyped", "epoxyModelClassElementUntyped$delegate", "epoxyModelCollectorType", "getEpoxyModelCollectorType", "epoxyModelCollectorType$delegate", "epoxyModelWithHolderTypeUntyped", "getEpoxyModelWithHolderTypeUntyped", "epoxyModelWithHolderTypeUntyped$delegate", "generatedModelType", "getGeneratedModelType", "generatedModelType$delegate", "hasViewParentConstructorMap", "", "implementsModelCollectorMap", "inheritedEpoxyAttributes", "Lcom/airbnb/epoxy/processor/Memoizer$SuperClassAttributes;", "isKsp", "()Z", "iterableType", "getIterableType", "iterableType$delegate", "lightMethodsMap", "Lcom/airbnb/epoxy/processor/MethodInfoLight;", "getLogger", "()Lcom/airbnb/epoxy/processor/Logger;", "methodsReturningClassType", "", "Lcom/airbnb/epoxy/processor/MethodInfo;", "parisStyleType", "getParisStyleType", "parisStyleType$delegate", "stringAttributeType", "getStringAttributeType", "stringAttributeType$delegate", "typeMap", "Lcom/airbnb/epoxy/processor/Type;", "typeNameMap", "Lcom/squareup/javapoet/TypeName;", "validatedViewModelBaseElements", "viewOnCheckChangedType", "getViewOnCheckChangedType", "viewOnCheckChangedType$delegate", "viewOnClickListenerType", "getViewOnClickListenerType", "viewOnClickListenerType$delegate", "viewOnLongClickListenerType", "getViewOnLongClickListenerType", "viewOnLongClickListenerType$delegate", "viewType", "getViewType", "viewType$delegate", "getAnnotationsOnViewSuperClass", "superViewElement", "resourceProcessor", "Lcom/airbnb/epoxy/processor/resourcescanning/ResourceScanner;", "getClassConstructors", "classElement", "memoizer", "getDeclaredMethodsLight", "element", "getEpoxyAttributesOnElement", "getInheritedEpoxyAttributes", "Lcom/airbnb/epoxy/processor/AttributeInfo;", "originatingSuperClassType", "modelPackage", "includeSuperClass", "Lkotlin/Function1;", "getMethodsReturningClassType", "classType", "getType", "xType", "hasViewParentConstructor", "implementsModelCollector", "typeNameWithWorkaround", "validateSuperClassIsTypedCorrectly", "validateViewModelBaseClass", "baseModelType", "viewName", "SuperClassAttributes", "SuperViewAnnotations", "ViewElement", "epoxy-processor"})
public final class Memoizer {
    @NotNull
    private final XProcessingEnv environment;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Lazy androidViewType$delegate;
    @NotNull
    private final Lazy epoxyModelClassAnnotation$delegate;
    @NotNull
    private final Lazy generatedModelType$delegate;
    @NotNull
    private final Lazy viewOnClickListenerType$delegate;
    @NotNull
    private final Lazy viewOnLongClickListenerType$delegate;
    @NotNull
    private final Lazy viewOnCheckChangedType$delegate;
    @NotNull
    private final Lazy charSequenceType$delegate;
    @NotNull
    private final Lazy charSequenceNullableType$delegate;
    @NotNull
    private final Lazy iterableType$delegate;
    @NotNull
    private final Lazy stringAttributeType$delegate;
    @NotNull
    private final Lazy epoxyDataBindingModelBaseClass$delegate;
    @NotNull
    private final Lazy parisStyleType$delegate;
    @NotNull
    private final Lazy epoxyModelClassElementUntyped$delegate;
    @NotNull
    private final Lazy epoxyModelCollectorType$delegate;
    @NotNull
    private final Lazy epoxyControllerType$delegate;
    @NotNull
    private final Lazy epoxyModelWithHolderTypeUntyped$delegate;
    @NotNull
    private final Lazy epoxyHolderType$delegate;
    @NotNull
    private final Lazy viewType$delegate;
    @NotNull
    private final Lazy baseBindWithDiffMethod$delegate;
    @NotNull
    private final Map<String, Set<MethodInfo>> methodsReturningClassType;
    @NotNull
    private final Map<String, List<GeneratedModelInfo.ConstructorInfo>> classConstructors;
    @NotNull
    private final Map<String, XTypeElement> validatedViewModelBaseElements;
    @NotNull
    private final Map<String, SuperClassAttributes> inheritedEpoxyAttributes;
    @NotNull
    private final Map<String, SuperViewAnnotations> annotationsOnSuperView;
    @NotNull
    private final Map<XType, Type> typeMap;
    @NotNull
    private final Map<String, Boolean> implementsModelCollectorMap;
    @NotNull
    private final Map<String, Boolean> hasViewParentConstructorMap;
    @NotNull
    private final Map<XType, TypeName> typeNameMap;
    @NotNull
    private final Map<XTypeElement, List<MethodInfoLight>> lightMethodsMap;

    public Memoizer(@NotNull XProcessingEnv environment, @NotNull Logger logger2) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        this.environment = environment;
        this.logger = logger2;
        this.androidViewType$delegate = LazyKt.lazy((Function0)((Function0)new Function0<XType>(this){
            final /* synthetic */ Memoizer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final XType invoke() {
                return this.this$0.getEnvironment().requireType("android.view.View");
            }
        }));
        this.epoxyModelClassAnnotation$delegate = LazyKt.lazy((Function0)epoxyModelClassAnnotation.2.INSTANCE);
        this.generatedModelType$delegate = LazyKt.lazy((Function0)((Function0)new Function0<XType>(this){
            final /* synthetic */ Memoizer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final XType invoke() {
                return this.this$0.getEnvironment().requireType("com.airbnb.epoxy.GeneratedModel");
            }
        }));
        this.viewOnClickListenerType$delegate = LazyKt.lazy((Function0)((Function0)new Function0<XType>(this){
            final /* synthetic */ Memoizer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final XType invoke() {
                return this.this$0.getEnvironment().requireType("android.view.View.OnClickListener");
            }
        }));
        this.viewOnLongClickListenerType$delegate = LazyKt.lazy((Function0)((Function0)new Function0<XType>(this){
            final /* synthetic */ Memoizer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final XType invoke() {
                return this.this$0.getEnvironment().requireType("android.view.View.OnLongClickListener");
            }
        }));
        this.viewOnCheckChangedType$delegate = LazyKt.lazy((Function0)((Function0)new Function0<XType>(this){
            final /* synthetic */ Memoizer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final XType invoke() {
                return this.this$0.getEnvironment().requireType("android.widget.CompoundButton.OnCheckedChangeListener");
            }
        }));
        this.charSequenceType$delegate = LazyKt.lazy((Function0)((Function0)new Function0<XType>(this){
            final /* synthetic */ Memoizer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final XType invoke() {
                return this.this$0.getEnvironment().requireType(Reflection.getOrCreateKotlinClass(CharSequence.class));
            }
        }));
        this.charSequenceNullableType$delegate = LazyKt.lazy((Function0)((Function0)new Function0<XType>(this){
            final /* synthetic */ Memoizer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final XType invoke() {
                return this.this$0.getEnvironment().requireType(Reflection.getOrCreateKotlinClass(CharSequence.class)).makeNullable();
            }
        }));
        this.iterableType$delegate = LazyKt.lazy((Function0)((Function0)new Function0<XType>(this){
            final /* synthetic */ Memoizer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final XType invoke() {
                return this.this$0.getEnvironment().requireType(Reflection.getOrCreateKotlinClass(Iterable.class));
            }
        }));
        this.stringAttributeType$delegate = LazyKt.lazy((Function0)((Function0)new Function0<XType>(this){
            final /* synthetic */ Memoizer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final XType invoke() {
                return this.this$0.getEnvironment().requireType((TypeName)ClassNames.EPOXY_STRING_ATTRIBUTE_DATA);
            }
        }));
        this.epoxyDataBindingModelBaseClass$delegate = LazyKt.lazy((Function0)((Function0)new Function0<XTypeElement>(this){
            final /* synthetic */ Memoizer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final XTypeElement invoke() {
                return this.this$0.getEnvironment().findTypeElement((TypeName)ClassNames.EPOXY_DATA_BINDING_MODEL);
            }
        }));
        this.parisStyleType$delegate = LazyKt.lazy((Function0)((Function0)new Function0<XType>(this){
            final /* synthetic */ Memoizer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final XType invoke() {
                return this.this$0.getEnvironment().requireType((TypeName)ClassNames.PARIS_STYLE);
            }
        }));
        this.epoxyModelClassElementUntyped$delegate = LazyKt.lazy((Function0)((Function0)new Function0<XTypeElement>(this){
            final /* synthetic */ Memoizer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final XTypeElement invoke() {
                return this.this$0.getEnvironment().requireTypeElement((TypeName)ClassNames.EPOXY_MODEL_UNTYPED);
            }
        }));
        this.epoxyModelCollectorType$delegate = LazyKt.lazy((Function0)((Function0)new Function0<XType>(this){
            final /* synthetic */ Memoizer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final XType invoke() {
                return this.this$0.getEnvironment().requireType((TypeName)ClassNames.MODEL_COLLECTOR);
            }
        }));
        this.epoxyControllerType$delegate = LazyKt.lazy((Function0)((Function0)new Function0<XType>(this){
            final /* synthetic */ Memoizer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final XType invoke() {
                return this.this$0.getEnvironment().requireType("com.airbnb.epoxy.EpoxyController");
            }
        }));
        this.epoxyModelWithHolderTypeUntyped$delegate = LazyKt.lazy((Function0)((Function0)new Function0<XType>(this){
            final /* synthetic */ Memoizer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final XType invoke() {
                return this.this$0.getEnvironment().requireType((TypeName)ClassNames.INSTANCE.getEPOXY_MODEL_WITH_HOLDER_UNTYPED());
            }
        }));
        this.epoxyHolderType$delegate = LazyKt.lazy((Function0)((Function0)new Function0<XType>(this){
            final /* synthetic */ Memoizer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final XType invoke() {
                return this.this$0.getEnvironment().requireType("com.airbnb.epoxy.EpoxyHolder");
            }
        }));
        this.viewType$delegate = LazyKt.lazy((Function0)((Function0)new Function0<XType>(this){
            final /* synthetic */ Memoizer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final XType invoke() {
                return this.this$0.getEnvironment().requireType((TypeName)ClassNames.ANDROID_VIEW);
            }
        }));
        this.baseBindWithDiffMethod$delegate = LazyKt.lazy((Function0)((Function0)new Function0<XMethodElement>(this){
            final /* synthetic */ Memoizer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * Unable to fully structure code
             */
            @NotNull
            public final XMethodElement invoke() {
                block4: {
                    $this$firstOrNull$iv = this.this$0.getEpoxyModelClassElementUntyped().getDeclaredMethods();
                    $i$f$firstOrNull = false;
                    for (T element$iv : $this$firstOrNull$iv) {
                        it = (XMethodElement)element$iv;
                        $i$a$-firstOrNull-Memoizer$baseBindWithDiffMethod$2$1 = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)"bind") || it.getParameters().size() != 2) ** GOTO lbl-1000
                        v0 = ((XExecutableParameterElement)it.getParameters().get(1)).getType().getTypeElement();
                        if (Intrinsics.areEqual((Object)(v0 != null ? v0.getName() : null), (Object)"EpoxyModel")) {
                            v1 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v1 = false;
                        }
                        if (!v1) continue;
                        v2 = element$iv;
                        break block4;
                    }
                    v2 = null;
                }
                v3 = v2;
                if (v3 == null) {
                    throw new IllegalStateException("Unable to find bind function in epoxy model".toString());
                }
                return v3;
            }
        }));
        this.methodsReturningClassType = new LinkedHashMap();
        this.classConstructors = new LinkedHashMap();
        this.validatedViewModelBaseElements = new LinkedHashMap();
        this.inheritedEpoxyAttributes = new LinkedHashMap();
        this.annotationsOnSuperView = new LinkedHashMap();
        this.typeMap = new LinkedHashMap();
        this.implementsModelCollectorMap = new LinkedHashMap();
        this.hasViewParentConstructorMap = new LinkedHashMap();
        this.typeNameMap = new LinkedHashMap();
        this.lightMethodsMap = new LinkedHashMap();
    }

    @NotNull
    public final XProcessingEnv getEnvironment() {
        return this.environment;
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    public final boolean isKsp() {
        return this.environment.getBackend() == XProcessingEnv.Backend.KSP;
    }

    @NotNull
    public final XType getAndroidViewType() {
        Lazy lazy = this.androidViewType$delegate;
        return (XType)lazy.getValue();
    }

    public final ClassName getEpoxyModelClassAnnotation() {
        Lazy lazy = this.epoxyModelClassAnnotation$delegate;
        return (ClassName)lazy.getValue();
    }

    @NotNull
    public final XType getGeneratedModelType() {
        Lazy lazy = this.generatedModelType$delegate;
        return (XType)lazy.getValue();
    }

    @NotNull
    public final XType getViewOnClickListenerType() {
        Lazy lazy = this.viewOnClickListenerType$delegate;
        return (XType)lazy.getValue();
    }

    @NotNull
    public final XType getViewOnLongClickListenerType() {
        Lazy lazy = this.viewOnLongClickListenerType$delegate;
        return (XType)lazy.getValue();
    }

    @NotNull
    public final XType getViewOnCheckChangedType() {
        Lazy lazy = this.viewOnCheckChangedType$delegate;
        return (XType)lazy.getValue();
    }

    @NotNull
    public final XType getCharSequenceType() {
        Lazy lazy = this.charSequenceType$delegate;
        return (XType)lazy.getValue();
    }

    @NotNull
    public final XType getCharSequenceNullableType() {
        Lazy lazy = this.charSequenceNullableType$delegate;
        return (XType)lazy.getValue();
    }

    @NotNull
    public final XType getIterableType() {
        Lazy lazy = this.iterableType$delegate;
        return (XType)lazy.getValue();
    }

    @NotNull
    public final XType getStringAttributeType() {
        Lazy lazy = this.stringAttributeType$delegate;
        return (XType)lazy.getValue();
    }

    @Nullable
    public final XTypeElement getEpoxyDataBindingModelBaseClass() {
        Lazy lazy = this.epoxyDataBindingModelBaseClass$delegate;
        return (XTypeElement)lazy.getValue();
    }

    @NotNull
    public final XType getParisStyleType() {
        Lazy lazy = this.parisStyleType$delegate;
        return (XType)lazy.getValue();
    }

    @NotNull
    public final XTypeElement getEpoxyModelClassElementUntyped() {
        Lazy lazy = this.epoxyModelClassElementUntyped$delegate;
        return (XTypeElement)lazy.getValue();
    }

    @NotNull
    public final XType getEpoxyModelCollectorType() {
        Lazy lazy = this.epoxyModelCollectorType$delegate;
        return (XType)lazy.getValue();
    }

    @NotNull
    public final XType getEpoxyControllerType() {
        Lazy lazy = this.epoxyControllerType$delegate;
        return (XType)lazy.getValue();
    }

    @NotNull
    public final XType getEpoxyModelWithHolderTypeUntyped() {
        Lazy lazy = this.epoxyModelWithHolderTypeUntyped$delegate;
        return (XType)lazy.getValue();
    }

    @NotNull
    public final XType getEpoxyHolderType() {
        Lazy lazy = this.epoxyHolderType$delegate;
        return (XType)lazy.getValue();
    }

    @NotNull
    public final XType getViewType() {
        Lazy lazy = this.viewType$delegate;
        return (XType)lazy.getValue();
    }

    @NotNull
    public final XMethodElement getBaseBindWithDiffMethod() {
        Lazy lazy = this.baseBindWithDiffMethod$delegate;
        return (XMethodElement)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<MethodInfo> getMethodsReturningClassType(@NotNull XType classType, @NotNull Memoizer memoizer) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)classType, (String)"classType");
        Intrinsics.checkNotNullParameter((Object)memoizer, (String)"memoizer");
        XTypeElement xTypeElement = classType.getTypeElement();
        Intrinsics.checkNotNull((Object)xTypeElement);
        XTypeElement classElement = xTypeElement;
        Map<String, Set<MethodInfo>> map = this.methodsReturningClassType;
        String key$iv = classElement.getQualifiedName();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            Set set;
            void $this$mapNotNullTo$iv$iv;
            boolean bl = false;
            Iterable $this$mapNotNull$iv = classElement.getDeclaredMethods();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                MethodInfo methodInfo;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl2 = false;
                XMethodElement subElement = (XMethodElement)element$iv$iv;
                boolean bl3 = false;
                if (subElement.isPrivate() || subElement.isFinal() || subElement.isStatic()) {
                    methodInfo = null;
                } else {
                    XType methodReturnType = subElement.getReturnType();
                    if (!methodReturnType.isSameType(classType) && !XProcessingUtilsKt.isSubTypeOf(classType, methodReturnType)) {
                        methodInfo = null;
                    } else {
                        String methodName = subElement.getName();
                        if (Intrinsics.areEqual((Object)methodName, (Object)"reset") && subElement.getParameters().isEmpty()) {
                            methodInfo = null;
                        } else {
                            boolean isEpoxyAttribute = subElement.hasAnnotation(Reflection.getOrCreateKotlinClass(EpoxyAttribute.class));
                            methodInfo = new MethodInfo(methodName, XProcessingUtilsKt.getJavacModifiers((XHasModifiers)subElement), GeneratedModelInfo.Companion.buildParamSpecs(subElement.getParameters(), memoizer), subElement.isVarArgs(), isEpoxyAttribute, subElement);
                        }
                    }
                }
                if (methodInfo == null) continue;
                MethodInfo it$iv$iv = methodInfo;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List methodInfos = (List)destination$iv$iv;
            XType xType = classElement.getSuperType();
            if (xType == null) {
                set = SetsKt.emptySet();
            } else {
                XType superClassType = xType;
                set = SetsKt.plus((Set)CollectionsKt.toSet((Iterable)methodInfos), (Iterable)this.getMethodsReturningClassType(superClassType, memoizer));
            }
            Set answer$iv = set;
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (Set)object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<GeneratedModelInfo.ConstructorInfo> getClassConstructors(@NotNull XTypeElement classElement, @NotNull Memoizer memoizer) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)classElement, (String)"classElement");
        Intrinsics.checkNotNullParameter((Object)memoizer, (String)"memoizer");
        Map<String, List<GeneratedModelInfo.ConstructorInfo>> map = this.classConstructors;
        String key$iv = classElement.getQualifiedName();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            boolean bl = false;
            Iterable iterable = classElement.getConstructors();
            boolean $i$f$map = false;
            void var10_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void xConstructorElement;
                XConstructorElement xConstructorElement2 = (XConstructorElement)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(new GeneratedModelInfo.ConstructorInfo(XProcessingUtilsKt.getJavacModifiers((XHasModifiers)xConstructorElement), GeneratedModelInfo.Companion.buildParamSpecs(xConstructorElement.getParameters(), memoizer), xConstructorElement.isVarArgs()));
            }
            List answer$iv = (List)destination$iv$iv;
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (List)object;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final XTypeElement validateViewModelBaseClass(@NotNull XType baseModelType, @NotNull Logger logger2, @NotNull String viewName) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)baseModelType, (String)"baseModelType");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)viewName, (String)"viewName");
        XTypeElement xTypeElement = baseModelType.getTypeElement();
        Intrinsics.checkNotNull((Object)xTypeElement);
        XTypeElement baseModelElement = xTypeElement;
        Map<String, XTypeElement> map = this.validatedViewModelBaseElements;
        String key$iv = baseModelElement.getQualifiedName();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            XTypeElement xTypeElement2;
            boolean bl = false;
            if (!XProcessingUtilsKt.isEpoxyModel(baseModelType, this)) {
                XElement xElement = (XElement)baseModelElement;
                Object[] objectArray = new Object[3];
                Intrinsics.checkNotNullExpressionValue((Object)ModelView.class.getSimpleName(), (String)"ModelView::class.java.simpleName");
                objectArray[1] = baseModelType;
                objectArray[2] = viewName;
                logger2.logError(xElement, "The base model provided to an %s must extend EpoxyModel, but was %s (%s).", objectArray);
                xTypeElement2 = null;
            } else if (!this.validateSuperClassIsTypedCorrectly(baseModelElement)) {
                XElement xElement = (XElement)baseModelElement;
                Object[] objectArray = new Object[2];
                Intrinsics.checkNotNullExpressionValue((Object)ModelView.class.getSimpleName(), (String)"ModelView::class.java.simpleName");
                objectArray[1] = viewName;
                logger2.logError(xElement, "The base model provided to an %s must have View as its type (%s).", objectArray);
                xTypeElement2 = null;
            } else {
                xTypeElement2 = baseModelElement;
            }
            XTypeElement answer$iv = xTypeElement2;
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (XTypeElement)object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean validateSuperClassIsTypedCorrectly(XTypeElement classType) {
        boolean bl;
        List typeParameters = classType.getType().getTypeArguments();
        XType xType = (XType)CollectionsKt.singleOrNull((List)typeParameters);
        if (xType == null) {
            return false;
        }
        XType typeParam = xType;
        if (XProcessingUtilsKt.isObjectOrAny(typeParam)) return true;
        XType xType2 = typeParam.extendsBound();
        XType xType3 = xType2;
        if (xType2 == null) return true;
        XTypeElement xTypeElement = xType3.getTypeElement();
        xType3 = xTypeElement;
        if (xTypeElement == null) return true;
        XType xType4 = xType3.getType();
        if (xType4 == null) return true;
        XType xType5 = typeParam.extendsBound();
        if (xType5 != null && (xType5 = xType5.getTypeElement()) != null && (xType5 = xType5.getType()) != null) {
            if (XProcessingUtilsKt.isObjectOrAny(xType5)) {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        if (!XProcessingUtilsKt.isSubTypeOf(typeParam, this.getViewType())) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<AttributeInfo> getInheritedEpoxyAttributes(@NotNull XType originatingSuperClassType, @NotNull String modelPackage, @NotNull Logger logger2, @NotNull Function1<? super XTypeElement, Boolean> includeSuperClass) {
        Intrinsics.checkNotNullParameter((Object)originatingSuperClassType, (String)"originatingSuperClassType");
        Intrinsics.checkNotNullParameter((Object)modelPackage, (String)"modelPackage");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Intrinsics.checkNotNullParameter(includeSuperClass, (String)"includeSuperClass");
        List result = new ArrayList();
        XTypeElement currentSuperClassElement = null;
        currentSuperClassElement = originatingSuperClassType.getTypeElement();
        while (currentSuperClassElement != null) {
            List<AttributeInfo> attributes;
            SuperClassAttributes superClassAttributes;
            SuperClassAttributes superClassAttributes2 = superClassAttributes = this.getEpoxyAttributesOnElement(currentSuperClassElement, logger2);
            List<AttributeInfo> list = attributes = superClassAttributes2 != null ? superClassAttributes2.getSuperClassAttributes() : null;
            boolean bl = list != null ? !((Collection)list).isEmpty() : false;
            if (bl) {
                List<AttributeInfo> list2;
                Iterable<AttributeInfo> iterable;
                List<AttributeInfo> it = iterable = attributes;
                boolean bl2 = false;
                List<AttributeInfo> list3 = list2 = (Boolean)includeSuperClass.invoke((Object)currentSuperClassElement) != false ? iterable : null;
                if (list2 != null) {
                    void $this$filterTo$iv;
                    iterable = list2;
                    boolean $i$f$filterTo = false;
                    for (Object element$iv : $this$filterTo$iv) {
                        AttributeInfo it2 = (AttributeInfo)element$iv;
                        boolean bl3 = false;
                        if (!(!it2.isPackagePrivate() || Intrinsics.areEqual((Object)modelPackage, (Object)superClassAttributes.getSuperClassPackage()))) continue;
                        ((Collection)result).add(element$iv);
                    }
                    List cfr_ignored_0 = (List)((Collection)result);
                }
            }
            XType xType = currentSuperClassElement.getSuperType();
            currentSuperClassElement = xType != null ? xType.getTypeElement() : null;
        }
        return result;
    }

    public static /* synthetic */ List getInheritedEpoxyAttributes$default(Memoizer memoizer, XType xType, String string, Logger logger2, Function1 function1, int n, Object object) {
        if ((n & 8) != 0) {
            function1 = getInheritedEpoxyAttributes.1.INSTANCE;
        }
        return memoizer.getInheritedEpoxyAttributes(xType, string, logger2, (Function1<? super XTypeElement, Boolean>)function1);
    }

    /*
     * WARNING - void declaration
     */
    private final SuperClassAttributes getEpoxyAttributesOnElement(XTypeElement classElement, Logger logger2) {
        Object object;
        void $this$getOrPut$iv;
        Map<String, SuperClassAttributes> map = this.inheritedEpoxyAttributes;
        String key$iv = classElement.getQualifiedName();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            SuperClassAttributes superClassAttributes;
            boolean bl = false;
            if (!XProcessingUtilsKt.isEpoxyModel(classElement, this)) {
                superClassAttributes = null;
            } else {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                XFieldElement it;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                Iterable iterable = classElement.getDeclaredFields();
                boolean $i$f$filter = false;
                void var10_10 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (XFieldElement)element$iv$iv;
                    boolean bl2 = false;
                    if (!it.hasAnnotation(Reflection.getOrCreateKotlinClass(EpoxyAttribute.class))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (XFieldElement)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(EpoxyProcessor.Companion.buildAttributeInfo(it, logger2, this));
                }
                List attributes = (List)destination$iv$iv;
                superClassAttributes = new SuperClassAttributes(classElement.getPackageName(), attributes);
            }
            SuperClassAttributes answer$iv = superClassAttributes;
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (SuperClassAttributes)object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SuperViewAnnotations getAnnotationsOnViewSuperClass(@NotNull XTypeElement superViewElement, @NotNull Logger logger2, @NotNull ResourceScanner resourceProcessor2) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)superViewElement, (String)"superViewElement");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)resourceProcessor2, (String)"resourceProcessor");
        Map<String, SuperViewAnnotations> map = this.annotationsOnSuperView;
        String key$iv = superViewElement.getQualifiedName();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            String viewPackageName = superViewElement.getPackageName();
            Map annotatedElements = new LinkedHashMap();
            Iterable $this$forEach$iv = MemoizerKt.access$getViewModelAnnotations$p();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KClass annotation = (KClass)element$iv;
                boolean bl2 = false;
                Iterable $this$forEach$iv2 = XProcessingUtilsKt.getElementsAnnotatedWith(superViewElement, (KClass<? extends Annotation>)annotation);
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Object object2;
                    void $this$getOrPut$iv2;
                    XElement element = (XElement)element$iv2;
                    boolean bl3 = false;
                    Map map2 = annotatedElements;
                    boolean $i$f$getOrPut2 = false;
                    Object value$iv2 = $this$getOrPut$iv2.get(annotation);
                    if (value$iv2 == null) {
                        boolean bl4 = false;
                        List answer$iv = new ArrayList();
                        $this$getOrPut$iv2.put(annotation, answer$iv);
                        object2 = answer$iv;
                    } else {
                        object2 = value$iv2;
                    }
                    ((List)object2).add(new ViewElement(element, Utils.isFieldPackagePrivate(element), (Lazy<ViewAttributeInfo>)LazyKt.lazy((Function0)((Function0)new Function0<ViewAttributeInfo>(superViewElement, viewPackageName, element, logger2, resourceProcessor2, this){
                        final /* synthetic */ XTypeElement $superViewElement;
                        final /* synthetic */ String $viewPackageName;
                        final /* synthetic */ XElement $element;
                        final /* synthetic */ Logger $logger;
                        final /* synthetic */ ResourceScanner $resourceProcessor;
                        final /* synthetic */ Memoizer this$0;
                        {
                            this.$superViewElement = $superViewElement;
                            this.$viewPackageName = $viewPackageName;
                            this.$element = $element;
                            this.$logger = $logger;
                            this.$resourceProcessor = $resourceProcessor;
                            this.this$0 = $receiver;
                            super(0);
                        }

                        @NotNull
                        public final ViewAttributeInfo invoke() {
                            return new ViewAttributeInfo(this.$superViewElement, this.$viewPackageName, false, this.$element, this.$logger, this.$resourceProcessor, this.this$0);
                        }
                    }))));
                }
            }
            SuperViewAnnotations answer$iv = new SuperViewAnnotations(viewPackageName, annotatedElements);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (SuperViewAnnotations)object;
    }

    @NotNull
    public final Type getType(@NotNull XType xType) {
        Type type;
        Intrinsics.checkNotNullParameter((Object)xType, (String)"xType");
        Map<XType, Type> $this$getOrPut$iv = this.typeMap;
        boolean $i$f$getOrPut = false;
        Type value$iv = $this$getOrPut$iv.get(xType);
        if (value$iv == null) {
            boolean bl = false;
            Type answer$iv = new Type(xType, this);
            $this$getOrPut$iv.put(xType, answer$iv);
            type = answer$iv;
        } else {
            type = value$iv;
        }
        return type;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public final boolean implementsModelCollector(@NotNull XTypeElement classElement) {
        block9: {
            block8: {
                block7: {
                    Intrinsics.checkNotNullParameter((Object)classElement, (String)"classElement");
                    var2_2 = this.implementsModelCollectorMap;
                    key$iv = classElement.getQualifiedName();
                    $i$f$getOrPut = false;
                    value$iv = $this$getOrPut$iv.get(key$iv);
                    if (value$iv != null) break block8;
                    $i$a$-getOrPut-Memoizer$implementsModelCollector$1 = false;
                    $this$any$iv = classElement.getSuperInterfaceElements();
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        v0 = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            it = (XTypeElement)element$iv;
                            $i$a$-any-Memoizer$implementsModelCollector$1$1 = false;
                            if (!XProcessingUtilsKt.isEpoxyModelCollector(it.getType(), this)) continue;
                            v0 = true;
                            break block7;
                        }
                        v0 = false;
                    }
                }
                if (v0) ** GOTO lbl-1000
                v1 = classElement.getSuperType();
                if (v1 != null && (v1 = v1.getTypeElement()) != null) {
                    superClassElement = v1;
                    $i$a$-let-Memoizer$implementsModelCollector$1$2 = false;
                    v2 = this.implementsModelCollector((XTypeElement)superClassElement);
                } else {
                    v2 = false;
                }
                if (v2) lbl-1000:
                // 2 sources

                {
                    v3 = true;
                } else {
                    v3 = false;
                }
                answer$iv = v3;
                $this$getOrPut$iv.put(key$iv, answer$iv);
                v4 /* !! */  = answer$iv;
                break block9;
            }
            v4 /* !! */  = value$iv;
        }
        return (Boolean)v4 /* !! */ ;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean hasViewParentConstructor(@NotNull XTypeElement classElement) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)classElement, (String)"classElement");
        Map<String, Boolean> map = this.hasViewParentConstructorMap;
        String key$iv = classElement.getQualifiedName();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl;
            block5: {
                boolean bl2 = false;
                Iterable $this$any$iv = this.getClassConstructors(classElement, this);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        GeneratedModelInfo.ConstructorInfo it = (GeneratedModelInfo.ConstructorInfo)element$iv;
                        boolean bl3 = false;
                        if (!(it.getParams().size() == 1 && Intrinsics.areEqual((Object)it.getParams().get((int)0).type, (Object)ClassNames.INSTANCE.getVIEW_PARENT()))) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            Boolean answer$iv = bl;
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (Boolean)object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TypeName typeNameWithWorkaround(@NotNull XType xType) {
        TypeName typeName2;
        Intrinsics.checkNotNullParameter((Object)xType, (String)"xType");
        if (!this.isKsp()) {
            return xType.getTypeName();
        }
        Map<XType, TypeName> $this$getOrPut$iv = this.typeNameMap;
        boolean $i$f$getOrPut = false;
        TypeName value$iv = $this$getOrPut$iv.get(xType);
        if (value$iv == null) {
            TypeName typeName3;
            boolean bl = false;
            if (xType instanceof XArrayType) {
                ArrayTypeName arrayTypeName = ArrayTypeName.of((TypeName)TypeNameWorkaroundKt.typeNameWithWorkaround(((XArrayType)xType).getComponentType(), this));
                Intrinsics.checkNotNullExpressionValue((Object)arrayTypeName, (String)"of(xType.componentType.t\u2026NameWithWorkaround(this))");
                typeName3 = (TypeName)arrayTypeName;
            } else {
                TypeName original = xType.getTypeName();
                if (original.isPrimitive() || XTypeKt.isVoidObject((XType)xType) || XTypeKt.isVoid((XType)xType)) {
                    typeName3 = original;
                } else if (Intrinsics.areEqual((Object)xType.getClass().getSimpleName(), (Object)"KspTypeArgumentType")) {
                    typeName3 = original;
                } else {
                    Object $i$a$-runCatching-KspResourceScannerKt$getFieldWithReflectionOrNull$1$iv22;
                    XType $this$getFieldWithReflectionOrNull$iv;
                    XType xType2 = xType;
                    String fieldName$iv = "ksType";
                    boolean $i$f$getFieldWithReflectionOrNull = false;
                    try {
                        Object field$iv$iv;
                        boolean $i$a$-runCatching-KspResourceScannerKt$getFieldWithReflectionOrNull$1$iv22 = false;
                        void $this$getFieldWithReflection$iv$iv = $this$getFieldWithReflectionOrNull$iv;
                        boolean $i$f$getFieldWithReflection = false;
                        try {
                            field$iv$iv = $this$getFieldWithReflection$iv$iv.getClass().getDeclaredField(fieldName$iv);
                            ((Field)field$iv$iv).setAccessible(true);
                            field$iv$iv = ((Field)field$iv$iv).get($this$getFieldWithReflection$iv$iv);
                        }
                        catch (NoSuchFieldException e$iv$iv) {
                            Method method$iv$iv = $this$getFieldWithReflection$iv$iv.getClass().getMethod("get" + StringsKt.capitalize((String)fieldName$iv), new Class[0]);
                            method$iv$iv.setAccessible(true);
                            field$iv$iv = method$iv$iv.invoke((Object)$this$getFieldWithReflection$iv$iv, new Object[0]);
                        }
                        Object value$iv$iv = field$iv$iv;
                        if (!(value$iv$iv instanceof KSType)) {
                            boolean $i$a$-check-KspResourceScannerKt$getFieldWithReflection$1$iv$iv22 = false;
                            String $i$a$-check-KspResourceScannerKt$getFieldWithReflection$1$iv$iv22 = "Expected field '" + fieldName$iv + "' to be " + KSType.class.getSimpleName() + " but got a " + value$iv$iv.getClass().getSimpleName();
                            throw new IllegalStateException($i$a$-check-KspResourceScannerKt$getFieldWithReflection$1$iv$iv22.toString());
                        }
                        $i$a$-runCatching-KspResourceScannerKt$getFieldWithReflectionOrNull$1$iv22 = Result.constructor-impl((Object)value$iv$iv);
                    }
                    catch (Throwable $this$getFieldWithReflection$iv$iv) {
                        $i$a$-runCatching-KspResourceScannerKt$getFieldWithReflectionOrNull$1$iv22 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$getFieldWithReflection$iv$iv));
                    }
                    KSType kSType = (KSType)(Result.isFailure-impl((Object)$i$a$-runCatching-KspResourceScannerKt$getFieldWithReflectionOrNull$1$iv22) ? null : $i$a$-runCatching-KspResourceScannerKt$getFieldWithReflectionOrNull$1$iv22);
                    if (kSType == null) {
                        typeName3 = original;
                    } else {
                        Object object;
                        void $this$getFieldWithReflection$iv;
                        Object field$iv;
                        void $this$getFieldWithReflection$iv2;
                        KSType ksType = kSType;
                        $this$getFieldWithReflectionOrNull$iv = xType;
                        fieldName$iv = "env";
                        boolean $i$f$getFieldWithReflection = false;
                        try {
                            field$iv = $this$getFieldWithReflection$iv2.getClass().getDeclaredField(fieldName$iv);
                            ((Field)field$iv).setAccessible(true);
                            field$iv = ((Field)field$iv).get($this$getFieldWithReflection$iv2);
                        }
                        catch (NoSuchFieldException e$iv) {
                            Method method$iv = $this$getFieldWithReflection$iv2.getClass().getMethod("get" + StringsKt.capitalize((String)fieldName$iv), new Class[0]);
                            method$iv.setAccessible(true);
                            field$iv = method$iv.invoke((Object)$this$getFieldWithReflection$iv2, new Object[0]);
                        }
                        Object value$iv2 = field$iv;
                        if (!(value$iv2 instanceof XProcessingEnv)) {
                            boolean $i$a$-check-KspResourceScannerKt$getFieldWithReflection$1$iv22 = false;
                            String $i$a$-check-KspResourceScannerKt$getFieldWithReflection$1$iv22 = "Expected field '" + fieldName$iv + "' to be " + XProcessingEnv.class.getSimpleName() + " but got a " + value$iv2.getClass().getSimpleName();
                            throw new IllegalStateException($i$a$-check-KspResourceScannerKt$getFieldWithReflection$1$iv22.toString());
                        }
                        XProcessingEnv env = (XProcessingEnv)value$iv2;
                        fieldName$iv = env;
                        String fieldName$iv2 = "_resolver";
                        boolean $i$f$getFieldWithReflection2 = false;
                        try {
                            Field field$iv2 = $this$getFieldWithReflection$iv.getClass().getDeclaredField(fieldName$iv2);
                            field$iv2.setAccessible(true);
                            object = field$iv2.get($this$getFieldWithReflection$iv);
                        }
                        catch (NoSuchFieldException e$iv) {
                            Method method$iv = $this$getFieldWithReflection$iv.getClass().getMethod("get" + StringsKt.capitalize((String)fieldName$iv2), new Class[0]);
                            method$iv.setAccessible(true);
                            object = method$iv.invoke((Object)$this$getFieldWithReflection$iv, new Object[0]);
                        }
                        Object value$iv3 = object;
                        if (!(value$iv3 instanceof Resolver)) {
                            boolean bl2 = false;
                            String string = "Expected field '" + fieldName$iv2 + "' to be " + Resolver.class.getSimpleName() + " but got a " + value$iv3.getClass().getSimpleName();
                            throw new IllegalStateException(string.toString());
                        }
                        Resolver resolver = (Resolver)value$iv3;
                        typeName3 = TypeNameWorkaroundKt.tryBox(TypeNameWorkaroundKt.typeName(ksType, resolver));
                    }
                }
            }
            TypeName answer$iv = typeName3;
            $this$getOrPut$iv.put(xType, answer$iv);
            typeName2 = answer$iv;
        } else {
            typeName2 = value$iv;
        }
        return typeName2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<MethodInfoLight> getDeclaredMethodsLight(@NotNull XTypeElement element) {
        List list;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Map<XTypeElement, List<MethodInfoLight>> $this$getOrPut$iv = this.lightMethodsMap;
        boolean $i$f$getOrPut = false;
        List value$iv = $this$getOrPut$iv.get(element);
        if (value$iv == null) {
            List list2;
            boolean bl = false;
            if (this.isKsp()) {
                Object field$iv;
                void $this$getFieldWithReflection$iv;
                XTypeElement xTypeElement = element;
                String fieldName$iv = "declaration";
                boolean $i$f$getFieldWithReflection = false;
                try {
                    field$iv = $this$getFieldWithReflection$iv.getClass().getDeclaredField(fieldName$iv);
                    ((Field)field$iv).setAccessible(true);
                    field$iv = ((Field)field$iv).get($this$getFieldWithReflection$iv);
                }
                catch (NoSuchFieldException e$iv) {
                    Method method$iv = $this$getFieldWithReflection$iv.getClass().getMethod("get" + StringsKt.capitalize((String)fieldName$iv), new Class[0]);
                    method$iv.setAccessible(true);
                    field$iv = method$iv.invoke((Object)$this$getFieldWithReflection$iv, new Object[0]);
                }
                Object value$iv2 = field$iv;
                if (!(value$iv2 instanceof KSClassDeclaration)) {
                    boolean $i$a$-check-KspResourceScannerKt$getFieldWithReflection$1$iv22 = false;
                    String $i$a$-check-KspResourceScannerKt$getFieldWithReflection$1$iv22 = "Expected field '" + fieldName$iv + "' to be " + KSClassDeclaration.class.getSimpleName() + " but got a " + value$iv2.getClass().getSimpleName();
                    throw new IllegalStateException($i$a$-check-KspResourceScannerKt$getFieldWithReflection$1$iv22.toString());
                }
                list2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)UtilsKt.getDeclaredFunctions((KSClassDeclaration)((KSClassDeclaration)value$iv2)), (Function1)getDeclaredMethodsLight.1.1.INSTANCE));
            } else {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = element.getDeclaredMethods();
                boolean $i$f$map = false;
                Iterable $i$f$getFieldWithReflection = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    XMethodElement xMethodElement = (XMethodElement)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(new MethodInfoLight(it.getName(), it.getDocComment()));
                }
                list2 = (List)destination$iv$iv;
            }
            List answer$iv = list2;
            $this$getOrPut$iv.put(element, answer$iv);
            list = answer$iv;
        } else {
            list = value$iv;
        }
        return list;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/airbnb/epoxy/processor/Memoizer$SuperClassAttributes;", "", "superClassPackage", "", "superClassAttributes", "", "Lcom/airbnb/epoxy/processor/AttributeInfo;", "(Ljava/lang/String;Ljava/util/List;)V", "getSuperClassAttributes", "()Ljava/util/List;", "getSuperClassPackage", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "epoxy-processor"})
    public static final class SuperClassAttributes {
        @NotNull
        private final String superClassPackage;
        @NotNull
        private final List<AttributeInfo> superClassAttributes;

        public SuperClassAttributes(@NotNull String superClassPackage, @NotNull List<? extends AttributeInfo> superClassAttributes) {
            Intrinsics.checkNotNullParameter((Object)superClassPackage, (String)"superClassPackage");
            Intrinsics.checkNotNullParameter(superClassAttributes, (String)"superClassAttributes");
            this.superClassPackage = superClassPackage;
            this.superClassAttributes = superClassAttributes;
        }

        @NotNull
        public final String getSuperClassPackage() {
            return this.superClassPackage;
        }

        @NotNull
        public final List<AttributeInfo> getSuperClassAttributes() {
            return this.superClassAttributes;
        }

        @NotNull
        public final String component1() {
            return this.superClassPackage;
        }

        @NotNull
        public final List<AttributeInfo> component2() {
            return this.superClassAttributes;
        }

        @NotNull
        public final SuperClassAttributes copy(@NotNull String superClassPackage, @NotNull List<? extends AttributeInfo> superClassAttributes) {
            Intrinsics.checkNotNullParameter((Object)superClassPackage, (String)"superClassPackage");
            Intrinsics.checkNotNullParameter(superClassAttributes, (String)"superClassAttributes");
            return new SuperClassAttributes(superClassPackage, superClassAttributes);
        }

        public static /* synthetic */ SuperClassAttributes copy$default(SuperClassAttributes superClassAttributes, String string, List list, int n, Object object) {
            if ((n & 1) != 0) {
                string = superClassAttributes.superClassPackage;
            }
            if ((n & 2) != 0) {
                list = superClassAttributes.superClassAttributes;
            }
            return superClassAttributes.copy(string, list);
        }

        @NotNull
        public String toString() {
            return "SuperClassAttributes(superClassPackage=" + this.superClassPackage + ", superClassAttributes=" + this.superClassAttributes + ')';
        }

        public int hashCode() {
            int result = this.superClassPackage.hashCode();
            result = result * 31 + ((Object)this.superClassAttributes).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SuperClassAttributes)) {
                return false;
            }
            SuperClassAttributes superClassAttributes = (SuperClassAttributes)other;
            if (!Intrinsics.areEqual((Object)this.superClassPackage, (Object)superClassAttributes.superClassPackage)) {
                return false;
            }
            return Intrinsics.areEqual(this.superClassAttributes, superClassAttributes.superClassAttributes);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012 \u0010\u0004\u001a\u001c\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0005\u00a2\u0006\u0002\u0010\nR+\u0010\u0004\u001a\u001c\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/airbnb/epoxy/processor/Memoizer$SuperViewAnnotations;", "", "viewPackageName", "", "annotatedElements", "", "Lkotlin/reflect/KClass;", "", "", "Lcom/airbnb/epoxy/processor/Memoizer$ViewElement;", "(Ljava/lang/String;Ljava/util/Map;)V", "getAnnotatedElements", "()Ljava/util/Map;", "getViewPackageName", "()Ljava/lang/String;", "epoxy-processor"})
    public static final class SuperViewAnnotations {
        @NotNull
        private final String viewPackageName;
        @NotNull
        private final Map<KClass<? extends Annotation>, List<ViewElement>> annotatedElements;

        public SuperViewAnnotations(@NotNull String viewPackageName, @NotNull Map<KClass<? extends Annotation>, ? extends List<ViewElement>> annotatedElements) {
            Intrinsics.checkNotNullParameter((Object)viewPackageName, (String)"viewPackageName");
            Intrinsics.checkNotNullParameter(annotatedElements, (String)"annotatedElements");
            this.viewPackageName = viewPackageName;
            this.annotatedElements = annotatedElements;
        }

        @NotNull
        public final String getViewPackageName() {
            return this.viewPackageName;
        }

        @NotNull
        public final Map<KClass<? extends Annotation>, List<ViewElement>> getAnnotatedElements() {
            return this.annotatedElements;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u000eR\u001b\u0010\u000f\u001a\u00020\u00108FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lcom/airbnb/epoxy/processor/Memoizer$ViewElement;", "", "element", "Landroidx/room/compiler/processing/XElement;", "isPackagePrivate", "", "attributeInfo", "Lkotlin/Lazy;", "Lcom/airbnb/epoxy/processor/ViewAttributeInfo;", "(Landroidx/room/compiler/processing/XElement;ZLkotlin/Lazy;)V", "getAttributeInfo", "()Lkotlin/Lazy;", "getElement", "()Landroidx/room/compiler/processing/XElement;", "()Z", "simpleName", "", "getSimpleName", "()Ljava/lang/String;", "simpleName$delegate", "Lkotlin/Lazy;", "epoxy-processor"})
    public static final class ViewElement {
        @NotNull
        private final XElement element;
        private final boolean isPackagePrivate;
        @NotNull
        private final Lazy<ViewAttributeInfo> attributeInfo;
        @NotNull
        private final Lazy simpleName$delegate;

        public ViewElement(@NotNull XElement element, boolean isPackagePrivate, @NotNull Lazy<ViewAttributeInfo> attributeInfo) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter(attributeInfo, (String)"attributeInfo");
            this.element = element;
            this.isPackagePrivate = isPackagePrivate;
            this.attributeInfo = attributeInfo;
            this.simpleName$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
                final /* synthetic */ ViewElement this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return XProcessingUtilsKt.getExpectName(this.this$0.getElement());
                }
            }));
        }

        @NotNull
        public final XElement getElement() {
            return this.element;
        }

        public final boolean isPackagePrivate() {
            return this.isPackagePrivate;
        }

        @NotNull
        public final Lazy<ViewAttributeInfo> getAttributeInfo() {
            return this.attributeInfo;
        }

        @NotNull
        public final String getSimpleName() {
            Lazy lazy = this.simpleName$delegate;
            return (String)lazy.getValue();
        }
    }
}

