/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy.paging;

import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.paging.PagedList;
import com.airbnb.epoxy.EpoxyController;
import com.airbnb.epoxy.EpoxyModel;
import com.airbnb.epoxy.EpoxyViewHolder;
import java.util.Collections;
import java.util.List;

@Deprecated
public abstract class PagingEpoxyController<T>
extends EpoxyController {
    private static final PagedList.Config DEFAULT_CONFIG = new PagedList.Config.Builder().setEnablePlaceholders(false).setPageSize(100).setInitialLoadSizeHint(100).setPrefetchDistance(20).build();
    @Nullable
    private PagedList<T> pagedList;
    @NonNull
    private List<T> list = Collections.emptyList();
    private int lastBoundPositionWithinList = 0;
    private boolean scrollingTowardsEnd = true;
    private int lastBuiltLowerBound = 0;
    private int lastBuiltUpperBound = 0;
    @Nullable
    private PagedList.Config customConfig = null;
    private boolean isFirstBuildForList = true;
    private boolean hasNotifiedInsufficientPageSize;
    private final PagedList.Callback callback = new PagedList.Callback(){

        public void onChanged(int position, int count) {
            PagingEpoxyController.this.updatePagedListSnapshot();
        }

        public void onInserted(int position, int count) {
            PagingEpoxyController.this.updatePagedListSnapshot();
        }

        public void onRemoved(int position, int count) {
            PagingEpoxyController.this.updatePagedListSnapshot();
        }
    };

    protected final void buildModels() {
        int numItemsUntilStart;
        int leftOverItemsAtStart;
        int numListItemsToUse;
        int n = numListItemsToUse = this.isFirstBuildForList ? this.config().initialLoadSizeHint : this.config().pageSize;
        if (!this.list.isEmpty()) {
            this.isFirstBuildForList = false;
        }
        int numBoundViews = this.getAdapter().getBoundViewHolders().size();
        if (!this.hasNotifiedInsufficientPageSize && numBoundViews > numListItemsToUse) {
            this.onExceptionSwallowed(new IllegalStateException("The page size specified in your PagedList config is smaller than the number of items shown on screen. Increase your page size and/or initial load size."));
            this.hasNotifiedInsufficientPageSize = true;
        }
        float ratioOfEndItems = this.scrollingTowardsEnd ? 0.7f : 0.3f;
        int itemsToBuildTowardsEnd = (int)((float)numListItemsToUse * ratioOfEndItems);
        int itemsToBuildTowardsStart = numListItemsToUse - itemsToBuildTowardsEnd;
        int numItemsUntilEnd = this.list.size() - this.lastBoundPositionWithinList - 1;
        int leftOverItemsAtEnd = itemsToBuildTowardsEnd - numItemsUntilEnd;
        if (leftOverItemsAtEnd > 0) {
            itemsToBuildTowardsStart += leftOverItemsAtEnd;
            itemsToBuildTowardsEnd -= leftOverItemsAtEnd;
        }
        if ((leftOverItemsAtStart = itemsToBuildTowardsStart - (numItemsUntilStart = this.lastBoundPositionWithinList)) > 0) {
            itemsToBuildTowardsStart -= leftOverItemsAtStart;
            itemsToBuildTowardsEnd += leftOverItemsAtStart;
        }
        this.lastBuiltLowerBound = Math.max(this.lastBoundPositionWithinList - itemsToBuildTowardsStart, 0);
        this.lastBuiltUpperBound = Math.min(this.lastBoundPositionWithinList + itemsToBuildTowardsEnd, this.list.size());
        this.buildModels(this.list.subList(this.lastBuiltLowerBound, this.lastBuiltUpperBound));
    }

    protected abstract void buildModels(@NonNull List<T> var1);

    @CallSuper
    protected void onModelBound(@NonNull EpoxyViewHolder holder, @NonNull EpoxyModel<?> boundModel, int positionWithinCurrentModels, @Nullable EpoxyModel<?> previouslyBoundModel) {
        int positionWithinList = positionWithinCurrentModels + this.lastBuiltLowerBound;
        if (this.pagedList != null && !this.pagedList.isEmpty()) {
            this.pagedList.loadAround(positionWithinList);
        }
        this.scrollingTowardsEnd = this.lastBoundPositionWithinList < positionWithinList;
        this.lastBoundPositionWithinList = positionWithinList;
        int prefetchDistance = this.config().prefetchDistance;
        int distanceToEndOfPage = this.getAdapter().getItemCount() - positionWithinCurrentModels;
        int distanceToStartOfPage = positionWithinCurrentModels;
        if (distanceToEndOfPage < prefetchDistance && !this.hasBuiltLastItem() && this.scrollingTowardsEnd || distanceToStartOfPage < prefetchDistance && !this.hasBuiltFirstItem() && !this.scrollingTowardsEnd) {
            this.requestModelBuild();
        }
    }

    private boolean hasBuiltFirstItem() {
        return this.lastBuiltLowerBound == 0;
    }

    private boolean hasBuiltLastItem() {
        return this.lastBuiltUpperBound >= this.totalListSize();
    }

    public int totalListSize() {
        return this.pagedList != null ? this.pagedList.size() : this.list.size();
    }

    public void setList(@Nullable List<T> list) {
        if (list == this.list) {
            return;
        }
        if (this.pagedList != null) {
            this.setList((PagedList)null);
        }
        this.list = list == null ? Collections.emptyList() : list;
        this.isFirstBuildForList = true;
        this.requestModelBuild();
    }

    public void setList(@Nullable PagedList<T> list) {
        if (list == this.pagedList) {
            return;
        }
        PagedList<T> previousList = this.pagedList;
        this.pagedList = list;
        if (previousList != null) {
            previousList.removeWeakCallback(this.callback);
        }
        if (list != null) {
            list.addWeakCallback(null, this.callback);
        }
        this.isFirstBuildForList = true;
        this.updatePagedListSnapshot();
    }

    public void setConfig(@Nullable PagedList.Config config) {
        this.customConfig = config;
    }

    private PagedList.Config config() {
        if (this.customConfig != null) {
            return this.customConfig;
        }
        if (this.pagedList != null) {
            return this.pagedList.getConfig();
        }
        return DEFAULT_CONFIG;
    }

    @NonNull
    public List<T> getCurrentList() {
        return this.list;
    }

    @Nullable
    public PagedList<T> getPagedList() {
        return this.pagedList;
    }

    private void updatePagedListSnapshot() {
        this.list = this.pagedList == null ? Collections.emptyList() : this.pagedList.snapshot();
        this.requestModelBuild();
    }
}

