/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy.paging;

import android.annotation.SuppressLint;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import androidx.paging.AsyncPagedListDiffer;
import androidx.paging.PagedList;
import androidx.recyclerview.widget.AsyncDifferConfig;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.ListUpdateCallback;
import com.airbnb.epoxy.EpoxyController;
import com.airbnb.epoxy.EpoxyModel;
import com.airbnb.epoxy.paging.PagedListModelCache;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0002\u0016 \b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002Bs\u0012<\u0010\u0003\u001a8\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\b\u0012\u0015\u0012\u0013\u0018\u00018\u0000\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\t\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\u0004\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f\u0012\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\b\u0010\"\u001a\u00020\rH\u0002J\u0006\u0010#\u001a\u00020\rJ\b\u0010$\u001a\u00020\rH\u0002J\u0010\u0010%\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0&J\u000e\u0010'\u001a\u00020\r2\u0006\u0010(\u001a\u00020\u0005J(\u0010)\u001a\u00020\r2\f\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00000&2\u0010\u0010+\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0&H\u0002J\u0016\u0010,\u001a\u00020\r2\u000e\u0010-\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010.J\u0010\u0010/\u001a\u00020\r2\u0006\u0010(\u001a\u00020\u0005H\u0002R\u0018\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u00168\u0002X\u0083\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001bRD\u0010\u0003\u001a8\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\b\u0012\u0015\u0012\u0013\u0018\u00018\u0000\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\t\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u001c\u001a\u001e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\n0\u001dj\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\n`\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000 X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010!\u00a8\u00060"}, d2={"Lcom/airbnb/epoxy/paging/PagedListModelCache;", "T", "", "modelBuilder", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "itemIndex", "item", "Lcom/airbnb/epoxy/EpoxyModel;", "rebuildCallback", "Lkotlin/Function0;", "", "itemDiffCallback", "Landroidx/recyclerview/widget/DiffUtil$ItemCallback;", "diffExecutor", "Ljava/util/concurrent/Executor;", "modelBuildingHandler", "Landroid/os/Handler;", "(Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function0;Landroidx/recyclerview/widget/DiffUtil$ItemCallback;Ljava/util/concurrent/Executor;Landroid/os/Handler;)V", "asyncDiffer", "com/airbnb/epoxy/paging/PagedListModelCache$asyncDiffer$1", "Lcom/airbnb/epoxy/paging/PagedListModelCache$asyncDiffer$1;", "inSubmitList", "", "lastPosition", "Ljava/lang/Integer;", "modelCache", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "updateCallback", "com/airbnb/epoxy/paging/PagedListModelCache$updateCallback$1", "Lcom/airbnb/epoxy/paging/PagedListModelCache$updateCallback$1;", "assertUpdateCallbacksAllowed", "clearModels", "clearModelsSynchronized", "getModels", "", "loadAround", "position", "setCacheValues", "originatingList", "initialModels", "submitList", "pagedList", "Landroidx/paging/PagedList;", "triggerLoadAround", "epoxy-paging_release"})
public final class PagedListModelCache<T> {
    private final ArrayList<EpoxyModel<?>> modelCache;
    private Integer lastPosition;
    private boolean inSubmitList;
    private final updateCallback.1 updateCallback;
    @SuppressLint(value={"RestrictedApi"})
    private final asyncDiffer.1 asyncDiffer;
    private final Function2<Integer, T, EpoxyModel<?>> modelBuilder;
    private final Function0<Unit> rebuildCallback;
    private final DiffUtil.ItemCallback<T> itemDiffCallback;
    private final Executor diffExecutor;
    private final Handler modelBuildingHandler;

    private final void assertUpdateCallbacksAllowed() {
        boolean bl = this.inSubmitList || Intrinsics.areEqual((Object)Looper.myLooper(), (Object)this.modelBuildingHandler.getLooper());
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "The notify executor for your PagedList must use the same thread as the model building handler set in PagedListEpoxyController.modelBuildingHandler";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    public final synchronized void submitList(@Nullable PagedList<T> pagedList) {
        this.inSubmitList = true;
        this.asyncDiffer.submitList(pagedList);
        this.inSubmitList = false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final synchronized List<EpoxyModel<?>> getModels() {
        List currentList;
        PagedList pagedList = this.asyncDiffer.getCurrentList();
        List list = currentList = pagedList != null ? (List)pagedList : CollectionsKt.emptyList();
        if (Intrinsics.areEqual((Object)Looper.myLooper(), (Object)this.modelBuildingHandler.getLooper()) ^ true) {
            void $this$mapIndexedTo$iv$iv;
            Iterable $this$mapIndexed$iv = currentList;
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void item;
                void position;
                int n = index$iv$iv++;
                boolean bl = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Object t = item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                EpoxyModel epoxyModel = (EpoxyModel)this.modelBuilder.invoke((Object)((int)position), (Object)item);
                collection.add(epoxyModel);
            }
            List initialModels = (List)destination$iv$iv;
            this.modelBuildingHandler.post(new Runnable(this, currentList, initialModels){
                final /* synthetic */ PagedListModelCache this$0;
                final /* synthetic */ List $currentList;
                final /* synthetic */ List $initialModels;

                public final void run() {
                    PagedListModelCache.access$setCacheValues(this.this$0, this.$currentList, this.$initialModels);
                }
                {
                    this.this$0 = pagedListModelCache;
                    this.$currentList = list;
                    this.$initialModels = list2;
                }
            });
            return initialModels;
        }
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)this.modelCache.size());
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int position = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            if (this.modelCache.get(position) != null) continue;
            this.modelCache.set(position, (EpoxyModel<?>)this.modelBuilder.invoke((Object)position, currentList.get(position)));
        }
        Integer n = this.lastPosition;
        if (n != null) {
            Integer n3 = n;
            boolean bl = false;
            boolean bl3 = false;
            int it = ((Number)n3).intValue();
            boolean bl4 = false;
            this.triggerLoadAround(it);
        }
        ArrayList<EpoxyModel<?>> arrayList = this.modelCache;
        if (arrayList == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<com.airbnb.epoxy.EpoxyModel<*>>");
        }
        return arrayList;
    }

    private final synchronized void setCacheValues(List<? extends T> originatingList, List<? extends EpoxyModel<?>> initialModels) {
        if (this.asyncDiffer.getCurrentList() == originatingList) {
            this.modelCache.clear();
            this.modelCache.addAll((Collection)initialModels);
        }
    }

    public final void clearModels() {
        this.modelBuildingHandler.post(new Runnable(this){
            final /* synthetic */ PagedListModelCache this$0;

            public final void run() {
                PagedListModelCache.access$clearModelsSynchronized(this.this$0);
            }
            {
                this.this$0 = pagedListModelCache;
            }
        });
    }

    private final synchronized void clearModelsSynchronized() {
        List list = this.modelCache;
        Object t = null;
        boolean bl = false;
        Collections.fill(list, t);
    }

    public final void loadAround(int position) {
        this.triggerLoadAround(position);
        this.lastPosition = position;
    }

    private final void triggerLoadAround(int position) {
        block1: {
            PagedList pagedList = this.asyncDiffer.getCurrentList();
            if (pagedList == null) break block1;
            PagedList pagedList2 = pagedList;
            boolean bl = false;
            boolean bl2 = false;
            PagedList it = pagedList2;
            boolean bl3 = false;
            if (it.size() > 0) {
                it.loadAround(Math.min(position, it.size() - 1));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public PagedListModelCache(@NotNull Function2<? super Integer, ? super T, ? extends EpoxyModel<?>> modelBuilder, @NotNull Function0<Unit> rebuildCallback, @NotNull DiffUtil.ItemCallback<T> itemDiffCallback, @Nullable Executor diffExecutor, @NotNull Handler modelBuildingHandler) {
        void builder;
        Intrinsics.checkNotNullParameter(modelBuilder, (String)"modelBuilder");
        Intrinsics.checkNotNullParameter(rebuildCallback, (String)"rebuildCallback");
        Intrinsics.checkNotNullParameter(itemDiffCallback, (String)"itemDiffCallback");
        Intrinsics.checkNotNullParameter((Object)modelBuildingHandler, (String)"modelBuildingHandler");
        this.modelBuilder = modelBuilder;
        this.rebuildCallback = rebuildCallback;
        this.itemDiffCallback = itemDiffCallback;
        this.diffExecutor = diffExecutor;
        this.modelBuildingHandler = modelBuildingHandler;
        boolean bl = false;
        this.modelCache = new ArrayList();
        this.updateCallback = new ListUpdateCallback(this){
            final /* synthetic */ PagedListModelCache this$0;

            public void onChanged(int position, int count, @Nullable Object payload) {
                this.synchronizedWithCache((Function0<Unit>)((Function0)new Function0<Unit>(this, position, count){
                    final /* synthetic */ updateCallback.1 this$0;
                    final /* synthetic */ int $position;
                    final /* synthetic */ int $count;

                    public final void invoke() {
                        PagedListModelCache.access$assertUpdateCallbacksAllowed(this.this$0.this$0);
                        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)this.$position, (int)(this.$position + this.$count));
                        boolean $i$f$forEach = false;
                        Iterator<T> iterator = $this$forEach$iv.iterator();
                        while (iterator.hasNext()) {
                            int element$iv;
                            int it = element$iv = ((IntIterator)iterator).nextInt();
                            boolean bl = false;
                            PagedListModelCache.access$getModelCache$p(this.this$0.this$0).set(it, null);
                        }
                        PagedListModelCache.access$getRebuildCallback$p(this.this$0.this$0).invoke();
                    }
                    {
                        this.this$0 = var1_1;
                        this.$position = n;
                        this.$count = n2;
                        super(0);
                    }
                }));
            }

            public void onMoved(int fromPosition, int toPosition) {
                this.synchronizedWithCache((Function0<Unit>)((Function0)new Function0<Unit>(this, fromPosition, toPosition){
                    final /* synthetic */ updateCallback.1 this$0;
                    final /* synthetic */ int $fromPosition;
                    final /* synthetic */ int $toPosition;

                    public final void invoke() {
                        PagedListModelCache.access$assertUpdateCallbacksAllowed(this.this$0.this$0);
                        EpoxyModel model = (EpoxyModel)PagedListModelCache.access$getModelCache$p(this.this$0.this$0).remove(this.$fromPosition);
                        PagedListModelCache.access$getModelCache$p(this.this$0.this$0).add(this.$toPosition, model);
                        PagedListModelCache.access$getRebuildCallback$p(this.this$0.this$0).invoke();
                    }
                    {
                        this.this$0 = var1_1;
                        this.$fromPosition = n;
                        this.$toPosition = n2;
                        super(0);
                    }
                }));
            }

            public void onInserted(int position, int count) {
                this.synchronizedWithCache((Function0<Unit>)((Function0)new Function0<Unit>(this, count, position){
                    final /* synthetic */ updateCallback.1 this$0;
                    final /* synthetic */ int $count;
                    final /* synthetic */ int $position;

                    public final void invoke() {
                        PagedListModelCache.access$assertUpdateCallbacksAllowed(this.this$0.this$0);
                        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)this.$count);
                        boolean $i$f$forEach = false;
                        Iterator<T> iterator = $this$forEach$iv.iterator();
                        while (iterator.hasNext()) {
                            int element$iv;
                            int it = element$iv = ((IntIterator)iterator).nextInt();
                            boolean bl = false;
                            PagedListModelCache.access$getModelCache$p(this.this$0.this$0).add(this.$position, null);
                        }
                        PagedListModelCache.access$getRebuildCallback$p(this.this$0.this$0).invoke();
                    }
                    {
                        this.this$0 = var1_1;
                        this.$count = n;
                        this.$position = n2;
                        super(0);
                    }
                }));
            }

            public void onRemoved(int position, int count) {
                this.synchronizedWithCache((Function0<Unit>)((Function0)new Function0<Unit>(this, count, position){
                    final /* synthetic */ updateCallback.1 this$0;
                    final /* synthetic */ int $count;
                    final /* synthetic */ int $position;

                    public final void invoke() {
                        PagedListModelCache.access$assertUpdateCallbacksAllowed(this.this$0.this$0);
                        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)this.$count);
                        boolean $i$f$forEach = false;
                        Iterator<T> iterator = $this$forEach$iv.iterator();
                        while (iterator.hasNext()) {
                            int element$iv;
                            int it = element$iv = ((IntIterator)iterator).nextInt();
                            boolean bl = false;
                            PagedListModelCache.access$getModelCache$p(this.this$0.this$0).remove(this.$position);
                        }
                        PagedListModelCache.access$getRebuildCallback$p(this.this$0.this$0).invoke();
                    }
                    {
                        this.this$0 = var1_1;
                        this.$count = n;
                        this.$position = n2;
                        super(0);
                    }
                }));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void synchronizedWithCache(Function0<Unit> block) {
                PagedListModelCache pagedListModelCache = this.this$0;
                boolean bl = false;
                boolean bl2 = false;
                synchronized (pagedListModelCache) {
                    boolean bl3 = false;
                    block.invoke();
                    Unit unit = Unit.INSTANCE;
                }
            }
            {
                this.this$0 = this$0;
            }
        };
        AsyncDifferConfig.Builder builder2 = new AsyncDifferConfig.Builder(this.itemDiffCallback);
        boolean bl2 = false;
        boolean bl3 = false;
        AsyncDifferConfig.Builder builder3 = builder2;
        ListUpdateCallback listUpdateCallback = this.updateCallback;
        PagedListModelCache pagedListModelCache = this;
        PagedListModelCache pagedListModelCache2 = this;
        boolean bl4 = false;
        if (this.diffExecutor != null) {
            builder.setBackgroundThreadExecutor(this.diffExecutor);
        }
        builder.setMainThreadExecutor(new Executor(this){
            final /* synthetic */ PagedListModelCache this$0;
            {
                this.this$0 = pagedListModelCache;
            }

            public final void execute(@NotNull Runnable runnable) {
                Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
                PagedListModelCache.access$getModelBuildingHandler$p(this.this$0).post(runnable);
            }
        });
        Unit unit = Unit.INSTANCE;
        AsyncDifferConfig asyncDifferConfig = builder2.build();
        ListUpdateCallback listUpdateCallback2 = listUpdateCallback;
        PagedListModelCache pagedListModelCache3 = pagedListModelCache;
        pagedListModelCache2.asyncDiffer = new AsyncPagedListDiffer<T>(pagedListModelCache3, listUpdateCallback2, asyncDifferConfig){
            final /* synthetic */ PagedListModelCache this$0;
            {
                this.this$0 = this$0;
                super($super_call_param$1, $super_call_param$2);
                if (Intrinsics.areEqual((Object)PagedListModelCache.access$getModelBuildingHandler$p(this$0), (Object)EpoxyController.defaultModelBuildingHandler) ^ true) {
                    try {
                        Field mainThreadExecutorField;
                        Field field = mainThreadExecutorField = AsyncPagedListDiffer.class.getDeclaredField("mMainThreadExecutor");
                        Intrinsics.checkNotNullExpressionValue((Object)field, (String)"mainThreadExecutorField");
                        field.setAccessible(true);
                        mainThreadExecutorField.set((Object)((Object)this), new Executor(this){
                            final /* synthetic */ asyncDiffer.1 this$0;

                            public final void execute(Runnable it) {
                                PagedListModelCache.access$getModelBuildingHandler$p(this.this$0.this$0).post(it);
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        });
                    }
                    catch (Throwable t) {
                        String msg = "Failed to hijack update handler in AsyncPagedListDiffer.You can only build models on the main thread";
                        Log.e((String)"PagedListModelCache", (String)msg, (Throwable)t);
                        throw (Throwable)new IllegalStateException(msg, t);
                    }
                }
            }
        };
    }

    public /* synthetic */ PagedListModelCache(Function2 function2, Function0 function0, DiffUtil.ItemCallback itemCallback, Executor executor, Handler handler, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            executor = null;
        }
        this(function2, (Function0<Unit>)function0, itemCallback, executor, handler);
    }

    public static final /* synthetic */ void access$setCacheValues(PagedListModelCache $this, List originatingList, List initialModels) {
        $this.setCacheValues(originatingList, initialModels);
    }

    public static final /* synthetic */ void access$clearModelsSynchronized(PagedListModelCache $this) {
        $this.clearModelsSynchronized();
    }

    public static final /* synthetic */ void access$assertUpdateCallbacksAllowed(PagedListModelCache $this) {
        $this.assertUpdateCallbacksAllowed();
    }

    public static final /* synthetic */ ArrayList access$getModelCache$p(PagedListModelCache $this) {
        return $this.modelCache;
    }

    public static final /* synthetic */ Function0 access$getRebuildCallback$p(PagedListModelCache $this) {
        return $this.rebuildCallback;
    }

    public static final /* synthetic */ Handler access$getModelBuildingHandler$p(PagedListModelCache $this) {
        return $this.modelBuildingHandler;
    }
}

