/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.epoxy;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import androidx.annotation.NonNull;
import androidx.databinding.DataBindingUtil;
import androidx.databinding.ViewDataBinding;
import com.airbnb.epoxy.EpoxyHolder;
import com.airbnb.epoxy.EpoxyModel;
import com.airbnb.epoxy.EpoxyModelWithHolder;
import java.util.List;

public abstract class DataBindingEpoxyModel
extends EpoxyModelWithHolder<DataBindingHolder> {
    public View buildView(@NonNull ViewGroup parent) {
        LayoutInflater layoutInflater = LayoutInflater.from((Context)parent.getContext());
        ViewDataBinding binding = DataBindingUtil.inflate((LayoutInflater)layoutInflater, (int)this.getViewType(), (ViewGroup)parent, (boolean)false);
        View view = binding.getRoot();
        view.setTag((Object)binding);
        return view;
    }

    public void bind(@NonNull DataBindingHolder holder) {
        this.setDataBindingVariables(holder.dataBinding);
        holder.dataBinding.executePendingBindings();
    }

    public void bind(@NonNull DataBindingHolder holder, @NonNull EpoxyModel<?> previouslyBoundModel) {
        this.setDataBindingVariables(holder.dataBinding, previouslyBoundModel);
        holder.dataBinding.executePendingBindings();
    }

    public void bind(@NonNull DataBindingHolder holder, @NonNull List<Object> payloads) {
        this.setDataBindingVariables(holder.dataBinding, payloads);
        holder.dataBinding.executePendingBindings();
    }

    protected abstract void setDataBindingVariables(ViewDataBinding var1);

    protected void setDataBindingVariables(ViewDataBinding dataBinding, EpoxyModel<?> previouslyBoundModel) {
        this.setDataBindingVariables(dataBinding);
    }

    protected void setDataBindingVariables(ViewDataBinding dataBinding, List<Object> payloads) {
        this.setDataBindingVariables(dataBinding);
    }

    public void unbind(@NonNull DataBindingHolder holder) {
        holder.dataBinding.unbind();
    }

    protected final DataBindingHolder createNewHolder(@NonNull ViewParent parent) {
        return new DataBindingHolder();
    }

    public static class DataBindingHolder
    extends EpoxyHolder {
        private ViewDataBinding dataBinding;

        public ViewDataBinding getDataBinding() {
            return this.dataBinding;
        }

        protected void bindView(@NonNull View itemView) {
            this.dataBinding = (ViewDataBinding)itemView.getTag();
        }
    }
}

