/*
 * Copyright 2018-2022 AIR Software.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.airsoftware.saas.datasource.core;

import com.airsoftware.saas.datasource.annotation.SaaS;
import lombok.NonNull;
import org.aopalliance.aop.Advice;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.AbstractPointcutAdvisor;
import org.springframework.aop.support.ComposablePointcut;
import org.springframework.aop.support.annotation.AnnotationMatchingPointcut;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;

/**
 * SaaS数据源AOP织入
 *
 * @author bit
 */
public class SaaSDataSourceAnnotationAdvisor extends AbstractPointcutAdvisor implements BeanFactoryAware {
    
    private Advice advice;
    
    private Pointcut pointcut;
    
    public SaaSDataSourceAnnotationAdvisor(@NonNull SaaSDataSourceAnnotationInterceptor saasDataSourceAnnotationInterceptor) {
        this.advice = saasDataSourceAnnotationInterceptor;
        this.pointcut = buildPointcut();
    }
    
    @Override
    public Pointcut getPointcut() {
        return this.pointcut;
    }
    
    @Override
    public Advice getAdvice() {
        return this.advice;
    }
    
    @Override
    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (this.advice instanceof BeanFactoryAware) {
            ((BeanFactoryAware) this.advice).setBeanFactory(beanFactory);
        }
    }
    
    private Pointcut buildPointcut() {
        Pointcut cpc = new AnnotationMatchingPointcut(SaaS.class, true);
        Pointcut mpc = AnnotationMatchingPointcut.forMethodAnnotation(SaaS.class);
        return new ComposablePointcut(cpc).union(mpc);
    }
}
