/*
 * Decompiled with CFR 0.152.
 */
package com.airsoftware.saas.datasource.core;

import com.airsoftware.saas.datasource.annotation.SaaS;
import com.airsoftware.saas.datasource.context.SaaSDataSource;
import com.airsoftware.saas.datasource.provider.SaaSDataSourceProvider;
import com.airsoftware.saas.datasource.util.StringUtil;
import com.baomidou.dynamic.datasource.DynamicDataSourceClassResolver;
import com.baomidou.dynamic.datasource.DynamicRoutingDataSource;
import com.baomidou.dynamic.datasource.spel.DynamicDataSourceSpelParser;
import com.baomidou.dynamic.datasource.spel.DynamicDataSourceSpelResolver;
import com.baomidou.dynamic.datasource.toolkit.DynamicDataSourceContextHolder;
import java.lang.reflect.Method;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class SaaSDataSourceAnnotationInterceptor
implements MethodInterceptor {
    private static final Logger log = LoggerFactory.getLogger(SaaSDataSourceAnnotationInterceptor.class);
    private SaaSDataSourceProvider dynamicDataSourceProvider;
    private DynamicRoutingDataSource dynamicRoutingDataSource;
    private DynamicDataSourceSpelResolver dynamicDataSourceSpelResolver;
    private DynamicDataSourceSpelParser dynamicDataSourceSpelParser;
    private DynamicDataSourceClassResolver dynamicDataSourceClassResolver = new DynamicDataSourceClassResolver();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        try {
            String currentContext;
            String dsKeyField = this.getDsKeyField(invocation);
            String dsKey = "";
            if (RequestContextHolder.getRequestAttributes() != null) {
                HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
                String sessionValue = (String)request.getSession().getAttribute(dsKeyField);
                String string = dsKey = StringUtil.isNotBlank(sessionValue) ? sessionValue : request.getHeader(dsKeyField);
            }
            if (StringUtil.isNotBlank(currentContext = SaaSDataSource.current())) {
                dsKey = currentContext;
            }
            if (StringUtil.isNotBlank(dsKey)) {
                this.initDataSource(dsKey);
                DynamicDataSourceContextHolder.setDataSourceLookupKey((String)dsKey);
            }
            Object object = invocation.proceed();
            return object;
        }
        catch (Exception e) {
            log.error("An exception occurred during the invocation of @SaaS, data source will switch to default.", (Throwable)e);
            Object object = invocation.proceed();
            return object;
        }
        finally {
            DynamicDataSourceContextHolder.clearDataSourceLookupKey();
        }
    }

    private String getDsKeyField(MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        Class declaringClass = this.dynamicDataSourceClassResolver.targetClass(invocation);
        SaaS saas = method.isAnnotationPresent(SaaS.class) ? method.getAnnotation(SaaS.class) : (SaaS)AnnotationUtils.findAnnotation((Class)declaringClass, SaaS.class);
        Assert.notNull((Object)saas, (String)"Can not find @SaaS annotation, please ensure that you put the @SaaS annotation in right place.");
        return saas.value();
    }

    private void initDataSource(String dsKey) {
        Map dsMap = this.dynamicRoutingDataSource.getCurrentDataSources();
        if (dsMap != null && dsMap.containsKey(dsKey)) {
            return;
        }
        DataSource ds = this.dynamicDataSourceProvider.createDataSource(dsKey);
        this.dynamicRoutingDataSource.addDataSource(dsKey, ds);
    }

    public void setDynamicDataSourceProvider(SaaSDataSourceProvider dynamicDataSourceProvider) {
        this.dynamicDataSourceProvider = dynamicDataSourceProvider;
    }

    public void setDynamicRoutingDataSource(DynamicRoutingDataSource dynamicRoutingDataSource) {
        this.dynamicRoutingDataSource = dynamicRoutingDataSource;
    }

    public void setDynamicDataSourceSpelResolver(DynamicDataSourceSpelResolver dynamicDataSourceSpelResolver) {
        this.dynamicDataSourceSpelResolver = dynamicDataSourceSpelResolver;
    }

    public void setDynamicDataSourceSpelParser(DynamicDataSourceSpelParser dynamicDataSourceSpelParser) {
        this.dynamicDataSourceSpelParser = dynamicDataSourceSpelParser;
    }
}

